/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.EvictionAction;
import org.apache.geode.cache.EvictionAlgorithm;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.util.ObjectSizer;
import org.apache.geode.internal.InternalDataSerializer;

public class EvictionAttributesImpl
extends EvictionAttributes {
    private static final long serialVersionUID = -6404395520499379715L;
    private EvictionAlgorithm algorithm = EvictionAlgorithm.NONE;
    private ObjectSizer sizer;
    private volatile int maximum;
    private EvictionAction action = EvictionAction.NONE;

    public EvictionAttributesImpl() {
    }

    public EvictionAttributesImpl(EvictionAttributes other) {
        this.algorithm = other.getAlgorithm();
        this.sizer = other.getObjectSizer();
        this.maximum = other.getMaximum();
        this.action = other.getAction();
    }

    public EvictionAttributesImpl setAlgorithm(EvictionAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public EvictionAttributesImpl setObjectSizer(ObjectSizer memorySizer) {
        this.sizer = memorySizer;
        return this;
    }

    @Override
    public ObjectSizer getObjectSizer() {
        return this.sizer;
    }

    @Override
    public EvictionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public EvictionAttributesImpl setMaximum(int maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public int getMaximum() {
        if (this.algorithm.isLRUHeap()) {
            return 0;
        }
        return this.maximum;
    }

    public EvictionAttributesImpl setAction(EvictionAction action) {
        this.action = action != null ? action : EvictionAction.NONE;
        return this;
    }

    @Override
    public EvictionAction getAction() {
        return this.action;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.maximum);
        DataSerializer.writeObject(this.action, out);
        DataSerializer.writeObject(this.algorithm, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.maximum = in.readInt();
        this.action = (EvictionAction)DataSerializer.readObject(in);
        this.algorithm = (EvictionAlgorithm)DataSerializer.readObject(in);
    }

    public static EvictionAttributesImpl createFromData(DataInput in) throws IOException, ClassNotFoundException {
        EvictionAttributesImpl result = new EvictionAttributesImpl();
        InternalDataSerializer.invokeFromData(result, in);
        return result;
    }

    public boolean isLIFO() {
        return this.algorithm.isLIFO();
    }

    public boolean isLIFOEntry() {
        return this.algorithm == EvictionAlgorithm.LIFO_ENTRY;
    }

    public boolean isLIFOMemory() {
        return this.algorithm == EvictionAlgorithm.LIFO_MEMORY;
    }
}

