/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.internal.cache.DiskStoreMonitor;
import org.apache.geode.internal.cache.persistence.DefaultDiskDirs;

public class DiskStoreAttributes
implements Serializable,
DiskStore {
    private static final long serialVersionUID = 1L;
    public boolean allowForceCompaction = false;
    public boolean autoCompact = true;
    public int compactionThreshold = 50;
    public int queueSize = 0;
    public int writeBufferSize = 32768;
    public long maxOplogSizeInBytes = DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE * 0x100000L;
    public long timeInterval = 1000L;
    public int[] diskDirSizes;
    public File[] diskDirs = DefaultDiskDirs.getDefaultDiskDirs();
    public String name;
    private volatile float diskUsageWarningPct = 90.0f;
    private volatile float diskUsageCriticalPct = 99.0f;

    public DiskStoreAttributes() {
        this.diskDirSizes = DiskStoreFactory.DEFAULT_DISK_DIR_SIZES;
    }

    @Override
    public UUID getDiskStoreUUID() {
        throw new UnsupportedOperationException("Not Implemented!");
    }

    @Override
    public boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    @Override
    public boolean getAutoCompact() {
        return this.autoCompact;
    }

    @Override
    public int getCompactionThreshold() {
        return this.compactionThreshold;
    }

    @Override
    public int[] getDiskDirSizes() {
        int[] result = new int[this.diskDirSizes.length];
        System.arraycopy(this.diskDirSizes, 0, result, 0, this.diskDirSizes.length);
        return result;
    }

    @Override
    public File[] getDiskDirs() {
        File[] result = new File[this.diskDirs.length];
        System.arraycopy(this.diskDirs, 0, result, 0, this.diskDirs.length);
        return result;
    }

    @Override
    public long getMaxOplogSize() {
        return this.maxOplogSizeInBytes / 0x100000L;
    }

    public long getMaxOplogSizeInBytes() {
        return this.maxOplogSizeInBytes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void flush() {
    }

    @Override
    public void forceRoll() {
    }

    @Override
    public boolean forceCompaction() {
        return false;
    }

    @Override
    public void destroy() {
    }

    @Override
    public float getDiskUsageWarningPercentage() {
        return this.diskUsageWarningPct;
    }

    @Override
    public float getDiskUsageCriticalPercentage() {
        return this.diskUsageCriticalPct;
    }

    @Override
    public void setDiskUsageWarningPercentage(float warningPercent) {
        DiskStoreMonitor.checkWarning(warningPercent);
        this.diskUsageWarningPct = warningPercent;
    }

    @Override
    public void setDiskUsageCriticalPercentage(float criticalPercent) {
        DiskStoreMonitor.checkCritical(criticalPercent);
        this.diskUsageCriticalPct = criticalPercent;
    }
}

