/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.admin.GemFireHealth;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HealthMonitor;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminResponse;

public class FetchHealthDiagnosisResponse
extends AdminResponse {
    String[] diagnosis;

    public static FetchHealthDiagnosisResponse create(DistributionManager dm, InternalDistributedMember recipient, int id, GemFireHealth.Health healthCode) {
        FetchHealthDiagnosisResponse m = new FetchHealthDiagnosisResponse();
        m.setRecipient(recipient);
        HealthMonitor hm = dm.getHealthMonitor(recipient);
        if (hm.getId() == id) {
            m.diagnosis = hm.getDiagnosis(healthCode);
        }
        return m;
    }

    public String[] getDiagnosis() {
        return this.diagnosis;
    }

    @Override
    public int getDSFID() {
        return 1024;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeStringArray(this.diagnosis, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.diagnosis = DataSerializer.readStringArray(in);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FetchHealthDiagnosisResponse from ");
        sb.append(this.getRecipient());
        sb.append(" diagnosis=\"");
        for (int i = 0; i < this.diagnosis.length; ++i) {
            sb.append(this.diagnosis[i]);
            if (i >= this.diagnosis.length - 1) continue;
            sb.append(" ");
        }
        sb.append("\"");
        return sb.toString();
    }
}

