/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.admin.AlertLevel;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.AlertAppender;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class AlertLevelChangeMessage
extends SerialDistributionMessage {
    private static final Logger logger = LogService.getLogger();
    private int newLevel;

    public static AlertLevelChangeMessage create(int newLevel) {
        AlertLevelChangeMessage m = new AlertLevelChangeMessage();
        m.newLevel = newLevel;
        return m;
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        AlertAppender.getInstance().removeAlertListener(this.getSender());
        if (this.newLevel != Integer.MAX_VALUE) {
            AlertAppender.getInstance().addAlertListener(this.getSender(), this.newLevel);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "Added new AlertListener to application log writer");
            }
        }
    }

    @Override
    public int getDSFID() {
        return 1007;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.newLevel);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.newLevel = in.readInt();
    }

    @Override
    public String toString() {
        return LocalizedStrings.AlertLevelChangeMessage_CHANGING_ALERT_LEVEL_TO_0.toLocalizedString(AlertLevel.forSeverity(this.newLevel));
    }
}

