/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.CancelException;
import org.apache.geode.CanonicalInstantiator;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.GemFireIOException;
import org.apache.geode.GemFireRethrowable;
import org.apache.geode.Instantiator;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SerializationException;
import org.apache.geode.SystemFailure;
import org.apache.geode.ToDataException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.DistributedSystemService;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.LonerDistributionManager;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.DSCODE;
import org.apache.geode.internal.DSFIDFactory;
import org.apache.geode.internal.DataSerializableFixedID;
import org.apache.geode.internal.EmptyInputStreamFilter;
import org.apache.geode.internal.HeapDataOutputStream;
import org.apache.geode.internal.InputStreamFilter;
import org.apache.geode.internal.InternalInstantiator;
import org.apache.geode.internal.ObjectInputStreamFilterWrapper;
import org.apache.geode.internal.PdxSerializerObject;
import org.apache.geode.internal.Sendable;
import org.apache.geode.internal.SerializationVersions;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataStream;
import org.apache.geode.internal.VersionedObjectInput;
import org.apache.geode.internal.VersionedObjectOutput;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientDataSerializerMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.OldClientSupportService;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.lang.ClassUtils;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.util.concurrent.CopyOnWriteHashMap;
import org.apache.geode.pdx.NonPortableClassException;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializable;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.internal.AutoSerializableManager;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxInputStream;
import org.apache.geode.pdx.internal.PdxInstanceEnum;
import org.apache.geode.pdx.internal.PdxInstanceImpl;
import org.apache.geode.pdx.internal.PdxOutputStream;
import org.apache.geode.pdx.internal.PdxReaderImpl;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.PdxWriterImpl;
import org.apache.geode.pdx.internal.TypeRegistry;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public abstract class InternalDataSerializer
extends DataSerializer {
    private static final Logger logger = LogService.getLogger();
    private static final Map<String, DataSerializer> classesToSerializers = new ConcurrentHashMap<String, DataSerializer>();
    private static final String SANCTIONED_SERIALIZABLES_DEPENDENCIES_PATTERN = "java.**;javax.management.**;javax.print.attribute.EnumSyntax;antlr.**;org.apache.commons.modeler.AttributeInfo;org.apache.commons.modeler.FeatureInfo;org.apache.commons.modeler.ManagedBean;org.apache.geode.distributed.internal.DistributionConfigSnapshot;org.apache.geode.distributed.internal.RuntimeDistributionConfigImpl;org.apache.geode.distributed.internal.DistributionConfigImpl;org.apache.geode.distributed.internal.membership.InternalDistributedMember;org.apache.geode.internal.cache.persistence.PersistentMemberID;org.apache.geode.internal.cache.persistence.DiskStoreID;org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;org.apache.shiro.*;org.apache.shiro.authz.*;org.apache.shiro.authc.*;org.apache.logging.log4j.Level;org.apache.logging.log4j.spi.StandardLevel;com.sun.proxy.$Proxy*;com.healthmarketscience.rmiio.RemoteInputStream;javax.rmi.ssl.SslRMIClientSocketFactory;javax.net.ssl.SSLHandshakeException;javax.net.ssl.SSLException;sun.security.validator.ValidatorException;sun.security.provider.certpath.SunCertPathBuilderException;org.apache.geode.modules.util.SessionCustomExpiry;";
    private static InputStreamFilter defaultSerializationFilter;
    private static InputStreamFilter serializationFilter;
    private static final String serializationVersionTxt;
    private static OldClientSupportService oldClientSupportService;
    private static final SERIALIZATION_VERSION latestVersion;
    private static final SERIALIZATION_VERSION serializationVersion;
    private static final ConcurrentMap idsToSerializers;
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> dsClassesToHolders;
    private static final ConcurrentHashMap<Integer, SerializerAttributesHolder> idsToHolders;
    private static final ConcurrentHashMap<String, SerializerAttributesHolder> supportedClassesToHolders;
    private static volatile Set listeners;
    private static final Object listenersSync;
    private static final byte TIME_UNIT_NANOSECONDS = -1;
    private static final byte TIME_UNIT_MICROSECONDS = -2;
    private static final byte TIME_UNIT_MILLISECONDS = -3;
    private static final byte TIME_UNIT_SECONDS = -4;
    private static final ConcurrentMap dsfidToClassMap;
    public static final byte NULL_ARRAY = -1;
    private static final byte SHORT_ARRAY_LEN = -2;
    public static final byte INT_ARRAY_LEN = -3;
    private static final int MAX_BYTE_ARRAY_LEN = 252;
    private static DataSerializer dvddeserializer;
    private static final ThreadLocal<Boolean> pdxSerializationInProgress;
    private static final byte INT_VL = 126;
    private static final byte LONG_VL = 127;
    private static final int MAX_BYTE_VL = 125;
    public static final boolean LOAD_CLASS_EACH_TIME;
    private static final CopyOnWriteHashMap<String, WeakReference<Class<?>>> classCache;
    private static final Object cacheAccessLock;

    public static String processIncomingClassName(String name) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(oldPackage)) {
            return newPackage + name.substring(oldPackage.length());
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processIncomingClassName(name);
        }
        return name;
    }

    public static String processOutgoingClassName(String name, DataOutput out) {
        String oldPackage = "com.gemstone.org.jgroups.stack.tcpserver";
        String newPackage = "org.apache.geode.distributed.internal.tcpserver";
        if (name.startsWith(newPackage)) {
            return oldPackage + name.substring(newPackage.length());
        }
        OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
        if (svc != null) {
            return svc.processOutgoingClassName(name, out);
        }
        return name;
    }

    public static void initialize(DistributionConfig distributionConfig, Collection<DistributedSystemService> services) {
        logger.info("initializing InternalDataSerializer with {} services", (Object)services.size());
        if (distributionConfig.getValidateSerializableObjects()) {
            if (!ClassUtils.isClassAvailable("sun.misc.ObjectInputFilter") && !ClassUtils.isClassAvailable("java.io.ObjectInputFilter")) {
                throw new GemFireConfigException("A serialization filter has been specified but this version of Java does not support serialization filters - ObjectInputFilter is not available");
            }
            serializationFilter = new ObjectInputStreamFilterWrapper(SANCTIONED_SERIALIZABLES_DEPENDENCIES_PATTERN + distributionConfig.getSerializableObjectFilter() + ";!*", services);
        } else {
            InternalDataSerializer.clearSerializationFilter();
        }
    }

    private static void clearSerializationFilter() {
        serializationFilter = defaultSerializationFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> loadClassNames(URL sanctionedSerializables) throws IOException {
        ArrayList<String> result = new ArrayList<String>(1000);
        InputStream inputStream = sanctionedSerializables.openStream();
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader in = new BufferedReader(reader);
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.startsWith("//")) continue;
                line = line.replaceAll("/", ".");
                result.add(line.substring(0, line.indexOf(44)));
            }
        }
        finally {
            inputStream.close();
        }
        return result;
    }

    private static SERIALIZATION_VERSION calculateSerializationVersion() {
        if (serializationVersionTxt == null || serializationVersionTxt.isEmpty()) {
            return latestVersion;
        }
        if (serializationVersionTxt.startsWith("6.6.0") || serializationVersionTxt.startsWith("6.6.1")) {
            return SERIALIZATION_VERSION.v660;
        }
        if (serializationVersionTxt.startsWith("6.6.2")) {
            return SERIALIZATION_VERSION.v662;
        }
        return SERIALIZATION_VERSION.vINVALID;
    }

    public static boolean is662SerializationEnabled() {
        return serializationVersion.ordinal() >= SERIALIZATION_VERSION.v662.ordinal();
    }

    public static void checkSerializationVersion() {
        if (serializationVersion == SERIALIZATION_VERSION.vINVALID) {
            throw new IllegalArgumentException("The system property \"gemfire.serializationVersion\" was set to \"" + serializationVersionTxt + "\" which is not a valid serialization version. Valid versions must start with \"6.6.0\", \"6.6.1\", or \"6.6.2\"");
        }
    }

    private static void initializeWellKnownSerializers() {
        classesToSerializers.put("java.lang.String", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                try {
                    1.writeString((String)o, out);
                }
                catch (UTFDataFormatException ex) {
                    String s = "While writing a String of length " + ((String)o).length();
                    UTFDataFormatException ex2 = new UTFDataFormatException(s);
                    ex2.initCause(ex);
                    throw ex2;
                }
                return true;
            }
        });
        classesToSerializers.put("java.net.InetAddress", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                2.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet4Address", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                3.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.net.Inet6Address", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                InetAddress address = (InetAddress)o;
                out.writeByte(DSCODE.INET_ADDRESS.toByte());
                4.writeInetAddress(address, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Class", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Class c = (Class)o;
                if (c.isPrimitive()) {
                    InternalDataSerializer.writePrimitiveClass(c, out);
                } else {
                    out.writeByte(DSCODE.CLASS.toByte());
                    5.writeClass(c, out);
                }
                return true;
            }
        });
        classesToSerializers.put("java.lang.Boolean", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Boolean value = (Boolean)o;
                out.writeByte(DSCODE.BOOLEAN.toByte());
                6.writeBoolean(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Character", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Character value = (Character)o;
                out.writeByte(DSCODE.CHARACTER.toByte());
                7.writeCharacter(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Byte", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Byte value = (Byte)o;
                out.writeByte(DSCODE.BYTE.toByte());
                8.writeByte(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Short", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Short value = (Short)o;
                out.writeByte(DSCODE.SHORT.toByte());
                9.writeShort(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Integer", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Integer value = (Integer)o;
                out.writeByte(DSCODE.INTEGER.toByte());
                10.writeInteger(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Long", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Long value = (Long)o;
                out.writeByte(DSCODE.LONG.toByte());
                11.writeLong(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Float", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Float value = (Float)o;
                out.writeByte(DSCODE.FLOAT.toByte());
                12.writeFloat(value, out);
                return true;
            }
        });
        classesToSerializers.put("java.lang.Double", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Double value = (Double)o;
                out.writeByte(DSCODE.DOUBLE.toByte());
                13.writeDouble(value, out);
                return true;
            }
        });
        classesToSerializers.put("[Z", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.BOOLEAN_ARRAY.toByte());
                14.writeBooleanArray((boolean[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[B", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                byte[] array = (byte[])o;
                out.writeByte(DSCODE.BYTE_ARRAY.toByte());
                15.writeByteArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[C", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.CHAR_ARRAY.toByte());
                16.writeCharArray((char[])o, out);
                return true;
            }
        });
        classesToSerializers.put("[D", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                double[] array = (double[])o;
                out.writeByte(DSCODE.DOUBLE_ARRAY.toByte());
                17.writeDoubleArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[F", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                float[] array = (float[])o;
                out.writeByte(DSCODE.FLOAT_ARRAY.toByte());
                18.writeFloatArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[I", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                int[] array = (int[])o;
                out.writeByte(DSCODE.INT_ARRAY.toByte());
                19.writeIntArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[J", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                long[] array = (long[])o;
                out.writeByte(DSCODE.LONG_ARRAY.toByte());
                20.writeLongArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[S", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                short[] array = (short[])o;
                out.writeByte(DSCODE.SHORT_ARRAY.toByte());
                21.writeShortArray(array, out);
                return true;
            }
        });
        classesToSerializers.put("[Ljava.lang.String;", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                String[] array = (String[])o;
                out.writeByte(DSCODE.STRING_ARRAY.toByte());
                22.writeStringArray(array, out);
                return true;
            }
        });
        classesToSerializers.put(((Object)((Object)TimeUnit.NANOSECONDS)).getClass().getName(), new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TIME_UNIT.toByte());
                out.writeByte(-1);
                return true;
            }
        });
        classesToSerializers.put(((Object)((Object)TimeUnit.MICROSECONDS)).getClass().getName(), new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TIME_UNIT.toByte());
                out.writeByte(-2);
                return true;
            }
        });
        classesToSerializers.put(((Object)((Object)TimeUnit.MILLISECONDS)).getClass().getName(), new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TIME_UNIT.toByte());
                out.writeByte(-3);
                return true;
            }
        });
        classesToSerializers.put(((Object)((Object)TimeUnit.SECONDS)).getClass().getName(), new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TIME_UNIT.toByte());
                out.writeByte(-4);
                return true;
            }
        });
        classesToSerializers.put("java.util.Date", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Date date = (Date)o;
                out.writeByte(DSCODE.DATE.toByte());
                27.writeDate(date, out);
                return true;
            }
        });
        classesToSerializers.put("java.io.File", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                File file = (File)o;
                out.writeByte(DSCODE.FILE.toByte());
                28.writeFile(file, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.ArrayList", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                ArrayList list = (ArrayList)o;
                out.writeByte(DSCODE.ARRAY_LIST.toByte());
                29.writeArrayList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedList", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                LinkedList list = (LinkedList)o;
                out.writeByte(DSCODE.LINKED_LIST.toByte());
                30.writeLinkedList(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Vector", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.VECTOR.toByte());
                31.writeVector((Vector)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Stack", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.STACK.toByte());
                32.writeStack((Stack)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashSet", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                HashSet list = (HashSet)o;
                out.writeByte(DSCODE.HASH_SET.toByte());
                33.writeHashSet(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.LinkedHashSet", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.LINKED_HASH_SET.toByte());
                34.writeLinkedHashSet((LinkedHashSet)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.HashMap", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                HashMap list = (HashMap)o;
                out.writeByte(DSCODE.HASH_MAP.toByte());
                35.writeHashMap(list, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.IdentityHashMap", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.IDENTITY_HASH_MAP.toByte());
                36.writeIdentityHashMap((IdentityHashMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Hashtable", new WellKnownPdxDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.HASH_TABLE.toByte());
                37.writeHashtable((Hashtable)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.Properties", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                Properties props = (Properties)o;
                out.writeByte(DSCODE.PROPERTIES.toByte());
                38.writeProperties(props, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeMap", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TREE_MAP.toByte());
                39.writeTreeMap((TreeMap)o, out);
                return true;
            }
        });
        classesToSerializers.put("java.util.TreeSet", new WellKnownDS(){

            @Override
            public boolean toData(Object o, DataOutput out) throws IOException {
                out.writeByte(DSCODE.TREE_SET.toByte());
                40.writeTreeSet((TreeSet)o, out);
                return true;
            }
        });
        if (InternalDataSerializer.is662SerializationEnabled()) {
            classesToSerializers.put("java.math.BigInteger", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.BIG_INTEGER.toByte());
                    InternalDataSerializer.writeBigInteger((BigInteger)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.math.BigDecimal", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.BIG_DECIMAL.toByte());
                    InternalDataSerializer.writeBigDecimal((BigDecimal)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.util.UUID", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.UUID.toByte());
                    InternalDataSerializer.writeUUID((UUID)o, out);
                    return true;
                }
            });
            classesToSerializers.put("java.sql.Timestamp", new WellKnownDS(){

                @Override
                public boolean toData(Object o, DataOutput out) throws IOException {
                    out.writeByte(DSCODE.TIMESTAMP.toByte());
                    InternalDataSerializer.writeTimestamp((Timestamp)o, out);
                    return true;
                }
            });
        }
    }

    private static int ubyteToInt(byte ub) {
        return ub & 0xFF;
    }

    public static void setOldClientSupportService(OldClientSupportService svc) {
        oldClientSupportService = svc;
    }

    public static OldClientSupportService getOldClientSupportService() {
        return oldClientSupportService;
    }

    private static DataSerializer newInstance(Class c) {
        DataSerializer s;
        Constructor init;
        if (!DataSerializer.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_0_DOES_NOT_EXTEND_DATASERIALIZER.toLocalizedString(c.getName()));
        }
        try {
            init = c.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignored) {
            StringId s2 = LocalizedStrings.DataSerializer_CLASS_0_DOES_NOT_HAVE_A_ZEROARGUMENT_CONSTRUCTOR;
            Object[] args = new Object[]{c.getName()};
            if (c.getDeclaringClass() != null) {
                s2 = LocalizedStrings.DataSerializer_CLASS_0_DOES_NOT_HAVE_A_ZEROARGUMENT_CONSTRUCTOR_IT_IS_AN_INNER_CLASS_OF_1_SHOULD_IT_BE_A_STATIC_INNER_CLASS;
                args = new Object[]{c.getName(), c.getDeclaringClass()};
            }
            throw new IllegalArgumentException(s2.toLocalizedString(args));
        }
        try {
            init.setAccessible(true);
            s = (DataSerializer)init.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ignored) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_COULD_NOT_INSTANTIATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()));
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_COULD_NOT_INSTANTIATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(LocalizedStrings.DataSerializer_WHILE_INSTANTIATING_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
        }
        return s;
    }

    public static DataSerializer register(Class c, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        s.setEventId(eventId);
        s.setContext(context);
        return InternalDataSerializer._register(s, distribute);
    }

    public static DataSerializer register(Class c, boolean distribute) {
        DataSerializer s = InternalDataSerializer.newInstance(c);
        return InternalDataSerializer._register(s, distribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataSerializer _register(DataSerializer s, boolean distribute) {
        boolean retry;
        int id = s.getId();
        DataSerializer dsForMarkers = s;
        if (id == 0) {
            throw new IllegalArgumentException(LocalizedStrings.InternalDataSerializer_CANNOT_CREATE_A_DATASERIALIZER_WITH_ID_0.toLocalizedString());
        }
        Class<?>[] classes = s.getSupportedClasses();
        if (classes == null || classes.length == 0) {
            StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_0_HAS_NO_SUPPORTED_CLASSES_ITS_GETSUPPORTEDCLASSES_METHOD_MUST_RETURN_AT_LEAST_ONE_CLASS;
            throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
        }
        for (Class<?> aClass : classes) {
            if (aClass == null) {
                StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_GETSUPPORTEDCLASSES_METHOD_FOR_0_RETURNED_AN_ARRAY_THAT_CONTAINED_A_NULL_ELEMENT;
                throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
            }
            if (!aClass.isArray()) continue;
            StringId msg = LocalizedStrings.InternalDataSerializer_THE_DATASERIALIZER_GETSUPPORTEDCLASSES_METHOD_FOR_0_RETURNED_AN_ARRAY_THAT_CONTAINED_AN_ARRAY_CLASS_WHICH_IS_NOT_ALLOWED_SINCE_ARRAYS_HAVE_BUILTIN_SUPPORT;
            throw new IllegalArgumentException(msg.toLocalizedString(s.getClass().getName()));
        }
        Integer idx = id;
        Marker oldMarker = null;
        InitMarker m = new InitMarker();
        do {
            retry = false;
            InitMarker oldSerializer = idsToSerializers.putIfAbsent(idx, m);
            if (oldSerializer == null) continue;
            if (oldSerializer instanceof Marker) {
                boolean bl = retry = !idsToSerializers.replace(idx, oldSerializer, m);
                if (retry) continue;
                oldMarker = oldSerializer;
                continue;
            }
            if (oldSerializer.getClass().equals(s.getClass())) {
                if (distribute) {
                    InternalDataSerializer.sendRegistrationMessage(s);
                }
                return (DataSerializer)((Object)oldSerializer);
            }
            DataSerializer other = (DataSerializer)((Object)oldSerializer);
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_A_DATASERIALIZER_OF_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_THE_DATASERIALIZER_OF_CLASS_2_COULD_NOT_BE_REGISTERED.toLocalizedString(other.getClass().getName(), other.getId()));
        } while (retry);
        try {
            for (int i = 0; i < classes.length; ++i) {
                DataSerializer oldS = classesToSerializers.putIfAbsent(classes[i].getName(), s);
                if (oldS == null || s.equals(oldS)) continue;
                for (int j = 0; j < i; ++j) {
                    classesToSerializers.remove(classes[j].getName(), s);
                }
                dsForMarkers = null;
                String oldMsg = oldS.getId() == 0 ? "DataSerializer has built-in support for class " : "A DataSerializer of class " + oldS.getClass().getName() + " is already registered to support class ";
                String msg = oldMsg + classes[i].getName() + " so the DataSerializer of class " + s.getClass().getName() + " could not be registered.";
                if (oldS.getId() == 0) {
                    throw new IllegalArgumentException(msg);
                }
                throw new IllegalStateException(msg);
            }
        }
        finally {
            if (dsForMarkers == null) {
                idsToSerializers.remove(idx, m);
            } else {
                idsToSerializers.replace(idx, m, dsForMarkers);
            }
            if (oldMarker != null) {
                oldMarker.setSerializer(dsForMarkers);
            }
            m.setSerializer(dsForMarkers);
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && s.getEventId() == null) {
            s.setEventId(new EventID(cache.getDistributedSystem()));
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessage(s);
            InternalDataSerializer.sendRegistrationMessageToServers(s);
        }
        InternalDataSerializer.sendRegistrationMessageToClients(s);
        InternalDataSerializer.fireNewDataSerializer(s);
        return s;
    }

    public static void register(String className, boolean distribute, EventID eventId, ClientProxyMembershipID proxyId, int id) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder(className, eventId, proxyId, id));
    }

    public static void register(String className, boolean distribute) {
        InternalDataSerializer.register(className, distribute, new SerializerAttributesHolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String className, boolean distribute, SerializerAttributesHolder holder) {
        if (StringUtils.isBlank((String)className)) {
            throw new IllegalArgumentException("Class name cannot be null or empty.");
        }
        SerializerAttributesHolder oldValue = dsClassesToHolders.putIfAbsent(className, holder);
        if (oldValue != null && oldValue.getId() != 0 && holder.getId() != 0 && oldValue.getId() != holder.getId()) {
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_A_DATASERIALIZER_OF_CLASS_0_IS_ALREADY_REGISTERED_WITH_ID_1_SO_THE_DATASERIALIZER_OF_CLASS_2_COULD_NOT_BE_REGISTERED.toLocalizedString(oldValue.getClass().getName(), oldValue.getId()));
        }
        idsToHolders.putIfAbsent(holder.getId(), holder);
        Object ds = idsToSerializers.get(holder.getId());
        if (ds instanceof Marker) {
            Object v = ds;
            synchronized (v) {
                ((Marker)ds).notifyAll();
            }
        }
        if (distribute) {
            InternalDataSerializer.sendRegistrationMessageToServers(holder);
        }
    }

    public static void updateSupportedClassesMap(HashMap<Integer, ArrayList<String>> map) {
        for (Map.Entry<Integer, ArrayList<String>> e : map.entrySet()) {
            for (String supportedClassName : e.getValue()) {
                supportedClassesToHolders.putIfAbsent(supportedClassName, idsToHolders.get(e.getKey()));
            }
        }
    }

    public static void updateSupportedClassesMap(String dsClassName, String supportedClassName) {
        supportedClassesToHolders.putIfAbsent(supportedClassName, dsClassesToHolders.get(dsClassName));
    }

    private static void sendRegistrationMessageToServers(DataSerializer dataSerializer) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(dataSerializer);
    }

    private static void sendRegistrationMessageToServers(SerializerAttributesHolder holder) {
        PoolManagerImpl.allPoolsRegisterDataSerializers(holder);
    }

    private static void sendRegistrationMessageToClients(DataSerializer dataSerializer) {
        byte[][] serializedDataSerializer;
        block3: {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                return;
            }
            serializedDataSerializer = new byte[2][];
            try {
                serializedDataSerializer[0] = CacheServerHelper.serialize(dataSerializer.getClass().toString().substring(6));
                byte[] idBytes = new byte[4];
                Part.encodeInt(dataSerializer.getId(), idBytes);
                serializedDataSerializer[1] = idBytes;
            }
            catch (IOException ignored) {
                if (!logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) break block3;
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "InternalDataSerializer encountered an IOException while serializing DataSerializer :{}", (Object)dataSerializer);
            }
        }
        ClientDataSerializerMessage clientDataSerializerMessage = new ClientDataSerializerMessage(EnumListenerEvent.AFTER_REGISTER_DATASERIALIZER, serializedDataSerializer, (ClientProxyMembershipID)dataSerializer.getContext(), (EventID)dataSerializer.getEventId(), new Class[][]{dataSerializer.getSupportedClasses()});
        CacheClientNotifier.routeClientMessage(clientDataSerializerMessage);
    }

    public static EventID generateEventId() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            return null;
        }
        return new EventID(InternalDistributedSystem.getAnyInstance());
    }

    public static void unregister(int id) {
        Integer idx = id;
        Object o = idsToSerializers.remove(idx);
        if (o != null && o instanceof InitMarker) {
            o = ((Marker)o).getSerializer();
        }
        if (o instanceof DataSerializer) {
            Class<?>[] classes;
            DataSerializer s = (DataSerializer)o;
            for (Class<?> aClass : classes = s.getSupportedClasses()) {
                classesToSerializers.remove(aClass.getName(), s);
                supportedClassesToHolders.remove(aClass.getName());
            }
            dsClassesToHolders.remove(s.getClass().getName());
            idsToHolders.remove(idx);
        }
    }

    public static void reinitialize() {
        idsToSerializers.clear();
        classesToSerializers.clear();
        supportedClassesToHolders.clear();
        dsClassesToHolders.clear();
        idsToHolders.clear();
        InternalDataSerializer.initializeWellKnownSerializers();
    }

    private static DataSerializer getSerializer(Class c) {
        SerializerAttributesHolder sah;
        DataSerializer ds = classesToSerializers.get(c.getName());
        if (ds == null && (sah = supportedClassesToHolders.get(c.getName())) != null) {
            Class<?> dsClass = null;
            try {
                dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer serializer = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(dsClass.getName());
                idsToHolders.remove(serializer.getId());
                for (Class<?> clazz : serializer.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return serializer;
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
            }
        }
        return ds;
    }

    public static DataSerializer getSerializer(int id) {
        Integer idx = id;
        GetMarker marker = new GetMarker();
        DataSerializer result = null;
        boolean timedOut = false;
        SerializerAttributesHolder sah = idsToHolders.get(idx);
        while (result == null && !timedOut && sah == null) {
            GetMarker o = idsToSerializers.putIfAbsent(idx, marker);
            if (o == null) {
                result = marker.getSerializer();
                if (result != null) continue;
                timedOut = true;
                idsToSerializers.remove(idx, marker);
                continue;
            }
            if (o instanceof Marker) {
                result = ((Marker)o).getSerializer();
                continue;
            }
            result = (DataSerializer)((Object)o);
        }
        if (result == null && sah != null) {
            Class<?> dsClass = null;
            try {
                dsClass = InternalDataSerializer.getCachedClass(sah.getClassName());
                DataSerializer ds = InternalDataSerializer.register(dsClass, false);
                dsClassesToHolders.remove(sah.getClassName());
                idsToHolders.remove(id);
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                return ds;
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
            }
        }
        return result;
    }

    public static DataSerializer[] getSerializers() {
        int size = idsToSerializers.size();
        ArrayList<Object> coll = new ArrayList<Object>(size);
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            coll.add(v);
        }
        Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, SerializerAttributesHolder> entry = iterator.next();
            String name = entry.getKey();
            SerializerAttributesHolder holder = entry.getValue();
            try {
                Class<?> cl = InternalDataSerializer.getCachedClass(name);
                DataSerializer ds = holder.getEventId() != null ? InternalDataSerializer.register(cl, false, holder.getEventId(), holder.getProxyId()) : InternalDataSerializer.register(cl, false);
                coll.add(ds);
                iterator.remove();
                idsToHolders.remove(ds.getId());
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
            }
            catch (ClassNotFoundException ignored) {
                logger.info(LogMarker.SERIALIZER_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, name));
            }
        }
        return coll.toArray(new DataSerializer[coll.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public static SerializerAttributesHolder[] getSerializersForDistribution() {
        int size = idsToSerializers.size() + dsClassesToHolders.size();
        ArrayList<SerializerAttributesHolder> coll = new ArrayList<SerializerAttributesHolder>(size);
        for (Object v : idsToSerializers.values()) {
            void var3_3;
            if (v instanceof InitMarker) {
                DataSerializer dataSerializer = ((Marker)v).getSerializer();
            }
            if (!(var3_3 instanceof DataSerializer)) continue;
            DataSerializer s = (DataSerializer)var3_3;
            coll.add(new SerializerAttributesHolder(s.getClass().getName(), (EventID)s.getEventId(), (ClientProxyMembershipID)s.getContext(), s.getId()));
        }
        for (Map.Entry entry : dsClassesToHolders.entrySet()) {
            SerializerAttributesHolder v = (SerializerAttributesHolder)entry.getValue();
            coll.add(v);
        }
        return coll.toArray(new SerializerAttributesHolder[coll.size()]);
    }

    public static void saveRegistrations(DataOutput out) throws IOException {
        DataSerializer ds;
        for (Object v : idsToSerializers.values()) {
            if (v instanceof InitMarker) {
                v = ((Marker)v).getSerializer();
            }
            if (!(v instanceof DataSerializer)) continue;
            ds = (DataSerializer)v;
            out.writeInt(ds.getId());
            DataSerializer.writeClass(ds.getClass(), out);
        }
        if (!dsClassesToHolders.isEmpty()) {
            Iterator<Map.Entry<String, SerializerAttributesHolder>> iterator = dsClassesToHolders.entrySet().iterator();
            Class<?> dsClass = null;
            while (iterator.hasNext()) {
                try {
                    dsClass = InternalDataSerializer.getCachedClass(iterator.next().getKey());
                }
                catch (ClassNotFoundException ignored) {
                    logger.info(LogMarker.SERIALIZER_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.InternalDataSerializer_COULD_NOT_LOAD_DATASERIALIZER_CLASS_0, dsClass));
                    continue;
                }
                ds = InternalDataSerializer.register(dsClass, false);
                iterator.remove();
                idsToHolders.remove(ds.getId());
                for (Class<?> clazz : ds.getSupportedClasses()) {
                    supportedClassesToHolders.remove(clazz.getName());
                }
                out.writeInt(ds.getId());
                DataSerializer.writeClass(ds.getClass(), out);
            }
        }
        out.writeInt(0);
    }

    public static void loadRegistrations(DataInput in) throws IOException {
        while (in.readInt() != 0) {
            Class<?> dsClass = null;
            boolean skip = false;
            try {
                dsClass = DataSerializer.readClass(in);
            }
            catch (ClassNotFoundException ignored) {
                skip = true;
            }
            if (skip) continue;
            InternalDataSerializer.register(dsClass, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet<RegistrationListener> newSet = new HashSet<RegistrationListener>(listeners);
            newSet.add(l);
            listeners = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRegistrationListener(RegistrationListener l) {
        Object object = listenersSync;
        synchronized (object) {
            HashSet newSet = new HashSet(listeners);
            newSet.remove(l);
            listeners = newSet;
        }
    }

    private static void fireNewDataSerializer(DataSerializer ds) {
        for (Object listener1 : listeners) {
            RegistrationListener listener = (RegistrationListener)listener1;
            listener.newDataSerializer(ds);
        }
    }

    static void fireNewInstantiator(Instantiator instantiator) {
        for (Object listener1 : listeners) {
            RegistrationListener listener = (RegistrationListener)listener1;
            listener.newInstantiator(instantiator);
        }
    }

    private static void sendRegistrationMessage(DataSerializer s) {
        InternalDistributedSystem system = InternalDistributedSystem.getConnectedInstance();
        if (system != null) {
            RegistrationMessage m = new RegistrationMessage(s);
            system.getDistributionManager().putOutgoing(m);
        }
    }

    public static void writeDSFIDHeader(int dsfid, DataOutput out) throws IOException {
        if (dsfid == 0) {
            throw new IllegalStateException(LocalizedStrings.InternalDataSerializer_ATTEMPTED_TO_SERIALIZE_ILLEGAL_DSFID.toLocalizedString());
        }
        if (dsfid <= 127 && dsfid >= -128) {
            out.writeByte(DSCODE.DS_FIXED_ID_BYTE.toByte());
            out.writeByte(dsfid);
        } else if (dsfid <= Short.MAX_VALUE && dsfid >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.DS_FIXED_ID_SHORT.toByte());
            out.writeShort(dsfid);
        } else {
            out.writeByte(DSCODE.DS_FIXED_ID_INT.toByte());
            out.writeInt(dsfid);
        }
    }

    public static void writeDSFID(DataSerializableFixedID o, DataOutput out) throws IOException {
        int dsfid = o.getDSFID();
        if (dsfidToClassMap != null && logger.isTraceEnabled(LogMarker.SERIALIZER_WRITE_DSFID_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_WRITE_DSFID_VERBOSE, "writeDSFID {} class={}", (Object)dsfid, o.getClass());
            if (dsfid != Integer.MAX_VALUE && dsfid != 0) {
                String newClassName = o.getClass().getName();
                String existingClassName = dsfidToClassMap.putIfAbsent(dsfid, newClassName);
                if (existingClassName != null && !existingClassName.equals(newClassName)) {
                    logger.trace(LogMarker.SERIALIZER_WRITE_DSFID_VERBOSE, "dsfid={} is used for class {} and class {}", (Object)dsfid, (Object)existingClassName, (Object)newClassName);
                }
            }
        }
        if (dsfid == Integer.MAX_VALUE) {
            out.writeByte(DSCODE.DS_NO_FIXED_ID.toByte());
            DataSerializer.writeClass(o.getClass(), out);
        } else {
            InternalDataSerializer.writeDSFIDHeader(dsfid, out);
        }
        try {
            InternalDataSerializer.invokeToData(o, out);
        }
        catch (IOException | CancelException | GemFireRethrowable | ToDataException io) {
            throw io;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException("toData failed on dsfid=" + dsfid + " msg:" + t.getMessage(), t);
        }
    }

    private static boolean writeWellKnownObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        return InternalDataSerializer.writeUserObject(o, out, ensurePdxCompatibility);
    }

    private static boolean writeUserObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        Class<?> c = o.getClass();
        DataSerializer serializer = InternalDataSerializer.getSerializer(c);
        if (serializer != null) {
            boolean toDataResult;
            int id = serializer.getId();
            if (id != 0) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (id <= 127 && id >= -128) {
                    out.writeByte(DSCODE.USER_CLASS.toByte());
                    out.writeByte((byte)id);
                } else if (id <= Short.MAX_VALUE && id >= Short.MIN_VALUE) {
                    out.writeByte(DSCODE.USER_CLASS_2.toByte());
                    out.writeShort(id);
                } else {
                    out.writeByte(DSCODE.USER_CLASS_4.toByte());
                    out.writeInt(id);
                }
            } else if (ensurePdxCompatibility && !(serializer instanceof WellKnownPdxDS)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            }
            try {
                toDataResult = serializer.toData(o, out);
            }
            catch (IOException io) {
                if (serializer instanceof WellKnownDS) {
                    throw io;
                }
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + c, io);
            }
            catch (CancelException | GemFireRethrowable | ToDataException ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                throw new ToDataException("toData failed on DataSerializer with id=" + id + " for class " + c, t);
            }
            if (toDataResult) {
                return true;
            }
            throw new ToDataException(LocalizedStrings.DataSerializer_SERIALIZER_0_A_1_SAID_THAT_IT_COULD_SERIALIZE_AN_INSTANCE_OF_2_BUT_ITS_TODATA_METHOD_RETURNED_FALSE.toLocalizedString(serializer.getId(), serializer.getClass().getName(), o.getClass().getName()));
        }
        if (o instanceof byte[][]) {
            byte[][] byteArrays = (byte[][])o;
            out.writeByte(DSCODE.ARRAY_OF_BYTE_ARRAYS.toByte());
            InternalDataSerializer.writeArrayOfByteArrays(byteArrays, out);
            return true;
        }
        if (o instanceof Object[]) {
            Object[] array = (Object[])o;
            out.writeByte(DSCODE.OBJECT_ARRAY.toByte());
            InternalDataSerializer.writeObjectArray(array, out, ensurePdxCompatibility);
            return true;
        }
        if (InternalDataSerializer.is662SerializationEnabled() && (o.getClass().isEnum() || o.getClass().getSuperclass() != null && o.getClass().getSuperclass().isEnum())) {
            if (InternalDataSerializer.isPdxSerializationInProgress()) {
                InternalDataSerializer.writePdxEnum((Enum)o, out);
            } else {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                InternalDataSerializer.writeGemFireEnum((Enum)o, out);
            }
            return true;
        }
        PdxSerializer pdxSerializer = TypeRegistry.getPdxSerializer();
        return pdxSerializer != null && InternalDataSerializer.writePdx(out, null, o, pdxSerializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean autoSerialized(Object o, DataOutput out) throws IOException {
        AutoSerializableManager.AutoClassInfo aci;
        AutoSerializableManager asm = TypeRegistry.getAutoSerializableManager();
        if (asm != null && (aci = asm.getExistingClassInfo(o.getClass())) != null) {
            PdxWriterImpl writer;
            GemFireCacheImpl internalCache;
            block11: {
                internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                TypeRegistry tr = internalCache.getPdxRegistry();
                PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
                writer = new PdxWriterImpl(tr, o, aci, os);
                try {
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        boolean alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                asm.writeData(writer, o, aci);
                                break block11;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        asm.writeData(writer, o, aci);
                        break block11;
                    }
                    asm.writeData(writer, o, aci);
                }
                catch (CancelException | GemFireRethrowable | ToDataException | NonPortableClassException ex) {
                    throw ex;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    throw new ToDataException("PdxSerializer failed when calling toData on " + o.getClass(), t);
                }
            }
            int bytesWritten = writer.completeByteStreamGeneration();
            InternalDataSerializer.getDMStats(internalCache).incPdxSerialization(bytesWritten);
            if (!(out instanceof HeapDataOutputStream)) {
                writer.sendTo(out);
            }
            return true;
        }
        return false;
    }

    private static void checkPdxCompatible(Object o, boolean ensurePdxCompatibility) {
        if (ensurePdxCompatibility) {
            throw new NonPortableClassException("Instances of " + o.getClass() + " are not compatible with non-java PDX.");
        }
    }

    static boolean isGemfireObject(Object o) {
        return (o instanceof Function || o.getClass().getName().startsWith("org.apache.geode.")) && !(o instanceof PdxSerializerObject);
    }

    private static Object readUserObject(DataInput in, int serializerId) throws IOException, ClassNotFoundException {
        DataSerializer serializer = InternalDataSerializer.getSerializer(serializerId);
        if (serializer == null) {
            throw new IOException(LocalizedStrings.DataSerializer_SERIALIZER_0_IS_NOT_REGISTERED.toLocalizedString(serializerId));
        }
        return serializer.fromData(in);
    }

    public static void checkOut(DataOutput out) {
        if (out == null) {
            String s = "Null DataOutput";
            throw new NullPointerException(s);
        }
    }

    public static void checkIn(DataInput in) {
        if (in == null) {
            String s = "Null DataInput";
            throw new NullPointerException(s);
        }
    }

    public static void writeSet(Collection<?> set, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        int size = set == null ? -1 : set.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing HashSet with {} elements: {}", (Object)size, set);
        }
        if (size > 0) {
            for (Object element : set) {
                InternalDataSerializer.writeObject(element, out);
            }
        }
    }

    public static Set readSet(DataInput in) throws IOException, ClassNotFoundException {
        return InternalDataSerializer.readHashSet(in);
    }

    public static <E> boolean readCollection(DataInput in, Collection<E> c) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        int size = InternalDataSerializer.readArrayLength(in);
        if (size >= 0) {
            for (int index = 0; index < size; ++index) {
                Object element = DataSerializer.readObject(in);
                c.add(element);
            }
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read Collection with {} elements: {}", (Object)size, c);
            }
            return true;
        }
        return false;
    }

    public static void writeSetOfLongs(Set set, boolean hasLongIDs, DataOutput out) throws IOException {
        if (set == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(set.size());
            out.writeBoolean(hasLongIDs);
            for (Object aSet : set) {
                Long l = (Long)aSet;
                if (hasLongIDs) {
                    out.writeLong(l);
                    continue;
                }
                out.writeInt((int)l.longValue());
            }
        }
    }

    public static Set<Long> readSetOfLongs(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        HashSet<Long> result = new HashSet<Long>(size);
        boolean longIDs = in.readBoolean();
        for (int i = 0; i < size; ++i) {
            long l = longIDs ? in.readLong() : (long)in.readInt();
            result.add(l);
        }
        return result;
    }

    public static void writeListOfLongs(List list, boolean hasLongIDs, DataOutput out) throws IOException {
        if (list == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(list.size());
            out.writeBoolean(hasLongIDs);
            for (Object aList : list) {
                Long l = (Long)aList;
                if (hasLongIDs) {
                    out.writeLong(l);
                    continue;
                }
                out.writeInt((int)l.longValue());
            }
        }
    }

    public static List<Long> readListOfLongs(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            return null;
        }
        LinkedList<Long> result = new LinkedList<Long>();
        boolean longIDs = in.readBoolean();
        for (int i = 0; i < size; ++i) {
            long l = longIDs ? in.readLong() : (long)in.readInt();
            result.add(l);
        }
        return result;
    }

    public static void writePrimitiveClass(Class c, DataOutput out) throws IOException {
        if (c == Boolean.TYPE) {
            out.writeByte(DSCODE.BOOLEAN_TYPE.toByte());
        } else if (c == Character.TYPE) {
            out.writeByte(DSCODE.CHARACTER_TYPE.toByte());
        } else if (c == Byte.TYPE) {
            out.writeByte(DSCODE.BYTE_TYPE.toByte());
        } else if (c == Short.TYPE) {
            out.writeByte(DSCODE.SHORT_TYPE.toByte());
        } else if (c == Integer.TYPE) {
            out.writeByte(DSCODE.INTEGER_TYPE.toByte());
        } else if (c == Long.TYPE) {
            out.writeByte(DSCODE.LONG_TYPE.toByte());
        } else if (c == Float.TYPE) {
            out.writeByte(DSCODE.FLOAT_TYPE.toByte());
        } else if (c == Double.TYPE) {
            out.writeByte(DSCODE.DOUBLE_TYPE.toByte());
        } else if (c == Void.TYPE) {
            out.writeByte(DSCODE.VOID_TYPE.toByte());
        } else if (c == null) {
            out.writeByte(DSCODE.NULL.toByte());
        } else {
            throw new InternalGemFireError(LocalizedStrings.InternalDataSerializer_UNKNOWN_PRIMITIVE_TYPE_0.toLocalizedString(c.getName()));
        }
    }

    public static Class decodePrimitiveClass(byte typeCode) {
        if (typeCode == DSCODE.BOOLEAN_TYPE.toByte()) {
            return Boolean.TYPE;
        }
        if (typeCode == DSCODE.CHARACTER_TYPE.toByte()) {
            return Character.TYPE;
        }
        if (typeCode == DSCODE.BYTE_TYPE.toByte()) {
            return Byte.TYPE;
        }
        if (typeCode == DSCODE.SHORT_TYPE.toByte()) {
            return Short.TYPE;
        }
        if (typeCode == DSCODE.INTEGER_TYPE.toByte()) {
            return Integer.TYPE;
        }
        if (typeCode == DSCODE.LONG_TYPE.toByte()) {
            return Long.TYPE;
        }
        if (typeCode == DSCODE.FLOAT_TYPE.toByte()) {
            return Float.TYPE;
        }
        if (typeCode == DSCODE.DOUBLE_TYPE.toByte()) {
            return Double.TYPE;
        }
        if (typeCode == DSCODE.VOID_TYPE.toByte()) {
            return Void.TYPE;
        }
        if (typeCode == DSCODE.NULL.toByte()) {
            return null;
        }
        throw new InternalGemFireError(LocalizedStrings.InternalDataSerializer_UNEXPECTED_TYPECODE_0.toLocalizedString(typeCode));
    }

    private static TimeUnit readTimeUnit(DataInput in) throws IOException {
        TimeUnit unit;
        InternalDataSerializer.checkIn(in);
        byte type = in.readByte();
        switch (type) {
            case -1: {
                unit = TimeUnit.NANOSECONDS;
                break;
            }
            case -2: {
                unit = TimeUnit.MICROSECONDS;
                break;
            }
            case -3: {
                unit = TimeUnit.MILLISECONDS;
                break;
            }
            case -4: {
                unit = TimeUnit.SECONDS;
                break;
            }
            default: {
                throw new IOException(LocalizedStrings.DataSerializer_UNKNOWN_TIMEUNIT_TYPE_0.toLocalizedString(type));
            }
        }
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read TimeUnit: {}", (Object)unit);
        }
        return unit;
    }

    private static void writeTimestamp(Timestamp o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Timestamp: {}", (Object)o);
        }
        DataSerializer.writePrimitiveLong(o.getTime(), out);
    }

    private static Timestamp readTimestamp(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        Timestamp result = new Timestamp(DataSerializer.readPrimitiveLong(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read Timestamp: {}", (Object)result);
        }
        return result;
    }

    private static void writeUUID(UUID o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing UUID: {}", (Object)o);
        }
        DataSerializer.writePrimitiveLong(o.getMostSignificantBits(), out);
        DataSerializer.writePrimitiveLong(o.getLeastSignificantBits(), out);
    }

    private static UUID readUUID(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        long mb = DataSerializer.readPrimitiveLong(in);
        long lb = DataSerializer.readPrimitiveLong(in);
        UUID result = new UUID(mb, lb);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read UUID: {}", (Object)result);
        }
        return result;
    }

    private static void writeBigDecimal(BigDecimal o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing BigDecimal: {}", (Object)o);
        }
        DataSerializer.writeString(o.toString(), out);
    }

    private static BigDecimal readBigDecimal(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigDecimal result = new BigDecimal(DataSerializer.readString(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read BigDecimal: {}", (Object)result);
        }
        return result;
    }

    private static void writeBigInteger(BigInteger o, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing BigInteger: {}", (Object)o);
        }
        DataSerializer.writeByteArray(o.toByteArray(), out);
    }

    private static BigInteger readBigInteger(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        BigInteger result = new BigInteger(DataSerializer.readByteArray(in));
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read BigInteger: {}", (Object)result);
        }
        return result;
    }

    public static void writeUserDataSerializableHeader(int classId, DataOutput out) throws IOException {
        if (classId <= 127 && classId >= -128) {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE.toByte());
            out.writeByte(classId);
        } else if (classId <= Short.MAX_VALUE && classId >= Short.MIN_VALUE) {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE_2.toByte());
            out.writeShort(classId);
        } else {
            out.writeByte(DSCODE.USER_DATA_SERIALIZABLE_4.toByte());
            out.writeInt(classId);
        }
    }

    public static void writeCharArray(char[] array, int length, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut(out);
        if (array == null) {
            length = -1;
        }
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing char array of length {}", (Object)length);
        }
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                out.writeChar(array[i]);
            }
        }
    }

    public static boolean isSerializedNull(byte[] serializedForm) {
        return serializedForm.length == 1 && serializedForm[0] == DSCODE.NULL.toByte();
    }

    public static void basicWriteObject(Object o, DataOutput out, boolean ensurePdxCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE);
        if (isDebugEnabled_SERIALIZER) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "basicWriteObject: {}", o);
        }
        if (o == null) {
            out.writeByte(DSCODE.NULL.toByte());
        } else if (o instanceof DataSerializableFixedID) {
            InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
            DataSerializableFixedID dsfid = (DataSerializableFixedID)o;
            InternalDataSerializer.writeDSFID(dsfid, out);
        } else if (!InternalDataSerializer.autoSerialized(o, out)) {
            if (o instanceof DataSerializable.Replaceable) {
                Object replacement = ((DataSerializable.Replaceable)o).replace();
                InternalDataSerializer.basicWriteObject(replacement, out, ensurePdxCompatibility);
            } else if (o instanceof PdxSerializable) {
                InternalDataSerializer.writePdx(out, GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed."), o, null);
            } else if (o instanceof DataSerializable) {
                if (isDebugEnabled_SERIALIZER) {
                    logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing DataSerializable: {}", o);
                }
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                Class<?> c = o.getClass();
                int classId = InternalInstantiator.getClassId(c);
                if (classId != 0) {
                    InternalDataSerializer.writeUserDataSerializableHeader(classId, out);
                } else {
                    out.writeByte(DSCODE.DATA_SERIALIZABLE.toByte());
                    DataSerializer.writeClass(c, out);
                }
                DataSerializable ds = (DataSerializable)o;
                InternalDataSerializer.invokeToData(ds, out);
            } else if (o instanceof Sendable) {
                if (!(o instanceof PdxInstance) || o instanceof PdxInstanceEnum) {
                    InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                }
                ((Sendable)o).sendTo(out);
            } else if (!InternalDataSerializer.writeWellKnownObject(o, out, ensurePdxCompatibility)) {
                InternalDataSerializer.checkPdxCompatible(o, ensurePdxCompatibility);
                if (logger.isTraceEnabled(LogMarker.SERIALIZER_ANNOUNCE_TYPE_WRITTEN_VERBOSE)) {
                    logger.trace(LogMarker.SERIALIZER_ANNOUNCE_TYPE_WRITTEN_VERBOSE, "DataSerializer Serializing an instance of {}", (Object)o.getClass().getName());
                }
                if (InternalDataSerializer.disallowJavaSerialization() && o instanceof Serializable) {
                    throw new NotSerializableException(LocalizedStrings.DataSerializer_0_IS_NOT_DATASERIALIZABLE_AND_JAVA_SERIALIZATION_IS_DISALLOWED.toLocalizedString(o.getClass().getName()));
                }
                InternalDataSerializer.writeSerializableObject(o, out);
            }
        }
    }

    private static boolean disallowJavaSerialization() {
        Boolean v = (Boolean)DISALLOW_JAVA_SERIALIZATION.get();
        return v != null && v != false;
    }

    private static void writePdxEnum(Enum<?> e, DataOutput out) throws IOException {
        TypeRegistry tr = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.").getPdxRegistry();
        int eId = tr.getEnumId(e);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "write PdxEnum id={} enum={}", (Object)eId, e);
        }
        InternalDataSerializer.writePdxEnumId(eId, out);
    }

    public static void writePdxEnumId(int eId, DataOutput out) throws IOException {
        out.writeByte(DSCODE.PDX_ENUM.toByte());
        out.writeByte(eId >> 24);
        InternalDataSerializer.writeArrayLength(eId & 0xFFFFFF, out);
    }

    private static Object readPdxEnum(DataInput in) throws IOException {
        GemFireCacheImpl internalCache;
        TypeRegistry tr;
        Object result;
        byte dsId = in.readByte();
        int tmp = InternalDataSerializer.readArrayLength(in);
        int enumId = dsId << 24 | tmp & 0xFFFFFF;
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "read PdxEnum id={}", (Object)enumId);
        }
        if ((result = (tr = (internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.")).getPdxRegistry()).getEnumById(enumId)) instanceof PdxInstance) {
            InternalDataSerializer.getDMStats(internalCache).incPdxInstanceCreations();
        }
        return result;
    }

    private static void writeGemFireEnum(Enum<?> e, DataOutput out) throws IOException {
        boolean isGemFireObject = InternalDataSerializer.isGemfireObject(e);
        DataSerializer.writePrimitiveByte(isGemFireObject ? DSCODE.GEMFIRE_ENUM.toByte() : DSCODE.PDX_INLINE_ENUM.toByte(), out);
        DataSerializer.writeString(e.getDeclaringClass().getName(), out);
        DataSerializer.writeString(e.name(), out);
        if (!isGemFireObject) {
            InternalDataSerializer.writeArrayLength(e.ordinal(), out);
        }
    }

    private static Enum<?> readGemFireEnum(DataInput in) throws IOException, ClassNotFoundException {
        String className = DataSerializer.readString(in);
        String enumName = DataSerializer.readString(in);
        Class<?> c = InternalDataSerializer.getCachedClass(className);
        return Enum.valueOf(c, enumName);
    }

    private static Object readPdxInlineEnum(DataInput in) throws IOException, ClassNotFoundException {
        GemFireCacheImpl internalCache = GemFireCacheImpl.getInstance();
        if (internalCache != null && internalCache.getPdxReadSerializedByAnyGemFireServices()) {
            String className = DataSerializer.readString(in);
            String enumName = DataSerializer.readString(in);
            int enumOrdinal = InternalDataSerializer.readArrayLength(in);
            InternalDataSerializer.getDMStats(internalCache).incPdxInstanceCreations();
            return new PdxInstanceEnum(className, enumName, enumOrdinal);
        }
        Enum<?> e = InternalDataSerializer.readGemFireEnum(in);
        InternalDataSerializer.readArrayLength(in);
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSerializableObject(Object o, DataOutput out) throws IOException {
        out.writeByte(DSCODE.SERIALIZABLE.toByte());
        if (out instanceof ObjectOutputStream) {
            ((ObjectOutputStream)out).writeObject(o);
        } else {
            OutputStream stream;
            if (out instanceof OutputStream) {
                stream = (OutputStream)((Object)out);
            } else {
                final DataOutput out2 = out;
                stream = new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        out2.write(b);
                    }
                };
            }
            boolean wasDoNotCopy = false;
            if (out instanceof HeapDataOutputStream) {
                wasDoNotCopy = ((HeapDataOutputStream)out).setDoNotCopy(false);
            }
            try {
                Version v;
                ObjectOutput oos = new ObjectOutputStream(stream);
                if (stream instanceof VersionedDataStream && (v = ((VersionedDataStream)((Object)stream)).getVersion()) != null && v != Version.CURRENT) {
                    oos = new VersionedObjectOutput(oos, v);
                }
                oos.writeObject(o);
                oos.flush();
            }
            finally {
                if (wasDoNotCopy) {
                    ((HeapDataOutputStream)out).setDoNotCopy(true);
                }
            }
        }
    }

    public static void invokeToData(Object ds, DataOutput out) throws IOException {
        boolean isDSFID = ds instanceof DataSerializableFixedID;
        try {
            boolean invoked = false;
            Version v = InternalDataSerializer.getVersionForDataStreamOrNull(out);
            if (v != null && v != Version.CURRENT) {
                Version[] versions = null;
                if (ds instanceof SerializationVersions) {
                    SerializationVersions sv = (SerializationVersions)ds;
                    versions = sv.getSerializationVersions();
                }
                if (versions != null && versions.length > 0) {
                    for (Version version : versions) {
                        if (v.compareTo(version) >= 0) continue;
                        ds.getClass().getMethod("toDataPre_" + version.getMethodSuffix(), DataOutput.class).invoke(ds, out);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                if (isDSFID) {
                    ((DataSerializableFixedID)ds).toData(out);
                } else {
                    ((DataSerializable)ds).toData(out);
                }
            }
        }
        catch (IOException io) {
            if (isDSFID) {
                throw io;
            }
            throw new ToDataException("toData failed on DataSerializable " + ds.getClass(), io);
        }
        catch (CancelException | GemFireRethrowable | ToDataException ex) {
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            throw new ToDataException("toData failed on DataSerializable " + ds.getClass(), t);
        }
    }

    public static void invokeFromData(Object ds, DataInput in) throws IOException, ClassNotFoundException {
        try {
            boolean invoked = false;
            Version v = InternalDataSerializer.getVersionForDataStreamOrNull(in);
            if (v != null && v != Version.CURRENT) {
                Version[] versions = null;
                if (ds instanceof SerializationVersions) {
                    SerializationVersions vds = (SerializationVersions)ds;
                    versions = vds.getSerializationVersions();
                }
                if (versions != null && versions.length > 0) {
                    for (Version version : versions) {
                        if (v.compareTo(version) >= 0) continue;
                        ds.getClass().getMethod("fromDataPre_" + version.getMethodSuffix(), DataInput.class).invoke(ds, in);
                        invoked = true;
                        break;
                    }
                }
            }
            if (!invoked) {
                if (ds instanceof DataSerializableFixedID) {
                    ((DataSerializableFixedID)ds).fromData(in);
                } else {
                    ((DataSerializable)ds).fromData(in);
                }
            }
        }
        catch (EOFException | ClassNotFoundException | CacheClosedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(ds.getClass().getName()), ex);
        }
    }

    private static Object readDataSerializable(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = InternalDataSerializer.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            Assert.assertTrue(o instanceof DataSerializable);
            InternalDataSerializer.invokeFromData(o, in);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read DataSerializable {}", o);
            }
            return o;
        }
        catch (EOFException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
        }
    }

    private static Object readDataSerializableFixedID(DataInput in) throws IOException, ClassNotFoundException {
        Class<?> c = InternalDataSerializer.readClass(in);
        try {
            Constructor<?> init = c.getConstructor(new Class[0]);
            init.setAccessible(true);
            Object o = init.newInstance(new Object[0]);
            InternalDataSerializer.invokeFromData(o, in);
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read DataSerializableFixedID {}", o);
            }
            return o;
        }
        catch (Exception ex) {
            throw new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_CREATE_AN_INSTANCE_OF_0.toLocalizedString(c.getName()), ex);
        }
    }

    public static Version getVersionForDataStream(DataInput in) {
        if (in instanceof VersionedDataStream) {
            Version v = ((VersionedDataStream)((Object)in)).getVersion();
            return v != null ? v : Version.CURRENT;
        }
        return Version.CURRENT;
    }

    public static Version getVersionForDataStreamOrNull(DataInput in) {
        if (in instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)in)).getVersion();
        }
        return null;
    }

    public static Version getVersionForDataStream(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            Version v = ((VersionedDataStream)((Object)out)).getVersion();
            return v != null ? v : Version.CURRENT;
        }
        return Version.CURRENT;
    }

    public static Version getVersionForDataStreamOrNull(DataOutput out) {
        if (out instanceof VersionedDataStream) {
            return ((VersionedDataStream)((Object)out)).getVersion();
        }
        return null;
    }

    public static void writeArrayLength(int len, DataOutput out) throws IOException {
        if (len == -1) {
            out.writeByte(-1);
        } else if (len <= 252) {
            out.writeByte(len);
        } else if (len <= 65535) {
            out.writeByte(-2);
            out.writeShort(len);
        } else {
            out.writeByte(-3);
            out.writeInt(len);
        }
    }

    public static int readArrayLength(DataInput in) throws IOException {
        byte code = in.readByte();
        if (code == -1) {
            return -1;
        }
        int result = InternalDataSerializer.ubyteToInt(code);
        if (result > 252) {
            if (code == -2) {
                result = in.readUnsignedShort();
            } else if (code == -3) {
                result = in.readInt();
            } else {
                throw new IllegalStateException("unexpected array length code=" + code);
            }
        }
        return result;
    }

    public void writeListOfIntegers(List<Integer> list, DataOutput out) throws IOException {
        int size = list == null ? -1 : list.size();
        InternalDataSerializer.writeArrayLength(size, out);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                out.writeInt(list.get(i));
            }
        }
    }

    public static Object readDSFID(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "readDSFID: header={}", (Object)header);
        }
        if (header == DSCODE.DS_FIXED_ID_BYTE.toByte()) {
            return DSFIDFactory.create(in.readByte(), in);
        }
        if (header == DSCODE.DS_FIXED_ID_SHORT.toByte()) {
            return DSFIDFactory.create(in.readShort(), in);
        }
        if (header == DSCODE.DS_NO_FIXED_ID.toByte()) {
            return InternalDataSerializer.readDataSerializableFixedID(in);
        }
        if (header == DSCODE.DS_FIXED_ID_INT.toByte()) {
            return DSFIDFactory.create(in.readInt(), in);
        }
        throw new IllegalStateException("unexpected byte: " + header + " while reading dsfid");
    }

    public static int readDSFIDHeader(DataInput in) throws IOException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        if (header == DSCODE.DS_FIXED_ID_BYTE.toByte()) {
            return in.readByte();
        }
        if (header == DSCODE.DS_FIXED_ID_SHORT.toByte()) {
            return in.readShort();
        }
        if (header == DSCODE.DS_NO_FIXED_ID.toByte()) {
            return Integer.MAX_VALUE;
        }
        if (header == DSCODE.DS_FIXED_ID_INT.toByte()) {
            return in.readInt();
        }
        throw new IllegalStateException("unexpected byte: " + header + " while reading dsfid");
    }

    public static String readString(DataInput in, byte header) throws IOException {
        if (header == DSCODE.STRING_BYTES.toByte()) {
            int len = in.readUnsignedShort();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading STRING_BYTES of len={}", (Object)len);
            }
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new String(buf, 0);
        }
        if (header == DSCODE.STRING.toByte()) {
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading utf STRING");
            }
            return in.readUTF();
        }
        if (header == DSCODE.NULL_STRING.toByte()) {
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading NULL_STRING");
            }
            return null;
        }
        if (header == DSCODE.HUGE_STRING_BYTES.toByte()) {
            int len = in.readInt();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HUGE_STRING_BYTES of len={}", (Object)len);
            }
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            return new String(buf, 0);
        }
        if (header == DSCODE.HUGE_STRING.toByte()) {
            int len = in.readInt();
            if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "Reading HUGE_STRING of len={}", (Object)len);
            }
            char[] buf = new char[len];
            for (int i = 0; i < len; ++i) {
                buf[i] = in.readChar();
            }
            return new String(buf);
        }
        String s = "Unknown String header " + header;
        throw new IOException(s);
    }

    public static void registerDVDDeserializer(DataSerializer dvddeslzr) {
        dvddeserializer = dvddeslzr;
    }

    public static <T> T readNonPdxInstanceObject(DataInput in) throws IOException, ClassNotFoundException {
        boolean wouldReadSerialized = PdxInstanceImpl.getPdxReadSerialized();
        if (!wouldReadSerialized) {
            return DataSerializer.readObject(in);
        }
        PdxInstanceImpl.setPdxReadSerialized(false);
        try {
            Object t = DataSerializer.readObject(in);
            return t;
        }
        finally {
            PdxInstanceImpl.setPdxReadSerialized(true);
        }
    }

    public static Object basicReadObject(final DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn(in);
        byte header = in.readByte();
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "basicReadObject: header={}", (Object)header);
        }
        if (header == DSCODE.DS_FIXED_ID_BYTE.toByte()) {
            return DSFIDFactory.create(in.readByte(), in);
        }
        if (header == DSCODE.DS_FIXED_ID_SHORT.toByte()) {
            return DSFIDFactory.create(in.readShort(), in);
        }
        if (header == DSCODE.DS_FIXED_ID_INT.toByte()) {
            return DSFIDFactory.create(in.readInt(), in);
        }
        if (header == DSCODE.DS_NO_FIXED_ID.toByte()) {
            return InternalDataSerializer.readDataSerializableFixedID(in);
        }
        if (header == DSCODE.NULL.toByte()) {
            return null;
        }
        if (header == DSCODE.NULL_STRING.toByte() || header == DSCODE.STRING.toByte() || header == DSCODE.HUGE_STRING.toByte() || header == DSCODE.STRING_BYTES.toByte() || header == DSCODE.HUGE_STRING_BYTES.toByte()) {
            return InternalDataSerializer.readString(in, header);
        }
        if (header == DSCODE.CLASS.toByte()) {
            return InternalDataSerializer.readClass(in);
        }
        if (header == DSCODE.DATE.toByte()) {
            return InternalDataSerializer.readDate(in);
        }
        if (header == DSCODE.FILE.toByte()) {
            return InternalDataSerializer.readFile(in);
        }
        if (header == DSCODE.INET_ADDRESS.toByte()) {
            return InternalDataSerializer.readInetAddress(in);
        }
        if (header == DSCODE.BOOLEAN.toByte()) {
            return InternalDataSerializer.readBoolean(in);
        }
        if (header == DSCODE.CHARACTER.toByte()) {
            return InternalDataSerializer.readCharacter(in);
        }
        if (header == DSCODE.BYTE.toByte()) {
            return InternalDataSerializer.readByte(in);
        }
        if (header == DSCODE.SHORT.toByte()) {
            return InternalDataSerializer.readShort(in);
        }
        if (header == DSCODE.INTEGER.toByte()) {
            return InternalDataSerializer.readInteger(in);
        }
        if (header == DSCODE.LONG.toByte()) {
            return InternalDataSerializer.readLong(in);
        }
        if (header == DSCODE.FLOAT.toByte()) {
            return InternalDataSerializer.readFloat(in);
        }
        if (header == DSCODE.DOUBLE.toByte()) {
            return InternalDataSerializer.readDouble(in);
        }
        if (header == DSCODE.BYTE_ARRAY.toByte()) {
            return InternalDataSerializer.readByteArray(in);
        }
        if (header == DSCODE.ARRAY_OF_BYTE_ARRAYS.toByte()) {
            return InternalDataSerializer.readArrayOfByteArrays(in);
        }
        if (header == DSCODE.SHORT_ARRAY.toByte()) {
            return InternalDataSerializer.readShortArray(in);
        }
        if (header == DSCODE.STRING_ARRAY.toByte()) {
            return InternalDataSerializer.readStringArray(in);
        }
        if (header == DSCODE.INT_ARRAY.toByte()) {
            return InternalDataSerializer.readIntArray(in);
        }
        if (header == DSCODE.LONG_ARRAY.toByte()) {
            return InternalDataSerializer.readLongArray(in);
        }
        if (header == DSCODE.FLOAT_ARRAY.toByte()) {
            return InternalDataSerializer.readFloatArray(in);
        }
        if (header == DSCODE.DOUBLE_ARRAY.toByte()) {
            return InternalDataSerializer.readDoubleArray(in);
        }
        if (header == DSCODE.BOOLEAN_ARRAY.toByte()) {
            return InternalDataSerializer.readBooleanArray(in);
        }
        if (header == DSCODE.CHAR_ARRAY.toByte()) {
            return InternalDataSerializer.readCharArray(in);
        }
        if (header == DSCODE.OBJECT_ARRAY.toByte()) {
            return InternalDataSerializer.readObjectArray(in);
        }
        if (header == DSCODE.ARRAY_LIST.toByte()) {
            return InternalDataSerializer.readArrayList(in);
        }
        if (header == DSCODE.LINKED_LIST.toByte()) {
            return InternalDataSerializer.readLinkedList(in);
        }
        if (header == DSCODE.HASH_SET.toByte()) {
            return InternalDataSerializer.readHashSet(in);
        }
        if (header == DSCODE.LINKED_HASH_SET.toByte()) {
            return InternalDataSerializer.readLinkedHashSet(in);
        }
        if (header == DSCODE.HASH_MAP.toByte()) {
            return InternalDataSerializer.readHashMap(in);
        }
        if (header == DSCODE.IDENTITY_HASH_MAP.toByte()) {
            return InternalDataSerializer.readIdentityHashMap(in);
        }
        if (header == DSCODE.HASH_TABLE.toByte()) {
            return InternalDataSerializer.readHashtable(in);
        }
        if (header == DSCODE.CONCURRENT_HASH_MAP.toByte()) {
            return InternalDataSerializer.readConcurrentHashMap(in);
        }
        if (header == DSCODE.PROPERTIES.toByte()) {
            return InternalDataSerializer.readProperties(in);
        }
        if (header == DSCODE.TIME_UNIT.toByte()) {
            return InternalDataSerializer.readTimeUnit(in);
        }
        if (header == DSCODE.USER_CLASS.toByte()) {
            return InternalDataSerializer.readUserObject(in, in.readByte());
        }
        if (header == DSCODE.USER_CLASS_2.toByte()) {
            return InternalDataSerializer.readUserObject(in, in.readShort());
        }
        if (header == DSCODE.USER_CLASS_4.toByte()) {
            return InternalDataSerializer.readUserObject(in, in.readInt());
        }
        if (header == DSCODE.VECTOR.toByte()) {
            return InternalDataSerializer.readVector(in);
        }
        if (header == DSCODE.STACK.toByte()) {
            return InternalDataSerializer.readStack(in);
        }
        if (header == DSCODE.TREE_MAP.toByte()) {
            return InternalDataSerializer.readTreeMap(in);
        }
        if (header == DSCODE.TREE_SET.toByte()) {
            return InternalDataSerializer.readTreeSet(in);
        }
        if (header == DSCODE.BOOLEAN_TYPE.toByte()) {
            return Boolean.TYPE;
        }
        if (header == DSCODE.CHARACTER_TYPE.toByte()) {
            return Character.TYPE;
        }
        if (header == DSCODE.BYTE_TYPE.toByte()) {
            return Byte.TYPE;
        }
        if (header == DSCODE.SHORT_TYPE.toByte()) {
            return Short.TYPE;
        }
        if (header == DSCODE.INTEGER_TYPE.toByte()) {
            return Integer.TYPE;
        }
        if (header == DSCODE.LONG_TYPE.toByte()) {
            return Long.TYPE;
        }
        if (header == DSCODE.FLOAT_TYPE.toByte()) {
            return Float.TYPE;
        }
        if (header == DSCODE.DOUBLE_TYPE.toByte()) {
            return Double.TYPE;
        }
        if (header == DSCODE.VOID_TYPE.toByte()) {
            return Void.TYPE;
        }
        if (header == DSCODE.USER_DATA_SERIALIZABLE.toByte()) {
            return InternalDataSerializer.readUserDataSerializable(in, in.readByte());
        }
        if (header == DSCODE.USER_DATA_SERIALIZABLE_2.toByte()) {
            return InternalDataSerializer.readUserDataSerializable(in, in.readShort());
        }
        if (header == DSCODE.USER_DATA_SERIALIZABLE_4.toByte()) {
            return InternalDataSerializer.readUserDataSerializable(in, in.readInt());
        }
        if (header == DSCODE.DATA_SERIALIZABLE.toByte()) {
            return InternalDataSerializer.readDataSerializable(in);
        }
        if (header == DSCODE.SERIALIZABLE.toByte()) {
            Object serializableResult;
            boolean isDebugEnabled_SERIALIZER = logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE);
            if (in instanceof DSObjectInputStream) {
                serializableResult = ((DSObjectInputStream)in).readObject();
            } else {
                Version v;
                InputStream stream = in instanceof InputStream ? (InputStream)((Object)in) : new InputStream(){

                    @Override
                    public int read() throws IOException {
                        try {
                            return in.readUnsignedByte();
                        }
                        catch (EOFException ignored) {
                            return -1;
                        }
                    }
                };
                ObjectInput ois = new DSObjectInputStream(stream);
                serializationFilter.setFilterOn((ObjectInputStream)ois);
                if (stream instanceof VersionedDataStream && (v = ((VersionedDataStream)((Object)stream)).getVersion()) != null && v != Version.CURRENT) {
                    ois = new VersionedObjectInput(ois, v);
                }
                serializableResult = ois.readObject();
                if (isDebugEnabled_SERIALIZER) {
                    logger.trace(LogMarker.SERIALIZER_VERBOSE, "Read Serializable object: {}", serializableResult);
                }
            }
            if (isDebugEnabled_SERIALIZER) {
                logger.trace(LogMarker.SERIALIZER_VERBOSE, "deserialized instanceof {}", serializableResult.getClass());
            }
            return serializableResult;
        }
        if (header == DSCODE.PDX.toByte()) {
            return InternalDataSerializer.readPdxSerializable(in);
        }
        if (header == DSCODE.PDX_ENUM.toByte()) {
            return InternalDataSerializer.readPdxEnum(in);
        }
        if (header == DSCODE.GEMFIRE_ENUM.toByte()) {
            return InternalDataSerializer.readGemFireEnum(in);
        }
        if (header == DSCODE.PDX_INLINE_ENUM.toByte()) {
            return InternalDataSerializer.readPdxInlineEnum(in);
        }
        if (header == DSCODE.BIG_INTEGER.toByte()) {
            return InternalDataSerializer.readBigInteger(in);
        }
        if (header == DSCODE.BIG_DECIMAL.toByte()) {
            return InternalDataSerializer.readBigDecimal(in);
        }
        if (header == DSCODE.UUID.toByte()) {
            return InternalDataSerializer.readUUID(in);
        }
        if (header == DSCODE.TIMESTAMP.toByte()) {
            return InternalDataSerializer.readTimestamp(in);
        }
        String s = "Unknown header byte: " + header;
        throw new IOException(s);
    }

    private static Object readUserDataSerializable(DataInput in, int classId) throws IOException {
        Instantiator instantiator = InternalInstantiator.getInstantiator(classId);
        if (instantiator == null) {
            logger.error(LogMarker.SERIALIZER_MARKER, (Message)LocalizedMessage.create(LocalizedStrings.DataSerializer_NO_INSTANTIATOR_HAS_BEEN_REGISTERED_FOR_CLASS_WITH_ID_0, classId));
            throw new IOException(LocalizedStrings.DataSerializer_NO_INSTANTIATOR_HAS_BEEN_REGISTERED_FOR_CLASS_WITH_ID_0.toLocalizedString(classId));
        }
        try {
            DataSerializable ds;
            if (instantiator instanceof CanonicalInstantiator) {
                CanonicalInstantiator ci = (CanonicalInstantiator)instantiator;
                ds = ci.newInstance(in);
            } else {
                ds = instantiator.newInstance();
            }
            ds.fromData(in);
            return ds;
        }
        catch (Exception ex) {
            throw new SerializationException(LocalizedStrings.DataSerializer_COULD_NOT_DESERIALIZE_AN_INSTANCE_OF_0.toLocalizedString(instantiator.getInstantiatedClass().getName()), ex);
        }
    }

    public static boolean isPdxSerializationInProgress() {
        Boolean v = pdxSerializationInProgress.get();
        return v != null && v != false;
    }

    public static void setPdxSerializationInProgress(boolean v) {
        if (v) {
            pdxSerializationInProgress.set(true);
        } else {
            pdxSerializationInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writePdx(DataOutput out, InternalCache internalCache, Object pdx, PdxSerializer pdxSerializer) throws IOException {
        PdxWriterImpl writer;
        block20: {
            TypeRegistry tr = null;
            if (internalCache != null) {
                tr = internalCache.getPdxRegistry();
            }
            PdxOutputStream os = out instanceof HeapDataOutputStream ? new PdxOutputStream((HeapDataOutputStream)out) : new PdxOutputStream();
            writer = new PdxWriterImpl(tr, pdx, os);
            try {
                boolean alreadyInProgress;
                if (pdxSerializer != null) {
                    if (InternalDataSerializer.isGemfireObject(pdx)) {
                        return false;
                    }
                    if (InternalDataSerializer.is662SerializationEnabled()) {
                        alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                        if (!alreadyInProgress) {
                            InternalDataSerializer.setPdxSerializationInProgress(true);
                            try {
                                if (!pdxSerializer.toData(pdx, writer)) {
                                    boolean bl = false;
                                    return bl;
                                }
                                break block20;
                            }
                            finally {
                                InternalDataSerializer.setPdxSerializationInProgress(false);
                            }
                        }
                        if (!pdxSerializer.toData(pdx, writer)) {
                            return false;
                        }
                        break block20;
                    }
                    if (!pdxSerializer.toData(pdx, writer)) {
                        return false;
                    }
                    break block20;
                }
                if (InternalDataSerializer.is662SerializationEnabled()) {
                    alreadyInProgress = InternalDataSerializer.isPdxSerializationInProgress();
                    if (!alreadyInProgress) {
                        InternalDataSerializer.setPdxSerializationInProgress(true);
                        try {
                            ((PdxSerializable)pdx).toData(writer);
                            break block20;
                        }
                        finally {
                            InternalDataSerializer.setPdxSerializationInProgress(false);
                        }
                    }
                    ((PdxSerializable)pdx).toData(writer);
                    break block20;
                }
                ((PdxSerializable)pdx).toData(writer);
            }
            catch (CancelException | GemFireRethrowable | ToDataException | NonPortableClassException ex) {
                throw ex;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (pdxSerializer == null) throw new ToDataException("toData failed on PdxSerializable " + pdx.getClass(), t);
                throw new ToDataException("PdxSerializer failed when calling toData on " + pdx.getClass(), t);
            }
        }
        int bytesWritten = writer.completeByteStreamGeneration();
        InternalDataSerializer.getDMStats(internalCache).incPdxSerialization(bytesWritten);
        if (out instanceof HeapDataOutputStream) return true;
        writer.sendTo(out);
        return true;
    }

    public static DMStats getDMStats(InternalCache internalCache) {
        if (internalCache != null) {
            return internalCache.getDistributionManager().getStats();
        }
        DMStats result = InternalDistributedSystem.getDMStats();
        if (result == null) {
            result = new LonerDistributionManager.DummyDMStats();
        }
        return result;
    }

    private static Object readPdxSerializable(DataInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        int typeId = in.readInt();
        GemFireCacheImpl internalCache = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
        PdxType pdxType = internalCache.getPdxRegistry().getType(typeId);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "readPdxSerializable pdxType={}", (Object)pdxType);
        }
        if (pdxType == null) {
            throw new IllegalStateException("Unknown pdx type=" + typeId);
        }
        DMStats dmStats = InternalDataSerializer.getDMStats(internalCache);
        dmStats.incPdxDeserialization(len + 9);
        if (pdxType.getNoDomainClass() || internalCache.getPdxReadSerializedByAnyGemFireServices()) {
            dmStats.incPdxInstanceCreations();
            return new PdxInstanceImpl(pdxType, in, len);
        }
        PdxReaderImpl pdxReader = new PdxReaderImpl(pdxType, in, len);
        return pdxReader.getObject();
    }

    public static PdxInstance readPdxInstance(byte[] dataBytes, InternalCache internalCache) {
        try {
            byte type = dataBytes[0];
            if (type == DSCODE.PDX.toByte()) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                int len = in.readInt();
                int typeId = in.readInt();
                PdxType pdxType = internalCache.getPdxRegistry().getType(typeId);
                if (pdxType == null) {
                    throw new IllegalStateException("Unknown pdx type=" + typeId);
                }
                return new PdxInstanceImpl(pdxType, in, len);
            }
            if (type == DSCODE.PDX_ENUM.toByte()) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                byte dsId = in.readByte();
                int tmp = InternalDataSerializer.readArrayLength(in);
                int enumId = dsId << 24 | tmp & 0xFFFFFF;
                TypeRegistry tr = internalCache.getPdxRegistry();
                EnumInfo ei = tr.getEnumInfoById(enumId);
                if (ei == null) {
                    throw new IllegalStateException("Unknown pdx enum id=" + enumId);
                }
                return ei.getPdxInstance(enumId);
            }
            if (type == DSCODE.PDX_INLINE_ENUM.toByte()) {
                PdxInputStream in = new PdxInputStream(dataBytes);
                in.readByte();
                String className = DataSerializer.readString(in);
                String enumName = DataSerializer.readString(in);
                int enumOrdinal = InternalDataSerializer.readArrayLength(in);
                return new PdxInstanceEnum(className, enumName, enumOrdinal);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static int getLoadedDataSerializers() {
        return idsToSerializers.size();
    }

    public static Map getDsClassesToHoldersMap() {
        return dsClassesToHolders;
    }

    public static Map getIdsToHoldersMap() {
        return idsToHolders;
    }

    public static Map getSupportedClassesToHoldersMap() {
        return supportedClassesToHolders;
    }

    public static void writeObjectArray(Object[] array, DataOutput out, boolean ensureCompatibility) throws IOException {
        InternalDataSerializer.checkOut(out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength(length, out);
        if (logger.isTraceEnabled(LogMarker.SERIALIZER_VERBOSE)) {
            logger.trace(LogMarker.SERIALIZER_VERBOSE, "Writing Object array of length {}", (Object)length);
        }
        if (length >= 0) {
            InternalDataSerializer.writeClass(array.getClass().getComponentType(), out);
            for (int i = 0; i < length; ++i) {
                InternalDataSerializer.basicWriteObject(array[i], out, ensureCompatibility);
            }
        }
    }

    public static void writeVLOld(long data, DataOutput out) throws IOException {
        if (data < 0L) {
            Assert.fail("Data expected to be >=0 is " + data);
        }
        if (data <= 125L) {
            out.writeByte((byte)data);
        } else if (data <= 32767L) {
            out.write(((int)data >>> 8 | 0x80) & 0xFF);
            out.write((int)data >>> 0 & 0xFF);
        } else if (data <= Integer.MAX_VALUE) {
            out.writeByte(126);
            out.writeInt((int)data);
        } else {
            out.writeByte(127);
            out.writeLong(data);
        }
    }

    public static long readVLOld(DataInput in) throws IOException {
        long result;
        byte code = in.readByte();
        if (code < 0) {
            result = code & 0x7F;
            result <<= 8;
            result |= (long)(in.readByte() & 0xFF);
        } else if (code <= 125) {
            result = code;
        } else if (code == 126) {
            result = in.readInt();
        } else if (code == 127) {
            result = in.readLong();
        } else {
            throw new IllegalStateException("unexpected variable length code=" + code);
        }
        return result;
    }

    public static void writeUnsignedVL(long data, DataOutput out) throws IOException {
        while (true) {
            if ((data & 0xFFFFFFFFFFFFFF80L) == 0L) {
                out.writeByte((int)data);
                return;
            }
            out.writeByte((int)data & 0x7F | 0x80);
            data >>>= 7;
        }
    }

    public static long readUnsignedVL(DataInput in) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new GemFireIOException("Malformed variable length integer");
    }

    public static void writeSignedVL(long data, DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(data), out);
    }

    public static long readSignedVL(DataInput in) throws IOException {
        return InternalDataSerializer.decodeZigZag64(InternalDataSerializer.readUnsignedVL(in));
    }

    private static long decodeZigZag64(long n) {
        return n >>> 1 ^ -(n & 1L);
    }

    private static long encodeZigZag64(long n) {
        return n << 1 ^ n >> 63;
    }

    public static int calculateBytesForTSandDSID(int dsid) {
        HeapDataOutputStream out = new HeapDataOutputStream(12, Version.CURRENT);
        long now = System.currentTimeMillis();
        try {
            InternalDataSerializer.writeUnsignedVL(now, out);
            InternalDataSerializer.writeUnsignedVL(InternalDataSerializer.encodeZigZag64(dsid), out);
        }
        catch (IOException ignored) {
            return 0;
        }
        return out.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getCachedClass(String p_className) throws ClassNotFoundException {
        String className = InternalDataSerializer.processIncomingClassName(p_className);
        if (LOAD_CLASS_EACH_TIME) {
            return ClassPathLoader.getLatest().forName(className);
        }
        Class<?> result = InternalDataSerializer.getExistingCachedClass(className);
        if (result == null) {
            result = ClassPathLoader.getLatest().forName(className);
            Object object = cacheAccessLock;
            synchronized (object) {
                Class<?> cachedClass = InternalDataSerializer.getExistingCachedClass(className);
                if (cachedClass == null) {
                    classCache.put(className, new WeakReference(result));
                } else {
                    result = cachedClass;
                }
            }
        }
        return result;
    }

    private static Class<?> getExistingCachedClass(String className) {
        WeakReference<Class<?>> wr = classCache.get(className);
        Class result = null;
        if (wr != null) {
            result = (Class)wr.get();
        }
        return result;
    }

    public static void flushClassCache() {
        if (classCache != null) {
            classCache.clear();
        }
    }

    static {
        serializationFilter = defaultSerializationFilter = new EmptyInputStreamFilter();
        serializationVersionTxt = System.getProperty("gemfire.serializationVersion");
        latestVersion = SERIALIZATION_VERSION.v662;
        serializationVersion = InternalDataSerializer.calculateSerializationVersion();
        InternalDataSerializer.initializeWellKnownSerializers();
        idsToSerializers = new ConcurrentHashMap();
        dsClassesToHolders = new ConcurrentHashMap();
        idsToHolders = new ConcurrentHashMap();
        supportedClassesToHolders = new ConcurrentHashMap();
        listeners = new HashSet();
        listenersSync = new Object();
        dsfidToClassMap = logger.isTraceEnabled(LogMarker.SERIALIZER_WRITE_DSFID_VERBOSE) ? new ConcurrentHashMap() : null;
        pdxSerializationInProgress = new ThreadLocal();
        LOAD_CLASS_EACH_TIME = Boolean.getBoolean("gemfire.loadClassOnEveryDeserialization");
        classCache = LOAD_CLASS_EACH_TIME ? null : new CopyOnWriteHashMap();
        cacheAccessLock = new Object();
    }

    protected static abstract class WellKnownPdxDS
    extends WellKnownDS {
        protected WellKnownPdxDS() {
        }
    }

    protected static abstract class WellKnownDS
    extends DataSerializer {
        protected WellKnownDS() {
        }

        @Override
        public int getId() {
            return 0;
        }

        public Class[] getSupportedClasses() {
            return null;
        }

        @Override
        public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            throw new IllegalStateException(LocalizedStrings.SHOULDNT_INVOKE.toLocalizedString());
        }
    }

    private static class DSObjectInputStream
    extends ObjectInputStream {
        DSObjectInputStream(InputStream stream) throws IOException {
            super(stream);
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String className = desc.getName();
            OldClientSupportService svc = InternalDataSerializer.getOldClientSupportService();
            if (svc != null) {
                className = svc.processIncomingClassName(className);
            }
            try {
                return InternalDataSerializer.getCachedClass(className);
            }
            catch (ClassNotFoundException ignored) {
                return super.resolveClass(desc);
            }
        }

        protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = InternalDataSerializer.getCachedClass(interfaces[i]);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            String s = "conflicting non-public interface class loaders";
                            throw new IllegalAccessError(s);
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                if (hasNonPublicInterface) {
                    return Proxy.getProxyClass(nonPublicLoader, classObjs);
                }
                return ClassPathLoader.getLatest().getProxyClass(classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }

    public static interface RegistrationListener {
        public void newInstantiator(Instantiator var1);

        public void newDataSerializer(DataSerializer var1);
    }

    public static class RegistrationMessage
    extends SerialDistributionMessage {
        private int id;
        protected EventID eventId;
        private String className;
        private static final Version[] dsfidVersions = new Version[0];

        public RegistrationMessage() {
        }

        public RegistrationMessage(DataSerializer s) {
            this.className = s.getClass().getName();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
        }

        static String getFullMessage(Throwable t) {
            StringBuffer sb = new StringBuffer();
            RegistrationMessage.getFullMessage(sb, t);
            return sb.toString();
        }

        private static void getFullMessage(StringBuffer sb, Throwable t) {
            if (t.getMessage() != null) {
                sb.append(t.getMessage());
            } else {
                sb.append(t.getClass());
            }
            if (t.getCause() != null) {
                sb.append(" caused by: ");
                RegistrationMessage.getFullMessage(sb, t.getCause());
            }
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            if (CacheClientNotifier.getInstance() != null) {
                DataSerializer s;
                Class<?> c;
                try {
                    c = InternalDataSerializer.getCachedClass(this.className);
                }
                catch (ClassNotFoundException ex) {
                    logger.warn("Could not load data serializer class {} so both clients of this server and this server will not have this data serializer. Load failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                    return;
                }
                try {
                    s = InternalDataSerializer.newInstance(c);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not create an instance of data serializer for class {} so both clients of this server and this server will not have this data serializer. Create failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                    return;
                }
                s.setEventId(this.eventId);
                try {
                    InternalDataSerializer._register(s, false);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not register data serializer for class {} so both clients of this server and this server will not have this data serializer. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
                catch (IllegalStateException ex) {
                    logger.warn("Could not register data serializer for class {} so both clients of this server and this server will not have this data serializer. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
            } else {
                try {
                    InternalDataSerializer.register(this.className, false, this.eventId, null, this.id);
                }
                catch (IllegalArgumentException ex) {
                    logger.warn("Could not register data serializer for class {} so it will not be available in this JVM. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
                catch (IllegalStateException ex) {
                    logger.warn("Could not register data serializer for class {} so it will not be available in this JVM. Registration failed because: {}", (Object)this.className, (Object)RegistrationMessage.getFullMessage(ex));
                }
            }
        }

        @Override
        public int getDSFID() {
            return -68;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeNonPrimitiveClassName(this.className, out);
            out.writeInt(this.id);
            DataSerializer.writeObject(this.eventId, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            InternalDataSerializer.checkIn(in);
            this.className = DataSerializer.readNonPrimitiveClassName(in);
            this.id = in.readInt();
            this.eventId = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            return LocalizedStrings.InternalDataSerializer_REGISTER_DATASERIALIZER_0_OF_CLASS_1.toLocalizedString(this.id, this.className);
        }

        @Override
        public Version[] getSerializationVersions() {
            return dsfidVersions;
        }
    }

    static class InitMarker
    extends Marker {
        InitMarker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            InitMarker initMarker = this;
            synchronized (initMarker) {
                while (!this.hasBeenSet) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    public static class GetMarker
    extends Marker {
        public static int WAIT_MS = Integer.getInteger("gemfire.InternalDataSerializer.WAIT_MS", 60000);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        DataSerializer getSerializer() {
            GetMarker getMarker = this;
            synchronized (getMarker) {
                boolean firstTime = true;
                long endTime = 0L;
                while (!this.hasBeenSet) {
                    if (firstTime) {
                        firstTime = false;
                        endTime = System.currentTimeMillis() + (long)WAIT_MS;
                    }
                    try {
                        long remainingMs = endTime - System.currentTimeMillis();
                        if (remainingMs > 0L) {
                            this.wait(remainingMs);
                            continue;
                        }
                        this.setSerializer(null);
                        break;
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.serializer;
            }
        }
    }

    static abstract class Marker {
        protected DataSerializer serializer = null;
        boolean hasBeenSet = false;

        Marker() {
        }

        abstract DataSerializer getSerializer();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSerializer(DataSerializer serializer) {
            Marker marker = this;
            synchronized (marker) {
                this.hasBeenSet = true;
                this.serializer = serializer;
                this.notifyAll();
            }
        }
    }

    public static class SerializerAttributesHolder {
        private String className = "";
        private EventID eventId = null;
        private ClientProxyMembershipID proxyId = null;
        private int id = 0;

        SerializerAttributesHolder() {
        }

        SerializerAttributesHolder(String name, EventID event, ClientProxyMembershipID proxy, int id) {
            this.className = name;
            this.eventId = event;
            this.proxyId = proxy;
            this.id = id;
        }

        public String getClassName() {
            return this.className;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "SerializerAttributesHolder[name=" + this.className + ",id=" + this.id + ",eventId=" + this.eventId + ']';
        }
    }

    private static enum SERIALIZATION_VERSION {
        vINVALID,
        v660,
        v662;

    }
}

