/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.membership.gms.messenger;

import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.distributed.internal.membership.gms.Services;
import org.apache.logging.log4j.Logger;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.FRAG2;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.protocols.pbcast.NAKACK2;
import org.jgroups.protocols.pbcast.NakAckHeader2;
import org.jgroups.stack.Protocol;

public class StatRecorder
extends Protocol {
    private static final Logger logger = Services.getLogger();
    private static final int OUTGOING = 0;
    private static final int INCOMING = 1;
    DMStats stats;
    Services services;
    private final short nakackHeaderId = ClassConfigurator.getProtocolId(NAKACK2.class);
    private final short unicastHeaderId = ClassConfigurator.getProtocolId(UNICAST3.class);
    private final short frag2HeaderId = ClassConfigurator.getProtocolId(FRAG2.class);

    public void setServices(Services services) {
        this.services = services;
        this.stats = services.getStatistics();
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.processForMulticast(msg, 1);
                this.processForUnicast(msg, 1);
                this.filter(msg, 1);
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.processForMulticast(msg, 0);
                this.processForUnicast(msg, 0);
                this.filter(msg, 0);
            }
        }
        while (true) {
            try {
                return this.down_prot.down(evt);
            }
            catch (RejectedExecutionException e) {
                logger.debug("retrying JGroups message transmission due to rejected execution (GEODE-1178)");
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                if (this.services != null && !this.services.getManager().shutdownInProgress() && !this.services.getCancelCriterion().isCancelInProgress()) continue;
                return null;
            }
            break;
        }
    }

    private void processForMulticast(Message msg, int direction) {
        Header o = msg.getHeader(this.nakackHeaderId);
        if (o instanceof NakAckHeader2 && this.stats != null) {
            NakAckHeader2 hdr = (NakAckHeader2)o;
            block0 : switch (direction) {
                case 1: {
                    this.stats.incMcastReadBytes((int)msg.size());
                    break;
                }
                case 0: {
                    this.stats.incMcastWriteBytes((int)msg.size());
                    switch (hdr.getType()) {
                        case 3: {
                            this.stats.incMcastRetransmits();
                            break block0;
                        }
                        case 2: {
                            this.stats.incMcastRetransmitRequests();
                        }
                    }
                }
            }
        }
    }

    private void processForUnicast(Message msg, int direction) {
        Header o = msg.getHeader(this.unicastHeaderId);
        if (o instanceof UNICAST3.Header && this.stats != null) {
            UNICAST3.Header hdr = (UNICAST3.Header)o;
            switch (direction) {
                case 1: {
                    this.stats.incUcastReadBytes((int)msg.size());
                    break;
                }
                case 0: {
                    this.stats.incUcastWriteBytes((int)msg.size());
                    switch (hdr.type()) {
                        case 3: {
                            this.stats.incUcastRetransmits();
                        }
                    }
                }
            }
        }
    }

    private void filter(Message msg, int direction) {
        if (direction == 1) {
            Header h = msg.getHeader(this.frag2HeaderId);
            boolean copyBuffer = false;
            if (h != null && h instanceof FragHeader) {
                copyBuffer = true;
            } else {
                h = msg.getHeader(this.unicastHeaderId);
                if (h instanceof UNICAST3.Header) {
                    copyBuffer = true;
                } else {
                    h = msg.getHeader(this.nakackHeaderId);
                    if (h instanceof NakAckHeader2) {
                        copyBuffer = true;
                    }
                }
            }
            if (copyBuffer) {
                msg.setBuffer(msg.getBuffer(), 0, msg.getLength());
            }
        }
    }
}

