/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.NameNotFoundException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.QueryInvalidException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.RegionNotFoundException;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.Bag;
import org.apache.geode.cache.query.internal.CompiledBindArgument;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledIn;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.CqEntry;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.OrderByComparator;
import org.apache.geode.cache.query.internal.OrderByComparatorMapped;
import org.apache.geode.cache.query.internal.Ordered;
import org.apache.geode.cache.query.internal.PathUtils;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.cache.query.internal.ResultsCollectionWrapper;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultSet;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.SortedStructBag;
import org.apache.geode.cache.query.internal.SortedStructSet;
import org.apache.geode.cache.query.internal.StructBag;
import org.apache.geode.cache.query.internal.StructFields;
import org.apache.geode.cache.query.internal.StructImpl;
import org.apache.geode.cache.query.internal.StructSet;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.PartitionedIndex;
import org.apache.geode.cache.query.internal.types.ObjectTypeImpl;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.CollectionType;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxString;

public class CompiledSelect
extends AbstractCompiledValue {
    protected List<CompiledSortCriterion> orderByAttrs;
    private CompiledValue whereClause;
    private List iterators;
    protected List projAttrs;
    private boolean distinct;
    private boolean count;
    private CompiledValue limit;
    private int countStartQueryResult = 0;
    protected List<CompiledValue> groupBy = null;
    private List<String> hints;
    protected boolean transformationDone = false;
    protected ObjectType cachedElementTypeForOrderBy = null;
    private boolean hasUnmappedOrderByCols = false;
    private Object scopeID = new Object();
    private static final String CLAUSE_EVALUATED = "Evaluated";

    public CompiledSelect(boolean distinct, boolean count, CompiledValue whereClause, List iterators, List projAttrs, List<CompiledSortCriterion> orderByAttrs, CompiledValue limit, List<String> hints, List<CompiledValue> groupByClause) {
        this.orderByAttrs = orderByAttrs;
        this.whereClause = whereClause;
        this.iterators = iterators;
        this.projAttrs = projAttrs;
        this.distinct = distinct;
        this.count = count;
        this.limit = limit;
        this.hints = hints;
        this.groupBy = groupByClause;
    }

    @Override
    public List getChildren() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.whereClause != null) {
            list.add(this.whereClause);
        }
        list.addAll(this.iterators);
        if (this.projAttrs != null) {
            Iterator itr = this.projAttrs.iterator();
            while (itr.hasNext()) {
                list.add(((Object[])itr.next())[1]);
            }
        }
        if (this.orderByAttrs != null) {
            list.addAll(this.orderByAttrs);
        }
        return list;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isGroupBy() {
        return this.groupBy != null;
    }

    public boolean isOrderBy() {
        return this.orderByAttrs != null;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    @Override
    public int getType() {
        return 74;
    }

    public CompiledValue getWhereClause() {
        return this.whereClause;
    }

    public List getIterators() {
        return this.iterators;
    }

    public List getProjectionAttributes() {
        return this.projAttrs;
    }

    public List<CompiledSortCriterion> getOrderByAttrs() {
        return this.orderByAttrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        context.cachePut(this.scopeID, context.associateScopeID());
        context.newScope((Integer)context.cacheGet(this.scopeID));
        context.pushExecCache((Integer)context.cacheGet(this.scopeID));
        try {
            for (CompiledIteratorDef iterDef : this.iterators) {
                context.addDependencies(this, iterDef.computeDependencies(context));
                RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                context.addToIndependentRuntimeItrMap(iterDef);
                context.bindIterator(rIter);
            }
            if (this.whereClause != null) {
                context.addDependencies(this, this.whereClause.computeDependencies(context));
            }
            if (this.projAttrs != null) {
                Set totalDependencySet = null;
                Iterator iter = this.projAttrs.iterator();
                while (iter.hasNext()) {
                    Object[] prj = (Object[])TypeUtils.checkCast(iter.next(), Object[].class);
                    CompiledValue prjExpr = (CompiledValue)TypeUtils.checkCast(prj[1], CompiledValue.class);
                    totalDependencySet = context.addDependencies(this, prjExpr.computeDependencies(context));
                }
                this.doTreeTransformation(context);
                Set set = totalDependencySet;
                return set;
            }
            this.doTreeTransformation(context);
            Set set = context.getDependencySet(this, true);
            return set;
        }
        finally {
            context.popExecCache();
            context.popScope();
        }
    }

    protected void doTreeTransformation(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        if (!this.transformationDone) {
            this.cachedElementTypeForOrderBy = this.prepareResultType(context);
            this.mapOrderByColumns(context);
            this.transformGroupByIfPossible(context);
        }
        this.transformationDone = true;
    }

    private void transformGroupByIfPossible(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        if (this.groupBy != null) {
            ArrayList<Object[]> projAttribs = this.projAttrs;
            if (projAttribs == null) {
                projAttribs = new ArrayList<Object[]>();
                List currentIters = context.getCurrentIterators();
                for (Object o : currentIters) {
                    RuntimeIterator rIter = (RuntimeIterator)o;
                    String name = rIter.getName();
                    projAttribs.add(new Object[]{name, rIter});
                }
            }
            if (projAttribs != null && projAttribs.size() != this.groupBy.size()) {
                throw new QueryInvalidException(LocalizedStrings.DefaultQuery_PROJ_COL_ABSENT_IN_GROUP_BY.toLocalizedString() + " or " + LocalizedStrings.DefaultQuery_GROUP_BY_COL_ABSENT_IN_PROJ.toLocalizedString());
            }
            boolean shouldTransform = true;
            StringBuilder lhsBuffer = new StringBuilder();
            StringBuilder rhsBuffer = new StringBuilder();
            block1: for (int i = 0; i < projAttribs.size(); ++i) {
                Object[] prj = (Object[])TypeUtils.checkCast(projAttribs.get(i), Object[].class);
                CompiledValue groupByAttr = this.groupBy.get(i);
                if (prj[0] != null && groupByAttr instanceof CompiledID && prj[0].equals(((CompiledID)groupByAttr).getId())) {
                    lhsBuffer.delete(0, lhsBuffer.length());
                    rhsBuffer.delete(0, rhsBuffer.length());
                    continue;
                }
                CompiledValue cvProj = (CompiledValue)TypeUtils.checkCast(prj[1], CompiledValue.class);
                cvProj.generateCanonicalizedExpression(lhsBuffer, context);
                groupByAttr.generateCanonicalizedExpression(rhsBuffer, context);
                if (lhsBuffer.length() == rhsBuffer.length()) {
                    for (int indx = 0; indx < lhsBuffer.length(); ++indx) {
                        if (lhsBuffer.charAt(indx) == rhsBuffer.charAt(indx)) continue;
                        shouldTransform = false;
                        break block1;
                    }
                } else {
                    shouldTransform = false;
                    break;
                }
                lhsBuffer.delete(0, lhsBuffer.length());
                rhsBuffer.delete(0, rhsBuffer.length());
            }
            if (shouldTransform && this.orderByAttrs == null) {
                this.modifyGroupByToOrderBy(true, context);
            } else {
                throw new QueryInvalidException(LocalizedStrings.DefaultQuery_PROJ_COL_ABSENT_IN_GROUP_BY.toLocalizedString() + " or " + LocalizedStrings.DefaultQuery_GROUP_BY_COL_ABSENT_IN_PROJ.toLocalizedString());
            }
        }
    }

    protected void modifyGroupByToOrderBy(boolean setDistinct, ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        if (setDistinct) {
            this.distinct = setDistinct;
        }
        this.orderByAttrs = new ArrayList<CompiledSortCriterion>(this.groupBy.size());
        boolean colIndex = false;
        for (CompiledValue cv : this.groupBy) {
            CompiledSortCriterion csc = new CompiledSortCriterion(false, cv);
            csc.mapExpressionToProjectionField(this.projAttrs, context);
            this.orderByAttrs.add(csc);
        }
        this.groupBy = null;
    }

    private void mapOrderByColumns(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        if (this.orderByAttrs != null) {
            for (CompiledSortCriterion csc : this.orderByAttrs) {
                if (csc.mapExpressionToProjectionField(this.projAttrs, context)) continue;
                this.hasUnmappedOrderByCols = true;
            }
        }
    }

    private void evalCanonicalizedExpressionForCSC(CompiledSortCriterion csc, ExecutionContext context, StringBuilder buffer) throws TypeMismatchException, NameResolutionException {
        csc.getExpr().generateCanonicalizedExpression(buffer, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectResults getEmptyResultSet(Object[] parameters, InternalCache cache, Query query) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryExecutionContext context = new QueryExecutionContext(parameters, cache, query);
        this.computeDependencies(context);
        context.newScope((Integer)((ExecutionContext)context).cacheGet(this.scopeID));
        ((ExecutionContext)context).pushExecCache((Integer)((ExecutionContext)context).cacheGet(this.scopeID));
        SelectResults results = null;
        try {
            for (CompiledIteratorDef iterDef : this.iterators) {
                RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                context.bindIterator(rIter);
            }
            results = this.prepareEmptyResultSet(context, false);
        }
        finally {
            context.popScope();
            ((ExecutionContext)context).popExecCache();
        }
        return results;
    }

    public ObjectType getElementTypeForOrderByQueries() {
        return this.cachedElementTypeForOrderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectResults evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        context.newScope((Integer)context.cacheGet(this.scopeID));
        context.pushExecCache((Integer)context.cacheGet(this.scopeID));
        context.setDistinct(this.distinct);
        if (this.hasUnmappedOrderByCols && context.getBucketList() != null) {
            throw new QueryInvalidException(LocalizedStrings.DefaultQuery_ORDER_BY_ATTRIBS_NOT_PRESENT_IN_PROJ.toLocalizedString());
        }
        if (this.hints != null) {
            context.cachePut("query_index_hints", this.hints);
        }
        try {
            Object planInfo;
            if (context.getQuery() != null) {
                ((DefaultQuery)context.getQuery()).keepResultsSerialized(this, context);
            }
            for (CompiledIteratorDef iterDef : this.iterators) {
                RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                context.bindIterator(rIter);
            }
            Integer limitValue = CompiledSelect.evaluateLimitValue(context, this.limit);
            SelectResults result = null;
            boolean evalAsFilters = false;
            if (this.whereClause == null) {
                result = this.doIterationEvaluate(context, false);
            } else if (!this.whereClause.isDependentOnCurrentScope(context)) {
                Object b = this.whereClause.evaluate(context);
                if (b == null || b == QueryService.UNDEFINED) {
                    result = this.prepareEmptyResultSet(context, false);
                } else {
                    if (!(b instanceof Boolean)) {
                        throw new TypeMismatchException(LocalizedStrings.CompiledSelect_THE_WHERE_CLAUSE_WAS_TYPE_0_INSTEAD_OF_BOOLEAN.toLocalizedString(b.getClass().getName()));
                    }
                    result = ((Boolean)b).booleanValue() ? this.doIterationEvaluate(context, false) : this.prepareEmptyResultSet(context, false);
                }
            } else {
                int numInd = context.getAllIndependentIteratorsOfCurrentScope().size();
                if (this.orderByAttrs != null && numInd == 1) {
                    CompiledSortCriterion csc = this.orderByAttrs.get(0);
                    StringBuilder preferredIndexCondn = new StringBuilder();
                    this.evalCanonicalizedExpressionForCSC(csc, context, preferredIndexCondn);
                    context.cachePut("preferred_index_condition", preferredIndexCondn.toString());
                }
                boolean unlock = true;
                Object obj = context.cacheGet(this.whereClause);
                if (obj != null && (obj instanceof IndexInfo[] || obj.equals(CLAUSE_EVALUATED))) {
                    unlock = false;
                }
                planInfo = this.whereClause.getPlanInfo(context);
                if (context.cacheGet(this.whereClause) == null) {
                    context.cachePut(this.whereClause, CLAUSE_EVALUATED);
                }
                try {
                    evalAsFilters = ((PlanInfo)planInfo).evalAsFilter;
                    context.setOneIndexLookup(((PlanInfo)planInfo).indexes.size() == 1);
                    if (evalAsFilters) {
                        ((QueryExecutionContext)context).setIndexUsed(true);
                        boolean canApplyOrderByAtIndex = false;
                        if (limitValue >= 0 && numInd == 1 && ((Filter)((Object)this.whereClause)).isLimitApplicableAtIndexLevel(context)) {
                            context.cachePut("can_apply_limit_at_index", Boolean.TRUE);
                        }
                        StringBuilder temp = null;
                        if (this.orderByAttrs != null) {
                            temp = new StringBuilder();
                            CompiledSortCriterion csc = this.orderByAttrs.get(0);
                            this.evalCanonicalizedExpressionForCSC(csc, context, temp);
                        }
                        boolean needsTopLevelOrdering = true;
                        if (temp != null && numInd == 1 && ((Filter)((Object)this.whereClause)).isOrderByApplicableAtIndexLevel(context, temp.toString())) {
                            context.cachePut("can_apply_orderby_at_index", Boolean.TRUE);
                            context.cachePut("orderby", this.orderByAttrs);
                            canApplyOrderByAtIndex = true;
                            if (this.orderByAttrs.size() == 1) {
                                needsTopLevelOrdering = false;
                                if (this.limit != null && context.getBucketList() != null && context.getBucketList().size() > 0) {
                                    needsTopLevelOrdering = true;
                                }
                            }
                        } else if (temp != null) {
                            context.cachePut("can_apply_limit_at_index", Boolean.FALSE);
                        }
                        context.cachePut("limit", limitValue);
                        if (numInd == 1 && ((Filter)((Object)this.whereClause)).isProjectionEvaluationAPossibility(context) && (this.orderByAttrs == null || canApplyOrderByAtIndex && !needsTopLevelOrdering) && this.projAttrs != null) {
                            ObjectType resultType = this.cachedElementTypeForOrderBy != null ? this.cachedElementTypeForOrderBy : this.prepareResultType(context);
                            context.cachePut("result_type", resultType);
                            context.cachePut("projection", this.projAttrs);
                        }
                        result = ((Filter)((Object)this.whereClause)).filterEvaluate(context, null);
                        if (!(context.cacheGet("result_type") instanceof Boolean)) {
                            QueryObserverHolder.getInstance().beforeApplyingProjectionOnFilterEvaluatedResults(result);
                            result = this.applyProjectionOnCollection(result, context, !needsTopLevelOrdering);
                        }
                    } else {
                        result = this.doIterationEvaluate(context, true);
                    }
                }
                finally {
                    if (unlock) {
                        this.releaseReadLockOnUsedIndex((PlanInfo)planInfo);
                    }
                }
            }
            assert (result != null);
            if (result instanceof SelectResults) {
                SelectResults sr = result;
                CollectionType colnType = sr.getCollectionType();
                if (this.distinct) {
                    Collection r = colnType.allowsDuplicates() ? sr.asSet() : sr;
                    result = new ResultsCollectionWrapper(colnType.getElementType(), r, limitValue);
                    if (r instanceof Bag.SetView) {
                        ((ResultsCollectionWrapper)result).setModifiable(false);
                    }
                } else if (limitValue > -1) {
                    ((Bag)sr).applyLimit(limitValue);
                }
                if (this.count) {
                    SelectResults res = result;
                    if (this.distinct || evalAsFilters || this.countStartQueryResult == 0) {
                        if (context.getBucketList() != null && this.distinct) {
                            planInfo = result;
                            return planInfo;
                        }
                        int resultCount = res.size();
                        res.clear();
                        ResultsBag countResult = new ResultsBag(new ObjectTypeImpl(Integer.class), context.getCachePerfStats());
                        countResult.addAndGetOccurence(resultCount);
                        result = countResult;
                    } else {
                        ((Bag)res).addAndGetOccurence(this.countStartQueryResult);
                    }
                }
            }
            SelectResults selectResults = result;
            return selectResults;
        }
        finally {
            context.popScope();
            context.popExecCache();
        }
    }

    private void releaseReadLockOnUsedIndex(PlanInfo planInfo) {
        List inds = planInfo.indexes;
        for (Object obj : inds) {
            Index index = (Index)obj;
            Index prIndex = ((AbstractIndex)index).getPRIndex();
            if (prIndex != null) {
                ((PartitionedIndex)prIndex).releaseIndexReadLockForRemove();
                continue;
            }
            ((AbstractIndex)index).releaseIndexReadLockForRemove();
        }
    }

    private int getRegionIteratorSize(ExecutionContext context, CompiledValue collExpr) throws RegionNotFoundException {
        String regionPath = ((CompiledRegion)collExpr).getRegionPath();
        Region region = context.getBucketRegion() == null ? context.getCache().getRegion(regionPath) : context.getBucketRegion();
        if (region != null) {
            return region.size();
        }
        InternalCache cache = context.getCache();
        if (cache.isClosed()) {
            throw new CacheClosedException();
        }
        throw new RegionNotFoundException(LocalizedStrings.CompiledRegion_REGION_NOT_FOUND_0.toLocalizedString(regionPath));
    }

    public int getLimitValue(Object[] bindArguments) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.evaluateLimitValue(bindArguments);
    }

    private SelectResults doIterationEvaluate(ExecutionContext context, boolean evaluateWhereClause) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        List tmpResults;
        SelectResults results = this.prepareEmptyResultSet(context, false);
        if (evaluateWhereClause && (tmpResults = this.optimizeBulkGet(context)) != null) {
            RuntimeIterator rIter = (RuntimeIterator)context.getCurrentIterators().get(0);
            for (Object currObj : tmpResults) {
                rIter.setCurrent(currObj);
                QueryObserver observer = QueryObserverHolder.getInstance();
                observer.beforeIterationEvaluation(rIter, currObj);
                this.applyProjectionAndAddToResultSet(context, results, this.orderByAttrs == null);
            }
            return results;
        }
        int numElementsInResult = 0;
        try {
            this.doNestedIterations(0, results, context, evaluateWhereClause, numElementsInResult);
        }
        catch (NullIteratorException ignore) {
            return null;
        }
        return results;
    }

    private List optimizeBulkGet(ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        CompiledOperation cOp;
        CompiledPath cPath;
        CompiledValue rcvr;
        List iterList = context.getCurrentIterators();
        if (iterList.size() != 1) {
            return null;
        }
        if (!(this.whereClause instanceof CompiledIn)) {
            return null;
        }
        RuntimeIterator rIter = (RuntimeIterator)iterList.get(0);
        CompiledIteratorDef cIterDef = rIter.getCmpIteratorDefn();
        CompiledValue colnExpr = cIterDef.getCollectionExpr();
        boolean match = false;
        CompiledRegion rgn = null;
        if (colnExpr instanceof CompiledPath && (rcvr = (cPath = (CompiledPath)colnExpr).getReceiver()) instanceof CompiledRegion) {
            rgn = (CompiledRegion)rcvr;
            String attr = cPath.getTailID();
            match = attr.equals("entrySet");
        }
        if (!match && colnExpr instanceof CompiledOperation && (rcvr = (cOp = (CompiledOperation)colnExpr).getReceiver(context)) instanceof CompiledRegion) {
            rgn = (CompiledRegion)rcvr;
            match = cOp.getMethodName().equals("entrySet");
        }
        if (!match) {
            return null;
        }
        CompiledIn cIn = (CompiledIn)this.whereClause;
        return cIn.optimizeBulkGet(rgn, context);
    }

    private int doNestedIterations(int level, SelectResults results, ExecutionContext context, boolean evaluateWhereClause, int numElementsInResult) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, NullIteratorException {
        block15: {
            List iterList;
            block14: {
                int occurrence;
                iterList = context.getCurrentIterators();
                if (level != iterList.size()) break block14;
                boolean addToResults = true;
                if (evaluateWhereClause) {
                    Object result = this.whereClause.evaluate(context);
                    QueryObserver observer = QueryObserverHolder.getInstance();
                    observer.afterIterationEvaluation(result);
                    if (result == null) {
                        addToResults = false;
                    } else if (result instanceof Boolean) {
                        addToResults = (Boolean)result;
                    } else if (result == QueryService.UNDEFINED) {
                        if (this.whereClause.getType() == -1) {
                            int operator = ((Filter)((Object)this.whereClause)).getOperator();
                            if (operator != 20 && operator != 21) {
                                addToResults = false;
                            }
                        } else {
                            addToResults = false;
                        }
                    } else {
                        throw new TypeMismatchException(LocalizedStrings.CompiledSelect_THE_WHERE_CLAUSE_WAS_TYPE_0_INSTEAD_OF_BOOLEAN.toLocalizedString(result.getClass().getName()));
                    }
                }
                if (!addToResults || (occurrence = this.applyProjectionAndAddToResultSet(context, results, this.orderByAttrs == null)) != 1 && (occurrence <= 1 || this.distinct)) break block15;
                ++numElementsInResult;
                break block15;
            }
            RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
            SelectResults sr = rIter.evaluateCollection(context);
            if (sr == null) {
                return 0;
            }
            if (this.whereClause == null && this.iterators.size() == 1 && this.isCount() && !this.isDistinct() && sr instanceof QRegion) {
                QRegion qr = (QRegion)sr;
                this.countStartQueryResult = qr.getRegion().size();
                return 1;
            }
            if (context.getQuery() != null && ((DefaultQuery)context.getQuery()).isKeepSerialized() && sr instanceof QRegion) {
                ((QRegion)sr).setKeepSerialized(true);
            }
            for (Object aSr : sr) {
                QueryMonitor.isQueryExecutionCanceled();
                Object currObj = aSr;
                rIter.setCurrent(currObj);
                QueryObserver observer = QueryObserverHolder.getInstance();
                observer.beforeIterationEvaluation(rIter, currObj);
                numElementsInResult = this.doNestedIterations(level + 1, results, context, evaluateWhereClause, numElementsInResult);
                Integer limitValue = CompiledSelect.evaluateLimitValue(context, this.limit);
                if (this.orderByAttrs != null || limitValue <= -1 || numElementsInResult != limitValue) continue;
                break;
            }
        }
        return numElementsInResult;
    }

    private SelectResults applyProjectionOnCollection(SelectResults resultSet, ExecutionContext context, boolean ignoreOrderBy) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        boolean isStructType;
        List iterators = context.getCurrentIterators();
        if (this.projAttrs == null && (this.orderByAttrs == null || ignoreOrderBy)) {
            if (iterators.size() > 1) {
                StructTypeImpl type = this.createStructTypeForNullProjection(iterators, context);
                resultSet.setElementType(type);
            }
            return resultSet;
        }
        int numElementsAdded = 0;
        SelectResults pResultSet = this.prepareEmptyResultSet(context, ignoreOrderBy);
        boolean bl = isStructType = resultSet.getCollectionType().getElementType() != null && resultSet.getCollectionType().getElementType().isStructType();
        if (isStructType) {
            Iterator resultsIter = resultSet.iterator();
            Integer limitValue = CompiledSelect.evaluateLimitValue(context, this.limit);
            while ((this.orderByAttrs != null && !ignoreOrderBy || limitValue < 0 || numElementsAdded < limitValue) && resultsIter.hasNext()) {
                QueryMonitor.isQueryExecutionCanceled();
                Object[] values = ((Struct)resultsIter.next()).getFieldValues();
                for (int i = 0; i < values.length; ++i) {
                    ((RuntimeIterator)iterators.get(i)).setCurrent(values[i]);
                }
                int occurence = this.applyProjectionAndAddToResultSet(context, pResultSet, ignoreOrderBy);
                if (occurence != 1 && (occurence <= 1 || this.distinct)) continue;
                ++numElementsAdded;
            }
        } else if (iterators.size() == 1) {
            RuntimeIterator rIter = (RuntimeIterator)iterators.get(0);
            Iterator resultsIter = resultSet.iterator();
            Integer limitValue = CompiledSelect.evaluateLimitValue(context, this.limit);
            while ((this.orderByAttrs != null && !ignoreOrderBy || limitValue < 0 || numElementsAdded < limitValue) && resultsIter.hasNext()) {
                rIter.setCurrent(resultsIter.next());
                int occurrence = this.applyProjectionAndAddToResultSet(context, pResultSet, ignoreOrderBy);
                if (occurrence != 1 && (occurrence <= 1 || this.distinct)) continue;
                ++numElementsAdded;
            }
        } else {
            throw new RuntimeException(LocalizedStrings.CompiledSelect_RESULT_SET_DOES_NOT_MATCH_WITH_ITERATOR_DEFINITIONS_IN_FROM_CLAUSE.toLocalizedString());
        }
        return pResultSet;
    }

    private SelectResults prepareEmptyResultSet(ExecutionContext context, boolean ignoreOrderBy) throws TypeMismatchException, AmbiguousNameException {
        ObjectType elementType;
        ObjectType objectType = elementType = this.cachedElementTypeForOrderBy != null ? this.cachedElementTypeForOrderBy : this.prepareResultType(context);
        if (!this.distinct && this.count) {
            ResultsBag results = new ResultsBag(new ObjectTypeImpl(Integer.class), 1, context.getCachePerfStats());
            this.countStartQueryResult = 0;
            return results;
        }
        boolean nullValuesAtStart = this.orderByAttrs != null && !this.orderByAttrs.get(0).getCriterion();
        boolean isOrdered = this.orderByAttrs != null;
        switch (DataContainerType.determineDataContainerType(isOrdered, this.distinct, elementType.isStructType(), ignoreOrderBy)) {
            case UNORDERED_DISTINCT_STRUCT: {
                return new StructSet((StructType)elementType);
            }
            case UNORDERED_DISTINCT_RESULTS: {
                return new ResultsSet(elementType);
            }
            case UNORDERED_INDISTINCT_STRUCT: {
                return new StructBag((StructType)elementType, context.getCachePerfStats());
            }
            case UNORDERED_INDISTINCT_RESULTS: {
                return new ResultsBag(elementType, context.getCachePerfStats());
            }
            case ORDERED_DISTINCT_STRUCT_IGNORED: {
                return new LinkedStructSet((StructTypeImpl)elementType);
            }
            case ORDERED_INDISTINCT_STRUCT_IGNORED: {
                return new SortedResultsBag(elementType, nullValuesAtStart);
            }
            case ORDERED_DISTINCT_STRUCT_UNIGNORED: {
                OrderByComparator comparator = this.hasUnmappedOrderByCols ? new OrderByComparatorMapped(this.orderByAttrs, elementType, context) : new OrderByComparator(this.orderByAttrs, elementType, context);
                return new SortedStructSet(comparator, (StructTypeImpl)elementType);
            }
            case ORDERED_INDISTINCT_STRUCT_UNIGNORED: {
                OrderByComparator comparator = this.hasUnmappedOrderByCols ? new OrderByComparatorMapped(this.orderByAttrs, elementType, context) : new OrderByComparator(this.orderByAttrs, elementType, context);
                return new SortedStructBag((Comparator<Object[]>)comparator, (StructType)elementType, nullValuesAtStart);
            }
            case ORDERED_DISTINCT_RESULTS_IGNORED: {
                LinkedResultSet results = new LinkedResultSet();
                results.setElementType(elementType);
                return results;
            }
            case ORDERED_INDISTINCT_RESULTS_IGNORED: {
                SortedResultsBag results = new SortedResultsBag(nullValuesAtStart);
                results.setElementType(elementType);
                return results;
            }
            case ORDERED_DISTINCT_RESULTS_UNIGNORED: {
                OrderByComparator comparator = this.hasUnmappedOrderByCols ? new OrderByComparatorMapped(this.orderByAttrs, elementType, context) : new OrderByComparator(this.orderByAttrs, elementType, context);
                SortedResultSet results = new SortedResultSet((Comparator)comparator);
                results.setElementType(elementType);
                return results;
            }
            case ORDERED_INDISTINCT_RESULTS_UNIGNORED: {
                OrderByComparator comparator = this.hasUnmappedOrderByCols ? new OrderByComparatorMapped(this.orderByAttrs, elementType, context) : new OrderByComparator(this.orderByAttrs, elementType, context);
                SortedResultsBag results = new SortedResultsBag(comparator, nullValuesAtStart);
                results.setElementType(elementType);
                return results;
            }
        }
        throw new TypeMismatchException("Logical inconsistency in CompiledSelect");
    }

    protected ObjectType prepareResultType(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        ObjectType elementType = null;
        Object sr = null;
        List currentIterators = context.getCurrentIterators();
        if (this.projAttrs == null) {
            if (currentIterators.size() == 1) {
                RuntimeIterator iter = (RuntimeIterator)currentIterators.get(0);
                elementType = iter.getElementType();
            } else {
                elementType = this.createStructTypeForNullProjection(currentIterators, context);
            }
        } else {
            int projCount = this.projAttrs.size();
            String[] fieldNames = new String[projCount];
            ObjectType[] fieldTypes = new ObjectType[projCount];
            boolean createStructSet = false;
            String fldName = null;
            for (int i = 0; i < projCount; ++i) {
                Object[] projDef = (Object[])this.projAttrs.get(i);
                fldName = (String)projDef[0];
                if (!(createStructSet || fldName == null && projCount <= 1)) {
                    createStructSet = true;
                }
                fieldNames[i] = fldName == null && createStructSet ? this.generateProjectionName((CompiledValue)projDef[1], context) : fldName;
                fieldTypes[i] = this.getFieldTypeOfProjAttrib(context, (CompiledValue)projDef[1]);
            }
            elementType = createStructSet ? new StructTypeImpl(fieldNames, fieldTypes) : fieldTypes[0];
        }
        return elementType;
    }

    private StructTypeImpl createStructTypeForNullProjection(List currentIterators, ExecutionContext context) {
        int len = currentIterators.size();
        String[] fieldNames = new String[len];
        ObjectType[] fieldTypes = new ObjectType[len];
        String fldName = null;
        for (int i = 0; i < len; ++i) {
            RuntimeIterator iter = (RuntimeIterator)currentIterators.get(i);
            fldName = iter.getName();
            if (fldName == null) {
                fldName = this.generateProjectionName(iter, context);
            }
            fieldNames[i] = fldName;
            fieldTypes[i] = iter.getElementType();
        }
        return new StructTypeImpl(fieldNames, fieldTypes);
    }

    private ObjectType getFieldTypeOfProjAttrib(ExecutionContext context, CompiledValue cv) throws TypeMismatchException, AmbiguousNameException {
        ObjectType retType = TypeUtils.OBJECT_TYPE;
        try {
            RuntimeIterator rit = context.findRuntimeIterator(cv);
            List pathOnItr = cv.getPathOnIterator(rit, context);
            if (pathOnItr != null) {
                String[] path = pathOnItr.toArray(new String[pathOnItr.size()]);
                ObjectType[] ot = PathUtils.calculateTypesAlongPath(context, rit.getElementType(), path);
                retType = ot[ot.length - 1];
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return retType;
    }

    private int applyProjectionAndAddToResultSet(ExecutionContext context, SelectResults resultSet, boolean ignoreOrderBy) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        List currrentRuntimeIters = context.getCurrentIterators();
        int occurence = 0;
        ObjectType elementType = resultSet.getCollectionType().getElementType();
        boolean isStruct = elementType != null && elementType.isStructType();
        boolean isLinkedStructure = resultSet instanceof Ordered && ((Ordered)((Object)resultSet)).dataPreordered();
        Object evaluatedOrderByClause = null;
        OrderByComparator comparator = null;
        boolean applyOrderBy = false;
        if (this.orderByAttrs != null && !ignoreOrderBy) {
            Integer limitValue = CompiledSelect.evaluateLimitValue(context, this.limit);
            if (context.getPartitionedRegion() != null && limitValue < 0) {
                applyOrderBy = false;
            }
            applyOrderBy = true;
        }
        if (this.orderByAttrs != null && !ignoreOrderBy) {
            comparator = (OrderByComparator)((Ordered)((Object)resultSet)).comparator();
        }
        if (this.projAttrs == null) {
            int len = currrentRuntimeIters.size();
            Object[] values = new Object[len];
            for (int i = 0; i < len; ++i) {
                RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(i);
                values[i] = iter.evaluate(context);
                if (!this.distinct || ((DefaultQuery)context.getQuery()).isRemoteQuery() || context.getCache().getPdxReadSerialized() || !(values[i] instanceof PdxInstance)) continue;
                values[i] = ((PdxInstance)values[i]).getObject();
            }
            if (this.isCount() && !this.distinct) {
                ++this.countStartQueryResult;
                occurence = 1;
            } else if (applyOrderBy) {
                if (this.distinct) {
                    if (isStruct) {
                        if (values.length == 1 && values[0] instanceof StructImpl) {
                            StructImpl structImpl = (StructImpl)values[0];
                            comparator.addEvaluatedSortCriteria(structImpl.getFieldValues(), context);
                            occurence = resultSet.add(structImpl) ? 1 : 0;
                        } else {
                            comparator.addEvaluatedSortCriteria(values, context);
                            occurence = ((StructFields)((Object)resultSet)).addFieldValues(values) ? 1 : 0;
                        }
                    } else {
                        comparator.addEvaluatedSortCriteria(values[0], context);
                        occurence = resultSet.add(values[0]) ? 1 : 0;
                    }
                } else if (isStruct) {
                    if (values.length == 1 && values[0] instanceof StructImpl) {
                        StructImpl structImpl = (StructImpl)values[0];
                        comparator.addEvaluatedSortCriteria(structImpl.getFieldValues(), context);
                        occurence = ((Bag)resultSet).addAndGetOccurence(structImpl.getFieldValues());
                    } else {
                        comparator.addEvaluatedSortCriteria(values, context);
                        occurence = ((Bag)resultSet).addAndGetOccurence(values);
                    }
                } else {
                    comparator.addEvaluatedSortCriteria(values[0], context);
                    occurence = ((Bag)resultSet).addAndGetOccurence(values[0]);
                }
            } else if (isLinkedStructure) {
                if (isStruct) {
                    StructImpl structImpl = values.length == 1 && values[0] instanceof StructImpl ? (StructImpl)values[0] : new StructImpl((StructTypeImpl)elementType, values);
                    occurence = this.distinct ? (resultSet.add(structImpl) ? 1 : 0) : ((Bag)resultSet).addAndGetOccurence(structImpl);
                } else {
                    occurence = this.distinct ? (resultSet.add(values[0]) ? 1 : 0) : ((Bag)resultSet).addAndGetOccurence(values[0]);
                }
            } else if (this.distinct) {
                occurence = isStruct ? (((StructFields)((Object)resultSet)).addFieldValues(values) ? 1 : 0) : (resultSet.add(values[0]) ? 1 : 0);
            } else if (isStruct) {
                occurence = ((Bag)resultSet).addAndGetOccurence(values);
            } else {
                boolean add = true;
                if (context.isCqQueryContext() && values[0] instanceof Region.Entry) {
                    Region.Entry e = (Region.Entry)values[0];
                    if (!e.isDestroyed()) {
                        try {
                            values[0] = new CqEntry(e.getKey(), e.getValue());
                        }
                        catch (EntryDestroyedException ignore) {
                            add = false;
                        }
                    } else {
                        add = false;
                    }
                }
                if (add) {
                    occurence = ((Bag)resultSet).addAndGetOccurence(values[0]);
                }
            }
        } else {
            int projCount = this.projAttrs.size();
            Object[] values = new Object[projCount];
            for (int i = 0; i < projCount; ++i) {
                Object[] projDef = (Object[])this.projAttrs.get(i);
                values[i] = ((CompiledValue)projDef[1]).evaluate(context);
                if (((DefaultQuery)context.getQuery()).isRemoteQuery()) continue;
                if (this.distinct && values[i] instanceof PdxInstance && !context.getCache().getPdxReadSerialized()) {
                    values[i] = ((PdxInstance)values[i]).getObject();
                    continue;
                }
                if (!(values[i] instanceof PdxString)) continue;
                values[i] = values[i].toString();
            }
            if (applyOrderBy) {
                if (this.distinct) {
                    if (isStruct) {
                        comparator.addEvaluatedSortCriteria(values, context);
                        occurence = ((StructFields)((Object)resultSet)).addFieldValues(values) ? 1 : 0;
                    } else {
                        comparator.addEvaluatedSortCriteria(values[0], context);
                        occurence = resultSet.add(values[0]) ? 1 : 0;
                    }
                } else if (isStruct) {
                    comparator.addEvaluatedSortCriteria(values, context);
                    occurence = ((Bag)resultSet).addAndGetOccurence(values);
                } else {
                    comparator.addEvaluatedSortCriteria(values[0], context);
                    occurence = ((Bag)resultSet).addAndGetOccurence(values[0]);
                }
            } else if (isLinkedStructure) {
                if (isStruct) {
                    StructImpl structImpl = new StructImpl((StructTypeImpl)elementType, values);
                    occurence = this.distinct ? (resultSet.add(structImpl) ? 1 : 0) : ((Bag)resultSet).addAndGetOccurence(structImpl);
                } else {
                    occurence = this.distinct ? (resultSet.add(values[0]) ? 1 : 0) : ((Bag)resultSet).addAndGetOccurence(values[0]);
                }
            } else {
                occurence = this.distinct ? (isStruct ? (((StructFields)((Object)resultSet)).addFieldValues(values) ? 1 : 0) : (resultSet.add(values[0]) ? 1 : 0)) : (isStruct ? ((Bag)resultSet).addAndGetOccurence(values) : ((Bag)resultSet).addAndGetOccurence(values[0]));
            }
        }
        return occurence;
    }

    private String generateProjectionName(CompiledValue projExpr, ExecutionContext context) {
        String name = null;
        if (projExpr instanceof RuntimeIterator) {
            RuntimeIterator rIter = (RuntimeIterator)projExpr;
            name = rIter.getDefinition();
            int index = name.lastIndexOf(46);
            if (index > 0) {
                name = name.substring(index + 1);
            } else if (name.charAt(0) == '/') {
                index = name.lastIndexOf(47);
                name = name.substring(index + 1);
            } else {
                name = rIter.getInternalId();
            }
        } else {
            int type = projExpr.getType();
            name = type == -5 ? ((CompiledPath)projExpr).getTailID() : (type == 35 ? ((CompiledID)projExpr).getId() : (type == -4 ? ((CompiledLiteral)projExpr)._obj.toString() : (type == 54 ? ((CompiledOperation)projExpr).getMethodName() : "field$" + context.nextFieldNum())));
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluateCq(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.whereClause == null) {
            return true;
        }
        context.newScope((Integer)context.cacheGet(this.scopeID));
        context.pushExecCache((Integer)context.cacheGet(this.scopeID));
        try {
            Object b;
            CompiledIteratorDef iterDef = (CompiledIteratorDef)this.iterators.get(0);
            RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
            context.bindIterator(rIter);
            Object evalResult2 = iterDef.getCollectionExpr().evaluate(context);
            if (evalResult2 == null || evalResult2 == QueryService.UNDEFINED) {
                boolean bl = false;
                return bl;
            }
            Collection coll = (Collection)evalResult2;
            if (coll.isEmpty()) {
                boolean evalResult2 = false;
                return evalResult2;
            }
            if (this.whereClause.isDependentOnCurrentScope(context)) {
                Iterator cIter = coll.iterator();
                Object currObj = cIter.next();
                rIter.setCurrent(currObj);
            }
            if ((b = this.whereClause.evaluate(context)) == null) {
                boolean currObj = false;
                return currObj;
            }
            if (b == QueryService.UNDEFINED) {
                if (this.whereClause.getType() == -1) {
                    int operator = ((Filter)((Object)this.whereClause)).getOperator();
                    boolean bl = operator == 20 || operator == 21;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = (Boolean)b;
            return bl;
        }
        finally {
            context.popExecCache();
            context.popScope();
        }
    }

    private Integer evaluateLimitValue(Object[] bindArguments) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Integer limitValue = -1;
        if (this.limit != null) {
            limitValue = this.limit instanceof CompiledBindArgument ? (Integer)((CompiledBindArgument)this.limit).evaluate(bindArguments) : (Integer)this.limit.evaluate(null);
        }
        return limitValue;
    }

    protected static Integer evaluateLimitValue(ExecutionContext context, CompiledValue limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Integer limitValue = -1;
        if (limit != null && (limitValue = (Integer)limit.evaluate(context)) == null) {
            limitValue = -1;
        }
        return limitValue;
    }

    private static class NullIteratorException
    extends Exception {
        private NullIteratorException() {
        }
    }

    public static enum DataContainerType {
        UNORDERED_DISTINCT_STRUCT(false, true, true, true),
        UNORDERED_DISTINCT_RESULTS(false, true, false, true),
        UNORDERED_INDISTINCT_STRUCT(false, false, true, true),
        UNORDERED_INDISTINCT_RESULTS(false, false, false, true),
        ORDERED_DISTINCT_STRUCT_IGNORED(true, true, true, true),
        ORDERED_INDISTINCT_STRUCT_IGNORED(true, false, true, true),
        ORDERED_DISTINCT_STRUCT_UNIGNORED(true, true, true, false),
        ORDERED_INDISTINCT_STRUCT_UNIGNORED(true, false, true, false),
        ORDERED_DISTINCT_RESULTS_IGNORED(true, true, false, true),
        ORDERED_INDISTINCT_RESULTS_IGNORED(true, false, false, true),
        ORDERED_DISTINCT_RESULTS_UNIGNORED(true, true, false, false),
        ORDERED_INDISTINCT_RESULTS_UNIGNORED(true, false, false, false);

        private final boolean isOrdered;
        private final boolean isDistinct;
        private final boolean isStructType;
        private final boolean isIgnoreOrderBy;

        public static DataContainerType determineDataContainerType(boolean getOrdered, boolean getDistinct, boolean getStructType, boolean getIgnoreOrderBy) throws TypeMismatchException {
            return Arrays.stream(DataContainerType.values()).filter(type -> type.isOrdered == getOrdered).filter(type -> type.isDistinct == getDistinct).filter(type -> type.isStructType == getStructType).filter(type -> type.isIgnoreOrderBy == getIgnoreOrderBy || !type.isOrdered).findFirst().orElseThrow(() -> new TypeMismatchException("Logical inconsistency in CompiledSelect"));
        }

        private DataContainerType(boolean isOrdered, boolean isDistinct, boolean isStructType, boolean isIgnoreOrderBy) {
            this.isOrdered = isOrdered;
            this.isDistinct = isDistinct;
            this.isStructType = isStructType;
            this.isIgnoreOrderBy = isIgnoreOrderBy;
        }
    }
}

