/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.ServerOperationException;
import org.apache.geode.cache.client.internal.ClientMetadataService;
import org.apache.geode.cache.client.internal.GetAllOp;
import org.apache.geode.cache.client.internal.SingleHopOperationCallable;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionInvocationTargetException;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PutAllPartialResultException;
import org.apache.geode.internal.cache.execute.BucketMovedException;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.LoggingThreadGroup;
import org.apache.geode.internal.logging.log4j.LocalizedMessage;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SingleHopClientExecutor {
    private static final Logger logger = LogService.getLogger();
    static final ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){
        AtomicInteger threadNum = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(LoggingThreadGroup.createThreadGroup("FunctionExecutionThreadGroup", logger), r, "Function Execution Thread-" + this.threadNum.incrementAndGet());
            result.setDaemon(true);
            return result;
        }
    });

    static void submitAll(List callableTasks) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator itr = futures.iterator();
                while (itr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = itr.next();
                    try {
                        fut.get();
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof FunctionException) {
                            throw (FunctionException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerOperationException) {
                            throw (ServerOperationException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            throw (ServerConnectivityException)ee.getCause();
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
            }
        }
    }

    static boolean submitAllHA(List callableTasks, LocalRegion region, boolean isHA, ResultCollector rc, Set<String> failedNodes) {
        ClientMetadataService cms = region.getCache().getClientMetadataService();
        boolean reexecute = false;
        if (callableTasks != null && !callableTasks.isEmpty()) {
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                GemFireException functionExecutionException = null;
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                boolean isDebugEnabled = logger.isDebugEnabled();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    ServerLocation server = task.getServer();
                    try {
                        fut.get();
                        if (!isDebugEnabled) continue;
                        logger.debug("ExecuteRegionFunctionSingleHopOp#got result from {}", (Object)server);
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof InternalFunctionInvocationTargetException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.InternalFunctionInvocationTargetException : Caused by :{}", ee.getCause());
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return false;
                            }
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            reexecute = true;
                            failedNodes.addAll(((InternalFunctionInvocationTargetException)ee.getCause()).getFailedNodeSet());
                            if (isHA) {
                                rc.clearResults();
                                continue;
                            }
                            if (ee.getCause().getCause() != null) {
                                functionExecutionException = new FunctionInvocationTargetException(ee.getCause().getCause());
                                continue;
                            }
                            functionExecutionException = new FunctionInvocationTargetException(new BucketMovedException(LocalizedStrings.FunctionService_BUCKET_MIGRATED_TO_ANOTHER_NODE.toLocalizedString()));
                            continue;
                        }
                        if (ee.getCause() instanceof FunctionException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.FunctionException : Caused by :{}", ee.getCause());
                            }
                            FunctionException fe = (FunctionException)ee.getCause();
                            if (isHA) {
                                throw fe;
                            }
                            functionExecutionException = fe;
                            continue;
                        }
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.ServerOperationException : Caused by :{}", ee.getCause());
                            }
                            ServerOperationException soe = (ServerOperationException)ee.getCause();
                            if (isHA) {
                                throw soe;
                            }
                            functionExecutionException = soe;
                            continue;
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.ServerConnectivityException : Caused by :{} The failed server is: {}", (Object)ee.getCause(), (Object)server);
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return false;
                            }
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            if (isHA) {
                                reexecute = true;
                                rc.clearResults();
                                continue;
                            }
                            functionExecutionException = (ServerConnectivityException)ee.getCause();
                            continue;
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
                if (functionExecutionException != null) {
                    throw functionExecutionException;
                }
            }
        }
        return reexecute;
    }

    static Map<ServerLocation, Object> submitBulkOp(List callableTasks, ClientMetadataService cms, LocalRegion region, Map<ServerLocation, RuntimeException> failedServers) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            HashMap<ServerLocation, Object> resultMap = new HashMap<ServerLocation, Object>();
            boolean anyPartialResults = false;
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                RuntimeException rte = null;
                boolean isDebugEnabled = logger.isDebugEnabled();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    ServerLocation server = task.getServer();
                    try {
                        VersionedObjectList versions = (VersionedObjectList)fut.get();
                        if (logger.isDebugEnabled()) {
                            logger.debug("submitBulkOp#got result from {}:{}", (Object)server, (Object)versions);
                        }
                        resultMap.put(server, versions);
                    }
                    catch (InterruptedException e) {
                        InternalGemFireException ige = new InternalGemFireException(e);
                        failedServers.put(server, ige);
                        if (rte != null) continue;
                        rte = ige;
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("submitBulkOp#ExecutionException from server {}", (Object)server, (Object)ee);
                            }
                            ServerOperationException soe = (ServerOperationException)ee.getCause();
                            failedServers.put(server, soe);
                            if (rte != null) continue;
                            rte = soe;
                            continue;
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("submitBulkOp#ExecutionException for server {}", (Object)server, (Object)ee);
                            }
                            cms = region.getCache().getClientMetadataService();
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            failedServers.put(server, (ServerConnectivityException)ee.getCause());
                            continue;
                        }
                        Throwable t = ee.getCause();
                        if (t instanceof PutAllPartialResultException) {
                            resultMap.put(server, t);
                            anyPartialResults = true;
                            failedServers.put(server, (PutAllPartialResultException)t);
                            continue;
                        }
                        RuntimeException other_rte = SingleHopClientExecutor.executionThrowable(ee.getCause());
                        failedServers.put(server, other_rte);
                        if (rte != null) continue;
                        rte = other_rte;
                    }
                }
                if (rte != null && !anyPartialResults) {
                    throw rte;
                }
            }
            return resultMap;
        }
        return null;
    }

    static Map<ServerLocation, Object> submitGetAll(Map<ServerLocation, HashSet> serverToFilterMap, List callableTasks, ClientMetadataService cms, LocalRegion region) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            HashMap<ServerLocation, Object> resultMap = new HashMap<ServerLocation, Object>();
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    List keys = ((GetAllOp.GetAllOpImpl)task.getOperation()).getKeyList();
                    ServerLocation server = task.getServer();
                    try {
                        VersionedObjectList valuesFromServer = (VersionedObjectList)fut.get();
                        valuesFromServer.setKeys(keys);
                        VersionedObjectList.Iterator it = valuesFromServer.iterator();
                        while (it.hasNext()) {
                            VersionedObjectList.Entry entry = it.next();
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            if (entry.isKeyNotOnServer() || !(value instanceof Throwable)) continue;
                            logger.warn((Message)LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{value, key}), (Throwable)value);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("GetAllOp#got result from {}: {}", (Object)server, (Object)valuesFromServer);
                        }
                        resultMap.put(server, valuesFromServer);
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetAllOp#ExecutionException.ServerOperationException : Caused by :{}", ee.getCause());
                            }
                            throw (ServerOperationException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetAllOp#ExecutionException.ServerConnectivityException : Caused by :{} The failed server is: {}", (Object)ee.getCause(), (Object)server);
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return null;
                            }
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            resultMap.put(server, ee.getCause());
                            continue;
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
                return resultMap;
            }
        }
        return null;
    }

    static void submitTask(Runnable task) {
        execService.execute(task);
    }

    private static RuntimeException executionThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Don't know", t);
    }
}

