/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import org.apache.geode.admin.AdminDistributedSystem;
import org.apache.geode.admin.internal.DisabledManagedEntityController;
import org.apache.geode.admin.internal.EnabledManagedEntityController;
import org.apache.geode.admin.internal.ManagedEntityController;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.logging.log4j.Logger;

public class ManagedEntityControllerFactory {
    private static final Logger logger = LogService.getLogger();
    private static final String ENABLED_MANAGED_ENTITY_CONTROLLER_CLASS_NAME = "org.apache.geode.admin.internal.EnabledManagedEntityController";

    static ManagedEntityController createManagedEntityController(AdminDistributedSystem system) {
        if (ManagedEntityControllerFactory.isEnabledManagedEntityController()) {
            logger.info(LogMarker.CONFIG_MARKER, "Local and remote OS command invocations are enabled for the Admin API.");
            return ManagedEntityControllerFactory.createEnabledManagedEntityController(system);
        }
        logger.info(LogMarker.CONFIG_MARKER, "Local and remote OS command invocations are disabled for the Admin API.");
        return new DisabledManagedEntityController();
    }

    public static boolean isEnabledManagedEntityController() {
        try {
            ClassPathLoader.getLatest().forName(ENABLED_MANAGED_ENTITY_CONTROLLER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static ManagedEntityController createEnabledManagedEntityController(AdminDistributedSystem system) {
        return new EnabledManagedEntityController(system);
    }
}

