/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteClient;
import com.healthmarketscience.rmiio.RemoteRetry;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWrapper<RemoteType>
implements InvocationHandler,
RemoteClient {
    protected final RemoteType _stub;
    protected RemoteRetry _retry;
    protected final Log _log;

    public RemoteWrapper(RemoteType stub, RemoteRetry retry, Log log) {
        if (stub == null) {
            throw new IllegalArgumentException("Remote stub cannot be null");
        }
        this._stub = stub;
        this._retry = retry;
        this._log = log;
    }

    public static <R> R wrap(Class<R> iface, R stub, RemoteRetry retry, Log log) {
        RemoteWrapper<R> wrapper = new RemoteWrapper<R>(stub, retry, log);
        return iface.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{iface}, wrapper));
    }

    public static RemoteWrapper<?> getWrapper(Object proxy) {
        return (RemoteWrapper)Proxy.getInvocationHandler(proxy);
    }

    public RemoteType getStub() {
        return this._stub;
    }

    public Log getLog() {
        return this._log;
    }

    public RemoteRetry getRemoteRetry() {
        return this._retry;
    }

    @Override
    public void setRemoteRetry(RemoteRetry retry) {
        this._retry = retry != null ? retry : DEFAULT_RETRY;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        return this._retry.call(new RemoteRetry.Caller<Object>(){

            @Override
            public Object call() throws Exception {
                return method.invoke(RemoteWrapper.this._stub, method, args);
            }
        }, this._log, Exception.class);
    }
}

