/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.xml.JdbcConnectorServiceXmlGenerator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;

public class JdbcServiceConfiguration
implements Extension<Cache> {
    private final List<ConnectionConfiguration> connections = new ArrayList<ConnectionConfiguration>();
    private final List<RegionMapping> mappings = new ArrayList<RegionMapping>();

    void addConnectionConfig(ConnectionConfiguration config) {
        this.connections.add(config);
    }

    void addRegionMapping(RegionMapping mapping) {
        this.mappings.add(mapping);
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return new JdbcConnectorServiceXmlGenerator(this.connections, this.mappings);
    }

    public void beforeCreate(Extensible<Cache> source, Cache cache) {
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
        InternalCache internalCache = (InternalCache)target;
        JdbcConnectorService service = (JdbcConnectorService)internalCache.getService(JdbcConnectorService.class);
        this.connections.forEach(connection -> this.createConnectionConfig(service, (ConnectionConfiguration)connection));
        this.mappings.forEach(mapping -> this.createRegionMapping(service, (RegionMapping)mapping));
    }

    private void createConnectionConfig(JdbcConnectorService service, ConnectionConfiguration connectionConfig) {
        try {
            service.createConnectionConfig(connectionConfig);
        }
        catch (ConnectionConfigExistsException e) {
            throw new InternalGemFireException((Throwable)e);
        }
    }

    private void createRegionMapping(JdbcConnectorService service, RegionMapping regionMapping) {
        try {
            service.createRegionMapping(regionMapping);
        }
        catch (RegionMappingExistsException e) {
            throw new InternalGemFireException((Throwable)e);
        }
    }
}

