/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.cli.ListMappingFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;

@Experimental
public class ListMappingCommand
extends InternalGfshCommand {
    static final String LIST_MAPPING = "list jdbc-mappings";
    static final String LIST_MAPPING__HELP = "(Experimental) Display jdbc mappings for all members.";
    static final String LIST_OF_MAPPINGS = "List of mappings";
    static final String NO_MAPPINGS_FOUND = "No mappings found";

    @CliCommand(value={"list jdbc-mappings"}, help="(Experimental) Display jdbc mappings for all members.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result listMapping() {
        Set targetMembers = this.getMembers(null, null);
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult((String)"No Members Found");
        }
        ResultCollector<RegionMapping, List<RegionMapping[]>> resultCollector = this.execute(new ListMappingFunction(), (DistributedMember)targetMembers.iterator().next());
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        boolean mappingsExist = this.fillTabularResultData(resultCollector, tabularResultData);
        return this.createResult(tabularResultData, mappingsExist);
    }

    ResultCollector<RegionMapping, List<RegionMapping[]>> execute(ListMappingFunction function, DistributedMember targetMember) {
        return this.executeFunction((Function)function, null, targetMember);
    }

    private Result createResult(TabularResultData tabularResultData, boolean mappingsExist) {
        if (mappingsExist) {
            tabularResultData.setHeader("(Experimental) ");
            return ResultBuilder.buildResult((ResultData)tabularResultData);
        }
        return ResultBuilder.createInfoResult((String)"(Experimental) \nNo mappings found");
    }

    private boolean fillTabularResultData(ResultCollector<RegionMapping, List<RegionMapping[]>> resultCollector, TabularResultData tabularResultData) {
        HashSet<RegionMapping> regionMappings = new HashSet<RegionMapping>();
        for (Object resultObject : (List)resultCollector.getResult()) {
            if (resultObject instanceof RegionMapping[]) {
                regionMappings.addAll(Arrays.asList((RegionMapping[])resultObject));
                continue;
            }
            if (resultObject instanceof Throwable) {
                throw new IllegalStateException((Throwable)resultObject);
            }
            throw new IllegalStateException(resultObject.getClass().getName());
        }
        for (RegionMapping mapping : regionMappings) {
            tabularResultData.accumulate(LIST_OF_MAPPINGS, (Object)mapping.getRegionName());
        }
        return !regionMappings.isEmpty();
    }
}

