/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.cli.ExceptionHandler;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public abstract class JdbcCliFunction<T1, T2>
implements InternalFunction<T1> {
    private final transient ExceptionHandler exceptionHandler = new ExceptionHandler();

    JdbcCliFunction() {
    }

    public boolean isHA() {
        return false;
    }

    public String getId() {
        return this.getClass().getName();
    }

    public void execute(FunctionContext<T1> context) {
        try {
            JdbcConnectorService service = FunctionContextArgumentProvider.getJdbcConnectorService(context);
            T2 result = this.getFunctionResult(service, context);
            context.getResultSender().lastResult(result);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(context, e);
        }
    }

    String getMember(FunctionContext<T1> context) {
        return FunctionContextArgumentProvider.getMember(context);
    }

    XmlEntity createXmlEntity(FunctionContext<T1> context) {
        return FunctionContextArgumentProvider.createXmlEntity(context);
    }

    abstract T2 getFunctionResult(JdbcConnectorService var1, FunctionContext<T1> var2) throws Exception;
}

