/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingBuilder;
import org.apache.geode.connectors.jdbc.internal.cli.AlterMappingFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalClusterConfigurationService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.InternalGfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class AlterMappingCommand
extends InternalGfshCommand {
    static final String ALTER_MAPPING = "alter jdbc-mapping";
    static final String ALTER_MAPPING__HELP = "(Experimental) Alter properties for an existing jdbc mapping.";
    static final String ALTER_MAPPING__REGION_NAME = "region";
    static final String ALTER_MAPPING__REGION_NAME__HELP = "Name of the region the mapping to be altered.";
    static final String ALTER_MAPPING__PDX_CLASS_NAME = "pdx-class-name";
    static final String ALTER_MAPPING__PDX_CLASS_NAME__HELP = "Name of new pdx class for which values with be written to the database.";
    static final String ALTER_MAPPING__TABLE_NAME = "table";
    static final String ALTER_MAPPING__TABLE_NAME__HELP = "Name of new database table for values to be written to.";
    static final String ALTER_MAPPING__CONNECTION_NAME = "connection";
    static final String ALTER_MAPPING__CONNECTION_NAME__HELP = "Name of new JDBC connection to use.";
    static final String ALTER_MAPPING__PRIMARY_KEY_IN_VALUE = "primary-key-in-value";
    static final String ALTER_MAPPING__PRIMARY_KEY_IN_VALUE__HELP = "If false, the entry value does not contain the data used for the database table's primary key, instead the entry key will be used for the primary key column value.";
    static final String ALTER_MAPPING__FIELD_MAPPING = "field-mapping";
    static final String ALTER_MAPPING__FIELD_MAPPING__HELP = "New key value pairs of entry value fields to database columns.";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"alter jdbc-mapping"}, help="(Experimental) Alter properties for an existing jdbc mapping.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result alterMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region the mapping to be altered.") String regionName, @CliOption(key={"connection"}, help="Name of new JDBC connection to use.") String connectionName, @CliOption(key={"table"}, help="Name of new database table for values to be written to.", specifiedDefaultValue="") String table, @CliOption(key={"pdx-class-name"}, help="Name of new pdx class for which values with be written to the database.", specifiedDefaultValue="") String pdxClassName, @CliOption(key={"primary-key-in-value"}, help="If false, the entry value does not contain the data used for the database table's primary key, instead the entry key will be used for the primary key column value.", specifiedDefaultValue="true") Boolean keyInValue, @CliOption(key={"field-mapping"}, help="New key value pairs of entry value fields to database columns.", specifiedDefaultValue="") String[] fieldMappings) {
        Set targetMembers = this.getMembers(null, null);
        RegionMapping mapping = this.getArguments(regionName, connectionName, table, pdxClassName, keyInValue, fieldMappings);
        ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector = this.execute(new AlterMappingFunction(), mapping, targetMembers);
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        XmlEntity xmlEntity = this.fillTabularResultData(resultCollector, tabularResultData);
        tabularResultData.setHeader("(Experimental) ");
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResultData);
        this.updateClusterConfiguration((Result)result, xmlEntity);
        return result;
    }

    ResultCollector<CliFunctionResult, List<CliFunctionResult>> execute(AlterMappingFunction function, RegionMapping mapping, Set<DistributedMember> targetMembers) {
        return this.executeFunction((Function)function, mapping, targetMembers);
    }

    private RegionMapping getArguments(String regionName, String connectionName, String table, String pdxClassName, Boolean keyInValue, String[] fieldMappings) {
        RegionMappingBuilder builder = new RegionMappingBuilder().withRegionName(regionName).withConnectionConfigName(connectionName).withTableName(table).withPdxClassName(pdxClassName).withPrimaryKeyInValue(keyInValue).withFieldToColumnMappings(fieldMappings);
        return builder.build();
    }

    private XmlEntity fillTabularResultData(ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector, TabularResultData tabularResultData) {
        XmlEntity xmlEntity = null;
        for (CliFunctionResult oneResult : (List)resultCollector.getResult()) {
            if (oneResult.isSuccessful()) {
                xmlEntity = this.addSuccessToResults(tabularResultData, oneResult);
                continue;
            }
            this.addErrorToResults(tabularResultData, oneResult);
        }
        return xmlEntity;
    }

    private XmlEntity addSuccessToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)oneResult.getMessage());
        return oneResult.getXmlEntity();
    }

    private void addErrorToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)(ERROR_PREFIX + oneResult.getMessage()));
        tabularResultData.setStatus(Result.Status.ERROR);
    }

    private void updateClusterConfiguration(Result result, XmlEntity xmlEntity) {
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> ((InternalClusterConfigurationService)this.getConfigurationService()).addXmlEntity(xmlEntity, null));
        }
    }
}

