/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.Region;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.ColumnData;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.DataSourceManager;
import org.apache.geode.connectors.jdbc.internal.EntryColumnData;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.SqlStatementFactory;
import org.apache.geode.connectors.jdbc.internal.SqlToPdxInstanceCreator;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataManager;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.pdx.PdxInstance;

@Experimental
public class SqlHandler {
    private final JdbcConnectorService configService;
    private final DataSourceManager manager;
    private final TableMetaDataManager tableMetaDataManager;

    public SqlHandler(DataSourceManager manager, TableMetaDataManager tableMetaDataManager, JdbcConnectorService configService) {
        this.manager = manager;
        this.tableMetaDataManager = tableMetaDataManager;
        this.configService = configService;
    }

    public void close() {
        this.manager.close();
    }

    Connection getConnection(ConnectionConfiguration config) throws SQLException {
        return this.manager.getOrCreateDataSource(config).getConnection();
    }

    public <K, V> PdxInstance read(Region<K, V> region, K key) throws SQLException {
        PdxInstance result;
        if (key == null) {
            throw new IllegalArgumentException("Key for query cannot be null");
        }
        RegionMapping regionMapping = this.getMappingForRegion(region.getName());
        ConnectionConfiguration connectionConfig = this.getConnectionConfig(regionMapping.getConnectionConfigName());
        try (Connection connection = this.getConnection(connectionConfig);){
            TableMetaDataView tableMetaData = this.tableMetaDataManager.getTableMetaDataView(connection, regionMapping.getRegionToTableName());
            EntryColumnData entryColumnData = this.getEntryColumnData(tableMetaData, regionMapping, key, null, Operation.GET);
            try (PreparedStatement statement = this.getPreparedStatement(connection, tableMetaData, entryColumnData, Operation.GET);
                 ResultSet resultSet = this.executeReadQuery(statement, entryColumnData);){
                InternalCache cache = (InternalCache)region.getRegionService();
                SqlToPdxInstanceCreator sqlToPdxInstanceCreator = new SqlToPdxInstanceCreator(cache, regionMapping, resultSet, tableMetaData);
                result = sqlToPdxInstanceCreator.create();
            }
        }
        return result;
    }

    private ResultSet executeReadQuery(PreparedStatement statement, EntryColumnData entryColumnData) throws SQLException {
        this.setValuesInStatement(statement, entryColumnData);
        return statement.executeQuery();
    }

    private RegionMapping getMappingForRegion(String regionName) {
        RegionMapping regionMapping = this.configService.getMappingForRegion(regionName);
        if (regionMapping == null) {
            throw new JdbcConnectorException("JDBC mapping for region " + regionName + " not found. Create the mapping with the gfsh command 'create jdbc-mapping'.");
        }
        return regionMapping;
    }

    private ConnectionConfiguration getConnectionConfig(String connectionConfigName) {
        ConnectionConfiguration connectionConfig = this.configService.getConnectionConfig(connectionConfigName);
        if (connectionConfig == null) {
            throw new JdbcConnectorException("JDBC connection with name " + connectionConfigName + " not found. Create the connection with the gfsh command 'create jdbc-connection'");
        }
        return connectionConfig;
    }

    private void setValuesInStatement(PreparedStatement statement, EntryColumnData entryColumnData) throws SQLException {
        int index = 0;
        for (ColumnData columnData : entryColumnData.getEntryValueColumnData()) {
            this.setValueOnStatement(statement, ++index, columnData);
        }
        ColumnData keyColumnData = entryColumnData.getEntryKeyColumnData();
        this.setValueOnStatement(statement, ++index, keyColumnData);
    }

    private void setValueOnStatement(PreparedStatement statement, int index, ColumnData columnData) throws SQLException {
        Object value = columnData.getValue();
        if (value instanceof Character) {
            Character character = (Character)value;
            value = character == Character.valueOf('\u0000') ? null : character.toString();
        } else if (value instanceof java.util.Date) {
            java.util.Date jdkDate = (java.util.Date)value;
            switch (columnData.getDataType()) {
                case 91: {
                    value = new Date(jdkDate.getTime());
                    break;
                }
                case 92: 
                case 2013: {
                    value = new Time(jdkDate.getTime());
                    break;
                }
                case 93: 
                case 2014: {
                    value = new Timestamp(jdkDate.getTime());
                    break;
                }
            }
        }
        if (value == null) {
            statement.setNull(index, columnData.getDataType());
        } else {
            statement.setObject(index, value);
        }
    }

    public <K, V> void write(Region<K, V> region, Operation operation, K key, PdxInstance value) throws SQLException {
        if (value == null && operation != Operation.DESTROY) {
            throw new IllegalArgumentException("PdxInstance cannot be null for non-destroy operations");
        }
        RegionMapping regionMapping = this.getMappingForRegion(region.getName());
        ConnectionConfiguration connectionConfig = this.getConnectionConfig(regionMapping.getConnectionConfigName());
        try (Connection connection = this.getConnection(connectionConfig);){
            int updateCount;
            EntryColumnData entryColumnData;
            TableMetaDataView tableMetaData;
            block45: {
                tableMetaData = this.tableMetaDataManager.getTableMetaDataView(connection, regionMapping.getRegionToTableName());
                entryColumnData = this.getEntryColumnData(tableMetaData, regionMapping, key, value, operation);
                updateCount = 0;
                try (PreparedStatement statement = this.getPreparedStatement(connection, tableMetaData, entryColumnData, operation);){
                    updateCount = this.executeWriteStatement(statement, entryColumnData);
                }
                catch (SQLException e) {
                    if (!operation.isDestroy()) break block45;
                    throw e;
                }
            }
            if (operation.isDestroy()) {
                return;
            }
            if (updateCount <= 0) {
                Operation upsertOp = this.getOppositeOperation(operation);
                try (PreparedStatement upsertStatement = this.getPreparedStatement(connection, tableMetaData, entryColumnData, upsertOp);){
                    updateCount = this.executeWriteStatement(upsertStatement, entryColumnData);
                }
            }
            assert (updateCount == 1);
        }
    }

    private Operation getOppositeOperation(Operation operation) {
        return operation.isUpdate() ? Operation.CREATE : Operation.UPDATE;
    }

    private int executeWriteStatement(PreparedStatement statement, EntryColumnData entryColumnData) throws SQLException {
        this.setValuesInStatement(statement, entryColumnData);
        return statement.executeUpdate();
    }

    private PreparedStatement getPreparedStatement(Connection connection, TableMetaDataView tableMetaData, EntryColumnData entryColumnData, Operation operation) throws SQLException {
        String sqlStr = this.getSqlString(tableMetaData, entryColumnData, operation);
        return connection.prepareStatement(sqlStr);
    }

    private String getSqlString(TableMetaDataView tableMetaData, EntryColumnData entryColumnData, Operation operation) {
        SqlStatementFactory statementFactory = new SqlStatementFactory(tableMetaData.getIdentifierQuoteString());
        String tableName = tableMetaData.getTableName();
        if (operation.isCreate()) {
            return statementFactory.createInsertSqlString(tableName, entryColumnData);
        }
        if (operation.isUpdate()) {
            return statementFactory.createUpdateSqlString(tableName, entryColumnData);
        }
        if (operation.isDestroy()) {
            return statementFactory.createDestroySqlString(tableName, entryColumnData);
        }
        if (operation.isGet()) {
            return statementFactory.createSelectQueryString(tableName, entryColumnData);
        }
        throw new InternalGemFireException("unsupported operation " + operation);
    }

    <K> EntryColumnData getEntryColumnData(TableMetaDataView tableMetaData, RegionMapping regionMapping, K key, PdxInstance value, Operation operation) {
        String keyColumnName = tableMetaData.getKeyColumnName();
        ColumnData keyColumnData = new ColumnData(keyColumnName, key, tableMetaData.getColumnDataType(keyColumnName));
        List<ColumnData> valueColumnData = null;
        if (operation.isCreate() || operation.isUpdate()) {
            valueColumnData = this.createColumnDataList(tableMetaData, regionMapping, value);
        }
        return new EntryColumnData(keyColumnData, valueColumnData);
    }

    private List<ColumnData> createColumnDataList(TableMetaDataView tableMetaData, RegionMapping regionMapping, PdxInstance value) {
        ArrayList<ColumnData> result = new ArrayList<ColumnData>();
        for (String fieldName : value.getFieldNames()) {
            String columnName = regionMapping.getColumnNameForField(fieldName, tableMetaData);
            if (tableMetaData.getKeyColumnName().equals(columnName)) continue;
            ColumnData columnData = new ColumnData(columnName, value.getField(fieldName), tableMetaData.getColumnDataType(columnName));
            result.add(columnData);
        }
        return result;
    }
}

