/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.connectors.jdbc.internal.TableMetaDataView;
import org.apache.geode.pdx.internal.PdxType;
import org.apache.geode.pdx.internal.TypeRegistry;

@Experimental
public class RegionMapping
implements Serializable {
    private final String regionName;
    private final String pdxClassName;
    private final String tableName;
    private final String connectionConfigName;
    private final Boolean primaryKeyInValue;
    private final ConcurrentMap<String, String> fieldToColumnMap;
    private final ConcurrentMap<String, String> columnToFieldMap;
    private final Map<String, String> configuredFieldToColumnMap;
    private final Map<String, String> configuredColumnToFieldMap;

    public RegionMapping(String regionName, String pdxClassName, String tableName, String connectionConfigName, Boolean primaryKeyInValue, Map<String, String> configuredFieldToColumnMap) {
        this.regionName = regionName;
        this.pdxClassName = pdxClassName;
        this.tableName = tableName;
        this.connectionConfigName = connectionConfigName;
        this.primaryKeyInValue = primaryKeyInValue;
        this.fieldToColumnMap = new ConcurrentHashMap<String, String>();
        this.columnToFieldMap = new ConcurrentHashMap<String, String>();
        if (configuredFieldToColumnMap != null) {
            this.configuredFieldToColumnMap = Collections.unmodifiableMap(new HashMap<String, String>(configuredFieldToColumnMap));
            this.configuredColumnToFieldMap = Collections.unmodifiableMap(RegionMapping.createReverseMap(configuredFieldToColumnMap));
        } else {
            this.configuredFieldToColumnMap = null;
            this.configuredColumnToFieldMap = null;
        }
    }

    private static Map<String, String> createReverseMap(Map<String, String> input) {
        HashMap<String, String> output = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            String reverseMapKey = entry.getValue();
            String reverseMapValue = entry.getKey();
            if (output.containsKey(reverseMapKey)) {
                throw new IllegalArgumentException("The field " + reverseMapValue + " can not be mapped to more than one column.");
            }
            output.put(reverseMapKey, reverseMapValue);
        }
        return output;
    }

    public String getConnectionConfigName() {
        return this.connectionConfigName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getPdxClassName() {
        return this.pdxClassName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Boolean isPrimaryKeyInValue() {
        return this.primaryKeyInValue;
    }

    public String getRegionToTableName() {
        if (this.tableName == null) {
            return this.regionName;
        }
        return this.tableName;
    }

    private String getConfiguredColumnNameForField(String fieldName) {
        String mapResult;
        String result = fieldName;
        if (this.configuredFieldToColumnMap != null && (mapResult = this.configuredFieldToColumnMap.get(fieldName)) != null) {
            result = mapResult;
        }
        return result;
    }

    public String getColumnNameForField(String fieldName, TableMetaDataView tableMetaDataView) {
        String columnName = (String)this.fieldToColumnMap.get(fieldName);
        if (columnName == null) {
            String configuredColumnName = this.getConfiguredColumnNameForField(fieldName);
            Set<String> columnNames = tableMetaDataView.getColumnNames();
            if (columnNames.contains(configuredColumnName)) {
                columnName = configuredColumnName;
            } else {
                for (String candidate : columnNames) {
                    if (!candidate.equalsIgnoreCase(configuredColumnName)) continue;
                    if (columnName != null) {
                        throw new JdbcConnectorException("The SQL table has at least two columns that match the PDX field: " + fieldName);
                    }
                    columnName = candidate;
                }
            }
            if (columnName == null) {
                columnName = configuredColumnName;
            }
            this.fieldToColumnMap.put(fieldName, columnName);
            this.columnToFieldMap.put(columnName, fieldName);
        }
        return columnName;
    }

    private String getConfiguredFieldNameForColumn(String columnName) {
        String mapResult;
        String result = columnName;
        if (this.configuredColumnToFieldMap != null && (mapResult = this.configuredColumnToFieldMap.get(columnName)) != null) {
            result = mapResult;
        }
        return result;
    }

    public String getFieldNameForColumn(String columnName, TypeRegistry typeRegistry) {
        String fieldName = (String)this.columnToFieldMap.get(columnName);
        if (fieldName == null) {
            String configuredFieldName = this.getConfiguredFieldNameForColumn(columnName);
            if (this.getPdxClassName() == null) {
                fieldName = configuredFieldName.equals(configuredFieldName.toUpperCase()) ? configuredFieldName.toLowerCase() : configuredFieldName;
            } else {
                Set<PdxType> pdxTypes = this.getPdxTypesForClassName(typeRegistry);
                fieldName = this.findExactMatch(configuredFieldName, pdxTypes);
                if (fieldName == null) {
                    fieldName = this.findCaseInsensitiveMatch(columnName, configuredFieldName, pdxTypes);
                }
            }
            assert (fieldName != null);
            this.fieldToColumnMap.put(fieldName, columnName);
            this.columnToFieldMap.put(columnName, fieldName);
        }
        return fieldName;
    }

    private Set<PdxType> getPdxTypesForClassName(TypeRegistry typeRegistry) {
        Set pdxTypes = typeRegistry.getPdxTypesForClassName(this.getPdxClassName());
        if (pdxTypes.isEmpty()) {
            throw new JdbcConnectorException("The class " + this.getPdxClassName() + " has not been pdx serialized.");
        }
        return pdxTypes;
    }

    private String findCaseInsensitiveMatch(String columnName, String configuredFieldName, Set<PdxType> pdxTypes) {
        HashSet<String> matchingFieldNames = new HashSet<String>();
        for (PdxType pdxType : pdxTypes) {
            for (String existingFieldName : pdxType.getFieldNames()) {
                if (!existingFieldName.equalsIgnoreCase(configuredFieldName)) continue;
                matchingFieldNames.add(existingFieldName);
            }
        }
        if (matchingFieldNames.isEmpty()) {
            throw new JdbcConnectorException("The class " + this.getPdxClassName() + " does not have a field that matches the column " + columnName);
        }
        if (matchingFieldNames.size() > 1) {
            throw new JdbcConnectorException("Could not determine what pdx field to use for the column name " + columnName + " because the pdx fields " + matchingFieldNames + " all match it.");
        }
        return (String)matchingFieldNames.iterator().next();
    }

    private String findExactMatch(String columnName, Set<PdxType> pdxTypes) {
        for (PdxType pdxType : pdxTypes) {
            if (pdxType.getPdxField(columnName) == null) continue;
            return columnName;
        }
        return null;
    }

    public Map<String, String> getFieldToColumnMap() {
        return this.configuredFieldToColumnMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionMapping that = (RegionMapping)o;
        if (this.primaryKeyInValue != that.primaryKeyInValue) {
            return false;
        }
        if (this.regionName != null ? !this.regionName.equals(that.regionName) : that.regionName != null) {
            return false;
        }
        if (this.pdxClassName != null ? !this.pdxClassName.equals(that.pdxClassName) : that.pdxClassName != null) {
            return false;
        }
        if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) {
            return false;
        }
        if (this.connectionConfigName != null ? !this.connectionConfigName.equals(that.connectionConfigName) : that.connectionConfigName != null) {
            return false;
        }
        return this.configuredFieldToColumnMap != null ? this.configuredFieldToColumnMap.equals(that.configuredFieldToColumnMap) : that.configuredFieldToColumnMap == null;
    }

    public int hashCode() {
        int result = this.regionName != null ? this.regionName.hashCode() : 0;
        result = 31 * result + (this.pdxClassName != null ? this.pdxClassName.hashCode() : 0);
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (this.connectionConfigName != null ? this.connectionConfigName.hashCode() : 0);
        result = 31 * result + (this.primaryKeyInValue != false ? 1 : 0);
        result = 31 * result + (this.configuredFieldToColumnMap != null ? this.configuredFieldToColumnMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RegionMapping{regionName='" + this.regionName + '\'' + ", pdxClassName='" + this.pdxClassName + '\'' + ", tableName='" + this.tableName + '\'' + ", connectionConfigName='" + this.connectionConfigName + '\'' + ", primaryKeyInValue=" + this.primaryKeyInValue + ", fieldToColumnMap=" + this.configuredFieldToColumnMap + '}';
    }
}

