/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigExistsException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigNotFoundException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.DataSourceManager;
import org.apache.geode.connectors.jdbc.internal.HikariJdbcDataSourceFactory;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingExistsException;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.xml.JdbcConnectorServiceXmlGenerator;
import org.apache.geode.internal.cache.CacheService;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.extension.Extensible;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.XmlGenerator;
import org.apache.geode.management.internal.beans.CacheServiceMBeanBase;

@Experimental
public class JdbcConnectorServiceImpl
implements JdbcConnectorService {
    private final Map<String, ConnectionConfiguration> connectionsByName = new ConcurrentHashMap<String, ConnectionConfiguration>();
    private final Map<String, RegionMapping> mappingsByRegion = new ConcurrentHashMap<String, RegionMapping>();
    private final DataSourceManager manager = new DataSourceManager(new HikariJdbcDataSourceFactory());
    private volatile InternalCache cache;
    private boolean registered;

    @Override
    public void createConnectionConfig(ConnectionConfiguration config) throws ConnectionConfigExistsException {
        this.registerAsExtension();
        ConnectionConfiguration existing = this.connectionsByName.putIfAbsent(config.getName(), config);
        if (existing != null) {
            throw new ConnectionConfigExistsException("ConnectionConfiguration " + config.getName() + " exists");
        }
    }

    @Override
    public void replaceConnectionConfig(ConnectionConfiguration alteredConfig) throws ConnectionConfigNotFoundException {
        this.registerAsExtension();
        ConnectionConfiguration existingConfig = this.connectionsByName.get(alteredConfig.getName());
        if (existingConfig == null) {
            throw new ConnectionConfigNotFoundException("ConnectionConfiguration " + alteredConfig.getName() + " was not found");
        }
        this.connectionsByName.put(existingConfig.getName(), alteredConfig);
    }

    @Override
    public void destroyConnectionConfig(String connectionName) {
        this.registerAsExtension();
        this.connectionsByName.remove(connectionName);
    }

    @Override
    public ConnectionConfiguration getConnectionConfig(String connectionName) {
        return this.connectionsByName.get(connectionName);
    }

    @Override
    public Set<ConnectionConfiguration> getConnectionConfigs() {
        HashSet<ConnectionConfiguration> connectionConfigs = new HashSet<ConnectionConfiguration>();
        connectionConfigs.addAll(this.connectionsByName.values());
        return connectionConfigs;
    }

    @Override
    public Set<RegionMapping> getRegionMappings() {
        HashSet<RegionMapping> regionMappings = new HashSet<RegionMapping>();
        regionMappings.addAll(this.mappingsByRegion.values());
        return regionMappings;
    }

    @Override
    public DataSourceManager getDataSourceManager() {
        return this.manager;
    }

    @Override
    public void createRegionMapping(RegionMapping mapping) throws RegionMappingExistsException {
        this.registerAsExtension();
        RegionMapping existing = this.mappingsByRegion.putIfAbsent(mapping.getRegionName(), mapping);
        if (existing != null) {
            throw new RegionMappingExistsException("RegionMapping for region " + mapping.getRegionName() + " exists");
        }
    }

    @Override
    public void replaceRegionMapping(RegionMapping alteredMapping) throws RegionMappingNotFoundException {
        this.registerAsExtension();
        RegionMapping existingMapping = this.mappingsByRegion.get(alteredMapping.getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("RegionMapping for region " + existingMapping.getRegionName() + " was not found");
        }
        this.mappingsByRegion.put(existingMapping.getRegionName(), alteredMapping);
    }

    @Override
    public RegionMapping getMappingForRegion(String regionName) {
        return this.mappingsByRegion.get(regionName);
    }

    @Override
    public void destroyRegionMapping(String regionName) {
        this.registerAsExtension();
        this.mappingsByRegion.remove(regionName);
    }

    public void init(Cache cache) {
        this.cache = (InternalCache)cache;
    }

    private synchronized void registerAsExtension() {
        if (!this.registered) {
            this.cache.getExtensionPoint().addExtension((Extension)this);
            this.registered = true;
        }
    }

    public Class<? extends CacheService> getInterface() {
        return JdbcConnectorService.class;
    }

    public CacheServiceMBeanBase getMBean() {
        return null;
    }

    public XmlGenerator<Cache> getXmlGenerator() {
        return new JdbcConnectorServiceXmlGenerator(this.connectionsByName.values(), this.mappingsByRegion.values());
    }

    public void beforeCreate(Extensible<Cache> source, Cache cache) {
    }

    public void onCreate(Extensible<Cache> source, Extensible<Cache> target) {
    }
}

