/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;

@Experimental
public class ConnectionConfigBuilder {
    private String name;
    private String url;
    private String user;
    private String password;
    private Map<String, String> parameters;

    public ConnectionConfigBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ConnectionConfigBuilder withUrl(String url) {
        this.url = url;
        return this;
    }

    public ConnectionConfigBuilder withUser(String user) {
        this.user = user;
        return this;
    }

    public ConnectionConfigBuilder withPassword(String password) {
        this.password = password;
        return this;
    }

    public ConnectionConfigBuilder withParameters(String[] params) {
        if (params != null) {
            this.parameters = new HashMap<String, String>();
            for (String param : params) {
                if (param.isEmpty()) continue;
                String[] keyValuePair = param.split(":");
                this.validateParam(keyValuePair, param);
                this.parameters.put(keyValuePair[0], keyValuePair[1]);
            }
        } else {
            this.parameters = null;
        }
        return this;
    }

    private void validateParam(String[] paramKeyValue, String param) {
        if (paramKeyValue.length != 2 || paramKeyValue[0].isEmpty()) {
            throw new IllegalArgumentException("Parameter '" + param + "' is not of the form 'parameterName" + ":" + "value'");
        }
    }

    public ConnectionConfiguration build() {
        return new ConnectionConfiguration(this.name, this.url, this.user, this.password, this.parameters);
    }
}

