/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.cli.functions;

import java.util.HashSet;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.geode.cache.lucene.internal.LuceneIndexCreationProfile;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.cli.LuceneIndexDetails;
import org.apache.geode.internal.cache.execute.InternalFunction;

public class LuceneListIndexFunction
implements InternalFunction {
    private static final long serialVersionUID = -2320432506763893879L;

    public String getId() {
        return LuceneListIndexFunction.class.getName();
    }

    public void execute(FunctionContext context) {
        HashSet<LuceneIndexDetails> indexDetailsSet = new HashSet<LuceneIndexDetails>();
        Cache cache = context.getCache();
        String serverName = cache.getDistributedSystem().getDistributedMember().getName();
        LuceneServiceImpl service = (LuceneServiceImpl)LuceneServiceProvider.get((GemFireCache)cache);
        for (LuceneIndex index : service.getAllIndexes()) {
            indexDetailsSet.add(new LuceneIndexDetails((LuceneIndexImpl)index, serverName));
        }
        for (LuceneIndexCreationProfile profile : service.getAllDefinedIndexes()) {
            indexDetailsSet.add(new LuceneIndexDetails(profile, serverName));
        }
        context.getResultSender().lastResult(indexDetailsSet);
    }
}

