/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.LuceneServiceImpl;
import org.apache.geode.cache.lucene.internal.repository.serializer.HeterogeneousLuceneSerializer;
import org.apache.geode.internal.Version;
import org.apache.geode.internal.VersionedDataSerializable;
import org.apache.geode.internal.cache.CacheServiceProfile;
import org.apache.geode.internal.i18n.LocalizedStrings;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneIndexCreationProfile
implements CacheServiceProfile,
VersionedDataSerializable {
    private String indexName;
    private String[] fieldNames;
    private String analyzerClass;
    private Map<String, String> fieldAnalyzers;
    private String serializerClass = HeterogeneousLuceneSerializer.class.getSimpleName();
    private String regionPath;

    public LuceneIndexCreationProfile() {
    }

    public LuceneIndexCreationProfile(String indexName, String regionPath, String[] fieldNames, Analyzer analyzer, Map<String, Analyzer> fieldAnalyzers, LuceneSerializer serializer) {
        this.indexName = indexName;
        this.regionPath = regionPath;
        this.fieldNames = fieldNames;
        this.analyzerClass = analyzer.getClass().getSimpleName();
        this.initializeFieldAnalyzers(fieldAnalyzers);
        if (serializer != null) {
            this.serializerClass = serializer.getClass().getSimpleName();
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String getAnalyzerClass() {
        return this.analyzerClass;
    }

    public Map<String, String> getFieldAnalyzers() {
        return this.fieldAnalyzers;
    }

    public String getSerializerClass() {
        return this.serializerClass;
    }

    protected void initializeFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = new HashMap<String, String>();
        for (String field : this.fieldNames) {
            if (fieldAnalyzers != null && !fieldAnalyzers.isEmpty()) {
                this.fieldAnalyzers.put(field, fieldAnalyzers.get(field) == null ? StandardAnalyzer.class.getSimpleName() : fieldAnalyzers.get(field).getClass().getSimpleName());
                continue;
            }
            this.fieldAnalyzers.put(field, StandardAnalyzer.class.getSimpleName());
        }
    }

    public String getId() {
        return "lucene_" + LuceneServiceImpl.getUniqueIndexName(this.indexName, this.regionPath);
    }

    public String checkCompatibility(String regionPath, CacheServiceProfile profile) {
        String result = null;
        LuceneIndexCreationProfile remoteProfile = (LuceneIndexCreationProfile)profile;
        if (this.getFieldNames().length != remoteProfile.getFieldNames().length || !Arrays.asList(this.getFieldNames()).containsAll(Arrays.asList(remoteProfile.getFieldNames()))) {
            return LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_FIELDS_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_FIELDS_3.toString(new Object[]{this.getIndexName(), regionPath, Arrays.toString(this.getFieldNames()), Arrays.toString(remoteProfile.getFieldNames())});
        }
        if (!this.getFieldAnalyzers().equals(remoteProfile.getFieldAnalyzers())) {
            if (this.getFieldAnalyzers().size() != remoteProfile.getFieldAnalyzers().size()) {
                return LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_FIELD_ANALYZERS_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_FIELD_ANALYZERS_3.toString(new Object[]{this.getIndexName(), regionPath, Arrays.toString(this.getFieldAnalyzers().values().toArray()), Arrays.toString(remoteProfile.getFieldAnalyzers().values().toArray())});
            }
            for (String field : this.getFieldAnalyzers().keySet()) {
                if (remoteProfile.getFieldAnalyzers().get(field).equals(this.getFieldAnalyzers().get(field))) continue;
                return LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_ANALYZER_2_ON_FIELD_3_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_ANALYZER_4_ON_THAT_FIELD.toString(new Object[]{this.getIndexName(), regionPath, this.getFieldAnalyzers().get(field), field, remoteProfile.getFieldAnalyzers().get(field)});
            }
        }
        if (!this.getSerializerClass().equals(remoteProfile.getSerializerClass())) {
            return LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_WITH_SERIALIZER_2_BECAUSE_ANOTHER_MEMBER_DEFINES_THE_SAME_INDEX_WITH_DIFFERENT_SERIALIZER_3.toString(new Object[]{this.getIndexName(), regionPath, this.getSerializerClass(), remoteProfile.getSerializerClass()});
        }
        return result;
    }

    public String getMissingProfileMessage(boolean existsInThisMember) {
        return existsInThisMember ? LocalizedStrings.LuceneService_CANNOT_CREATE_INDEX_0_ON_REGION_1_BECAUSE_IT_IS_NOT_DEFINED_IN_ANOTHER_MEMBER.toString(new Object[]{this.getIndexName(), this.regionPath}) : LocalizedStrings.LuceneService_MUST_DEFINE_INDEX_0_ON_REGION_1_BECAUSE_IT_IS_DEFINED_IN_ANOTHER_MEMBER.toString(new Object[]{this.getIndexName(), this.regionPath});
    }

    public void toData(DataOutput out) throws IOException {
        this.toDataPre_GEODE_1_4_0_0(out);
        DataSerializer.writeString((String)this.serializerClass, (DataOutput)out);
    }

    public void toDataPre_GEODE_1_4_0_0(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
        DataSerializer.writeString((String)this.regionPath, (DataOutput)out);
        DataSerializer.writeStringArray((String[])this.fieldNames, (DataOutput)out);
        DataSerializer.writeString((String)this.analyzerClass, (DataOutput)out);
        DataSerializer.writeHashMap(this.fieldAnalyzers, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataPre_GEODE_1_4_0_0(in);
        this.serializerClass = DataSerializer.readString((DataInput)in);
    }

    public void fromDataPre_GEODE_1_4_0_0(DataInput in) throws IOException, ClassNotFoundException {
        this.indexName = DataSerializer.readString((DataInput)in);
        this.regionPath = DataSerializer.readString((DataInput)in);
        this.fieldNames = DataSerializer.readStringArray((DataInput)in);
        this.analyzerClass = DataSerializer.readString((DataInput)in);
        this.fieldAnalyzers = DataSerializer.readHashMap((DataInput)in);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "indexName=" + this.indexName + "; regionPath=" + this.regionPath + "; fieldNames=" + Arrays.toString(this.fieldNames) + "; analyzerClass=" + this.analyzerClass + "; fieldAnalyzers=" + this.fieldAnalyzers + "; serializer=" + this.serializerClass + "]";
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public Version[] getSerializationVersions() {
        return new Version[]{Version.GEODE_140};
    }
}

