/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionAuthenticatingStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.ProtobufConnectionStateProcessor;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.OperationNotAuthorizedException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.NotAuthorizedException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadState;

public class ProtobufConnectionAuthorizingStateProcessor
implements ProtobufConnectionStateProcessor {
    private final SecurityService securityService;
    private final Subject subject;

    public ProtobufConnectionAuthorizingStateProcessor(SecurityService securityService, Subject subject) {
        this.securityService = securityService;
        this.subject = subject;
    }

    @Override
    public void validateOperation(Object message, ProtobufSerializationService serializer, MessageExecutionContext messageContext, ProtobufOperationContext operationContext) throws ConnectionStateException, DecodingException {
        ThreadState threadState = this.securityService.bindSubject(this.subject);
        try {
            this.securityService.authorize(operationContext.getAccessPermissionRequired(operationContext.getFromRequest().apply((ClientProtocol.Message)message), serializer));
        }
        catch (NotAuthorizedException e) {
            messageContext.getStatistics().incAuthorizationViolations();
            throw new OperationNotAuthorizedException("The user is not authorized to complete this operation");
        }
        finally {
            threadState.restore();
        }
    }

    @Override
    public ProtobufConnectionAuthenticatingStateProcessor allowAuthentication() throws ConnectionStateException {
        throw new ConnectionStateException(BasicTypes.ErrorCode.ALREADY_AUTHENTICATED, "The user has already been authenticated for this connection. Re-authentication is not supported at this time.");
    }

    public ThreadState prepareThreadForAuthorization() {
        return this.securityService.bindSubject(this.subject);
    }

    public void restoreThreadState(ThreadState state) {
        state.restore();
    }
}

