/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.protocol.protobuf.v1.ClientProtocol;
import org.apache.geode.internal.protocol.protobuf.v1.ConnectionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.FunctionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.LocatorAPI;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.operations.DisconnectClientRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnGroupRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnMemberRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ExecuteFunctionOnRegionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRegionNamesRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRegionRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.GetServerOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.KeySetOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.OqlQueryRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutAllRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.PutRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.RemoveRequestOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.operations.security.AuthenticationRequestOperationHandler;
import org.apache.geode.management.internal.security.ResourcePermissions;
import org.apache.geode.security.ResourcePermission;

@Experimental
public class ProtobufOperationContextRegistry {
    private Map<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext> operationContexts = new ConcurrentHashMap<ClientProtocol.Message.MessageTypeCase, ProtobufOperationContext>();
    private final ResourcePermission noneRequired = new ResourcePermission(ResourcePermission.NULL, ResourcePermission.NULL);

    public ProtobufOperationContextRegistry() {
        this.addContexts();
    }

    public ProtobufOperationContext getOperationContext(ClientProtocol.Message.MessageTypeCase apiCase) {
        return this.operationContexts.get(apiCase);
    }

    private ResourcePermission skipAuthorizationCheck(Object unused, ProtobufSerializationService unused2) {
        return this.noneRequired;
    }

    private void addContexts() {
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.AUTHENTICATIONREQUEST, new ProtobufOperationContext<ConnectionAPI.AuthenticationRequest, ConnectionAPI.AuthenticationResponse>(ClientProtocol.Message::getAuthenticationRequest, new AuthenticationRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setAuthenticationResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.DISCONNECTCLIENTREQUEST, new ProtobufOperationContext<ConnectionAPI.DisconnectClientRequest, ConnectionAPI.DisconnectClientResponse>(ClientProtocol.Message::getDisconnectClientRequest, new DisconnectClientRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setDisconnectClientResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETREQUEST, new ProtobufOperationContext<RegionAPI.GetRequest, RegionAPI.GetResponse>(ClientProtocol.Message::getGetRequest, new GetRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetResponse(opsResp), GetRequestOperationHandler::determineRequiredPermission));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETALLREQUEST, new ProtobufOperationContext<RegionAPI.GetAllRequest, RegionAPI.GetAllResponse>(ClientProtocol.Message::getGetAllRequest, new GetAllRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetAllResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.PUTREQUEST, new ProtobufOperationContext<RegionAPI.PutRequest, RegionAPI.PutResponse>(ClientProtocol.Message::getPutRequest, new PutRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setPutResponse(opsResp), PutRequestOperationHandler::determineRequiredPermission));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.PUTALLREQUEST, new ProtobufOperationContext<RegionAPI.PutAllRequest, RegionAPI.PutAllResponse>(ClientProtocol.Message::getPutAllRequest, new PutAllRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setPutAllResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.REMOVEREQUEST, new ProtobufOperationContext<RegionAPI.RemoveRequest, RegionAPI.RemoveResponse>(ClientProtocol.Message::getRemoveRequest, new RemoveRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setRemoveResponse(opsResp), RemoveRequestOperationHandler::determineRequiredPermission));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETREGIONNAMESREQUEST, new ProtobufOperationContext<RegionAPI.GetRegionNamesRequest, RegionAPI.GetRegionNamesResponse>(ClientProtocol.Message::getGetRegionNamesRequest, new GetRegionNamesRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetRegionNamesResponse(opsResp), ResourcePermissions.DATA_READ));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETREGIONREQUEST, new ProtobufOperationContext<RegionAPI.GetRegionRequest, RegionAPI.GetRegionResponse>(ClientProtocol.Message::getGetRegionRequest, new GetRegionRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetRegionResponse(opsResp), ResourcePermissions.DATA_READ));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.GETSERVERREQUEST, new ProtobufOperationContext<LocatorAPI.GetServerRequest, LocatorAPI.GetServerResponse>(ClientProtocol.Message::getGetServerRequest, new GetServerOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setGetServerResponse(opsResp), ResourcePermissions.CLUSTER_READ));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONREGIONREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnRegionRequest, FunctionAPI.ExecuteFunctionOnRegionResponse>(ClientProtocol.Message::getExecuteFunctionOnRegionRequest, new ExecuteFunctionOnRegionRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnRegionResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONMEMBERREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnMemberRequest, FunctionAPI.ExecuteFunctionOnMemberResponse>(ClientProtocol.Message::getExecuteFunctionOnMemberRequest, new ExecuteFunctionOnMemberRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnMemberResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.EXECUTEFUNCTIONONGROUPREQUEST, new ProtobufOperationContext<FunctionAPI.ExecuteFunctionOnGroupRequest, FunctionAPI.ExecuteFunctionOnGroupResponse>(ClientProtocol.Message::getExecuteFunctionOnGroupRequest, new ExecuteFunctionOnGroupRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setExecuteFunctionOnGroupResponse(opsResp), this::skipAuthorizationCheck));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.OQLQUERYREQUEST, new ProtobufOperationContext<RegionAPI.OQLQueryRequest, RegionAPI.OQLQueryResponse>(ClientProtocol.Message::getOqlQueryRequest, new OqlQueryRequestOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setOqlQueryResponse(opsResp), new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ)));
        this.operationContexts.put(ClientProtocol.Message.MessageTypeCase.KEYSETREQUEST, new ProtobufOperationContext<RegionAPI.KeySetRequest, RegionAPI.KeySetResponse>(ClientProtocol.Message::getKeySetRequest, new KeySetOperationHandler(), opsResp -> ClientProtocol.Message.newBuilder().setKeySetResponse(opsResp), KeySetOperationHandler::determineRequiredPermission));
    }
}

