/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;

@Experimental
public class GetRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetRequest, RegionAPI.GetResponse> {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<RegionAPI.GetResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, EncodingException, DecodingException {
        String regionName = request.getRegionName();
        Region region = messageExecutionContext.getCache().getRegion(regionName);
        if (region == null) {
            logger.error("Received get request for nonexistent region: {}", (Object)regionName);
            return Failure.of(BasicTypes.ErrorCode.SERVER_ERROR, "Region \"" + regionName + "\" not found");
        }
        try {
            messageExecutionContext.getCache().setReadSerializedForCurrentThread(true);
            Object decodedKey = serializationService.decode(request.getKey());
            if (decodedKey == null) {
                Failure<RegionAPI.GetResponse> failure = Failure.of(BasicTypes.ErrorCode.INVALID_REQUEST, "Performing a get on a NULL key.");
                return failure;
            }
            Object resultValue = region.get(decodedKey);
            if (resultValue == null) {
                Success<RegionAPI.GetResponse> success = Success.of(RegionAPI.GetResponse.newBuilder().build());
                return success;
            }
            BasicTypes.EncodedValue encodedValue = serializationService.encode(resultValue);
            Success<RegionAPI.GetResponse> success = Success.of(RegionAPI.GetResponse.newBuilder().setResult(encodedValue).build());
            return success;
        }
        finally {
            messageExecutionContext.getCache().setReadSerializedForCurrentThread(false);
        }
    }

    public static ResourcePermission determineRequiredPermission(RegionAPI.GetRequest request, ProtobufSerializationService serializer) throws DecodingException {
        return new ResourcePermission(ResourcePermission.Resource.DATA, ResourcePermission.Operation.READ, request.getRegionName(), serializer.decode(request.getKey()).toString());
    }
}

