/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.repository.serializer;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.PdxLuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.PrimitiveSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.ReflectionLuceneSerializer;
import org.apache.geode.cache.lucene.internal.repository.serializer.SerializerUtil;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.internal.util.concurrent.CopyOnWriteWeakHashMap;
import org.apache.geode.pdx.PdxInstance;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;

public class HeterogeneousLuceneSerializer
implements LuceneSerializer {
    private LuceneSerializer pdxMapper;
    private Map<Class<?>, LuceneSerializer> mappers = new CopyOnWriteWeakHashMap();
    private static final Logger logger = LogService.getLogger();

    public HeterogeneousLuceneSerializer() {
        PrimitiveSerializer primitiveSerializer = new PrimitiveSerializer();
        SerializerUtil.supportedPrimitiveTypes().stream().forEach(type -> this.mappers.put((Class<?>)type, primitiveSerializer));
        this.pdxMapper = new PdxLuceneSerializer();
    }

    public Collection<Document> toDocuments(LuceneIndex index, Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        LuceneSerializer mapper = this.getFieldMapper(value, index.getFieldNames());
        Collection<Document> docs = mapper.toDocuments(index, value);
        if (logger.isDebugEnabled()) {
            logger.debug("HeterogeneousLuceneSerializer.toDocuments:" + docs);
        }
        return docs;
    }

    private LuceneSerializer getFieldMapper(Object value, String[] indexedFields) {
        if (value instanceof PdxInstance) {
            return this.pdxMapper;
        }
        Class<?> clazz = value.getClass();
        LuceneSerializer mapper = this.mappers.get(clazz);
        if (mapper == null) {
            mapper = new ReflectionLuceneSerializer(clazz, indexedFields);
            this.mappers.put(clazz, mapper);
        }
        return mapper;
    }
}

