/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal;

import java.io.IOException;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.internal.AbstractPartitionedRepositoryManager;
import org.apache.geode.cache.lucene.internal.IndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.LuceneIndexImpl;
import org.apache.geode.cache.lucene.internal.RawIndexRepositoryFactory;
import org.apache.geode.cache.lucene.internal.repository.IndexRepository;
import org.apache.geode.internal.cache.BucketNotFoundException;
import org.apache.geode.internal.cache.PartitionedRegion;

public class RawLuceneRepositoryManager
extends AbstractPartitionedRepositoryManager {
    public static IndexRepositoryFactory indexRepositoryFactory = new RawIndexRepositoryFactory();

    public RawLuceneRepositoryManager(LuceneIndexImpl index, LuceneSerializer serializer) {
        super(index, serializer);
    }

    @Override
    protected IndexRepository getRepository(Integer bucketId) throws BucketNotFoundException {
        IndexRepository repo = (IndexRepository)this.indexRepositories.get(bucketId);
        if (repo != null && !repo.isClosed()) {
            return repo;
        }
        try {
            repo = this.computeRepository(bucketId, this.serializer, this.index, this.userRegion, repo);
            return repo;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BucketNotFoundException("Colocated index buckets not found for bucket id " + bucketId);
        }
    }

    @Override
    public IndexRepository computeRepository(Integer bucketId, LuceneSerializer serializer, LuceneIndexImpl index, PartitionedRegion userRegion, IndexRepository oldRepository) throws IOException {
        return indexRepositoryFactory.computeIndexRepository(bucketId, serializer, index, userRegion, oldRepository);
    }
}

