/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.xml;

import java.util.Stack;
import org.apache.geode.cache.CacheXmlException;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfigBuilder;
import org.apache.geode.connectors.jdbc.internal.ConnectionConfiguration;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingBuilder;
import org.apache.geode.connectors.jdbc.internal.xml.JdbcServiceConfiguration;
import org.apache.geode.internal.cache.extension.Extension;
import org.apache.geode.internal.cache.xmlcache.CacheCreation;
import org.xml.sax.Attributes;

public enum ElementType {
    CONNECTION_SERVICE("connector-service"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof CacheCreation)) {
                throw new CacheXmlException("jdbc <connector-service> elements must occur within <cache> elements");
            }
            CacheCreation cacheCreation = (CacheCreation)stack.peek();
            JdbcServiceConfiguration serviceConfig = new JdbcServiceConfiguration();
            cacheCreation.getExtensionPoint().addExtension((Extension)serviceConfig);
            stack.push(serviceConfig);
        }

        @Override
        void endElement(Stack<Object> stack) {
            stack.pop();
        }
    }
    ,
    CONNECTION("connection"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof JdbcServiceConfiguration)) {
                throw new CacheXmlException("jdbc <connection> elements must occur within <connector-service> elements");
            }
            ConnectionConfigBuilder connectionConfigBuilder = new ConnectionConfigBuilder().withName(attributes.getValue("name")).withUrl(attributes.getValue("url")).withUser(attributes.getValue("user")).withPassword(attributes.getValue("password")).withParameters(this.parseParameters(attributes));
            stack.push(connectionConfigBuilder);
        }

        private String[] parseParameters(Attributes attributes) {
            String[] result = null;
            String value = attributes.getValue("parameters");
            if (value != null) {
                result = value.split(",");
            }
            return result;
        }

        @Override
        void endElement(Stack<Object> stack) {
            ConnectionConfiguration config = ((ConnectionConfigBuilder)stack.pop()).build();
            JdbcServiceConfiguration connectorService = (JdbcServiceConfiguration)stack.peek();
            connectorService.addConnectionConfig(config);
        }
    }
    ,
    REGION_MAPPING("region-mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof JdbcServiceConfiguration)) {
                throw new CacheXmlException("jdbc <region-mapping> elements must occur within <connector-service> elements");
            }
            RegionMappingBuilder mapping = new RegionMappingBuilder().withRegionName(attributes.getValue("region")).withConnectionConfigName(attributes.getValue("connection-name")).withTableName(attributes.getValue("table")).withPdxClassName(attributes.getValue("pdx-class")).withPrimaryKeyInValue(attributes.getValue("primary-key-in-value"));
            stack.push(mapping);
        }

        @Override
        void endElement(Stack<Object> stack) {
            RegionMapping mapping = ((RegionMappingBuilder)stack.pop()).build();
            JdbcServiceConfiguration connectorService = (JdbcServiceConfiguration)stack.peek();
            connectorService.addRegionMapping(mapping);
        }
    }
    ,
    FIELD_MAPPING("field-mapping"){

        @Override
        void startElement(Stack<Object> stack, Attributes attributes) {
            if (!(stack.peek() instanceof RegionMappingBuilder)) {
                throw new CacheXmlException("jdbc <field-mapping> elements must occur within <region-mapping> elements");
            }
            RegionMappingBuilder mapping = (RegionMappingBuilder)stack.peek();
            String fieldName = attributes.getValue("field-name");
            String columnName = attributes.getValue("column-name");
            mapping.withFieldToColumnMapping(fieldName, columnName);
        }

        @Override
        void endElement(Stack<Object> stack) {
        }
    };

    private String typeName;

    private ElementType(String typeName) {
        this.typeName = typeName;
    }

    static ElementType getTypeFromName(String typeName) {
        for (ElementType type : ElementType.values()) {
            if (!type.typeName.equals(typeName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid type '" + typeName + "'");
    }

    public String getTypeName() {
        return this.typeName;
    }

    abstract void startElement(Stack<Object> var1, Attributes var2);

    abstract void endElement(Stack<Object> var1);
}

