/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.cli.DescribeMappingFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class DescribeMappingCommand
implements GfshCommand {
    static final String DESCRIBE_MAPPING = "describe jdbc-mapping";
    static final String DESCRIBE_MAPPING__HELP = "(Experimental) Describe the specified jdbc mapping.";
    static final String DESCRIBE_MAPPING__REGION_NAME = "region";
    static final String DESCRIBE_MAPPING__REGION_NAME__HELP = "Region name of the jdbc mapping to be described.";
    static final String RESULT_SECTION_NAME = "MappingDescription";
    static final String FIELD_TO_COLUMN_TABLE = "fieldToColumnTable";

    @CliCommand(value={"describe jdbc-mapping"}, help="(Experimental) Describe the specified jdbc mapping.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result describeMapping(@CliOption(key={"region"}, mandatory=true, help="Region name of the jdbc mapping to be described.") String regionName) {
        Set members = this.getMembers(null, null);
        if (members.isEmpty()) {
            return ResultBuilder.createUserErrorResult((String)"No Members Found");
        }
        DistributedMember targetMember = (DistributedMember)members.iterator().next();
        ResultCollector<RegionMapping, List<RegionMapping>> resultCollector = this.execute(new DescribeMappingFunction(), regionName, targetMember);
        RegionMapping config = (RegionMapping)((List)resultCollector.getResult()).get(0);
        if (config == null) {
            return ResultBuilder.createInfoResult((String)String.format("(Experimental) \nMapping for region '%s' not found", regionName));
        }
        CompositeResultData resultData = ResultBuilder.createCompositeResultData();
        this.fillResultData(config, resultData);
        resultData.setHeader("(Experimental) ");
        return ResultBuilder.buildResult((ResultData)resultData);
    }

    ResultCollector<RegionMapping, List<RegionMapping>> execute(DescribeMappingFunction function, String connectionName, DistributedMember targetMember) {
        return this.executeFunction((Function)function, connectionName, targetMember);
    }

    private void fillResultData(RegionMapping mapping, CompositeResultData resultData) {
        CompositeResultData.SectionResultData sectionResult = resultData.addSection(RESULT_SECTION_NAME);
        sectionResult.addSeparator('-');
        sectionResult.addData(DESCRIBE_MAPPING__REGION_NAME, (Object)mapping.getRegionName());
        sectionResult.addData("connection", (Object)mapping.getConnectionConfigName());
        sectionResult.addData("table", (Object)mapping.getTableName());
        sectionResult.addData("pdx-class-name", (Object)mapping.getPdxClassName());
        sectionResult.addData("value-contains-primary-key", (Object)mapping.isPrimaryKeyInValue());
        TabularResultData tabularResultData = sectionResult.addTable(FIELD_TO_COLUMN_TABLE);
        tabularResultData.setHeader("Field to Column Mappings:");
        if (mapping.getFieldToColumnMap() != null) {
            mapping.getFieldToColumnMap().entrySet().forEach(entry -> {
                tabularResultData.accumulate("Field", entry.getKey());
                tabularResultData.accumulate("Column", entry.getValue());
            });
        }
    }
}

