/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.List;
import java.util.Set;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingBuilder;
import org.apache.geode.connectors.jdbc.internal.cli.CreateMappingFunction;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.ResultData;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

@Experimental
public class CreateMappingCommand
implements GfshCommand {
    static final String CREATE_MAPPING = "create jdbc-mapping";
    static final String CREATE_MAPPING__HELP = "(Experimental) Create a mapping for a region for use with a JDBC database connection.";
    static final String CREATE_MAPPING__REGION_NAME = "region";
    static final String CREATE_MAPPING__REGION_NAME__HELP = "Name of the region the mapping is being created for.";
    static final String CREATE_MAPPING__PDX_CLASS_NAME = "pdx-class-name";
    static final String CREATE_MAPPING__PDX_CLASS_NAME__HELP = "Name of pdx class for which values will be written to the database.";
    static final String CREATE_MAPPING__TABLE_NAME = "table";
    static final String CREATE_MAPPING__TABLE_NAME__HELP = "Name of database table for values to be written to.";
    static final String CREATE_MAPPING__CONNECTION_NAME = "connection";
    static final String CREATE_MAPPING__CONNECTION_NAME__HELP = "Name of JDBC connection to use.";
    static final String CREATE_MAPPING__VALUE_CONTAINS_PRIMARY_KEY = "value-contains-primary-key";
    static final String CREATE_MAPPING__PRIMARY_KEY_IN_VALUE__HELP = "If true, the primary key is contained in the PDX object, otherwise the region entry key is used for the primary key column value.";
    static final String CREATE_MAPPING__FIELD_MAPPING = "field-mapping";
    static final String CREATE_MAPPING__FIELD_MAPPING__HELP = "Key value pairs of PDX field names to database column names formatted like \"key:value(,key:value)*\".";
    private static final String ERROR_PREFIX = "ERROR: ";

    @CliCommand(value={"create jdbc-mapping"}, help="(Experimental) Create a mapping for a region for use with a JDBC database connection.")
    @CliMetaData(relatedTopic={"Geode"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result createMapping(@CliOption(key={"region"}, mandatory=true, help="Name of the region the mapping is being created for.") String regionName, @CliOption(key={"connection"}, mandatory=true, help="Name of JDBC connection to use.") String connectionName, @CliOption(key={"table"}, help="Name of database table for values to be written to.") String table, @CliOption(key={"pdx-class-name"}, help="Name of pdx class for which values will be written to the database.") String pdxClassName, @CliOption(key={"value-contains-primary-key"}, help="If true, the primary key is contained in the PDX object, otherwise the region entry key is used for the primary key column value.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") boolean keyInValue, @CliOption(key={"field-mapping"}, help="Key value pairs of PDX field names to database column names formatted like \"key:value(,key:value)*\".") String[] fieldMappings) {
        Set targetMembers = this.getMembers(null, null);
        RegionMapping mapping = this.getArguments(regionName, connectionName, table, pdxClassName, keyInValue, fieldMappings);
        ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector = this.execute(new CreateMappingFunction(), mapping, targetMembers);
        TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
        XmlEntity xmlEntity = this.fillTabularResultData(resultCollector, tabularResultData);
        tabularResultData.setHeader("(Experimental) ");
        CommandResult result = ResultBuilder.buildResult((ResultData)tabularResultData);
        this.updateClusterConfiguration((Result)result, xmlEntity);
        return result;
    }

    RegionMapping getArguments(String regionName, String connectionName, String table, String pdxClassName, boolean keyInValue, String[] fieldMappings) {
        RegionMappingBuilder builder = new RegionMappingBuilder().withRegionName(regionName).withConnectionConfigName(connectionName).withTableName(table).withPdxClassName(pdxClassName).withPrimaryKeyInValue(keyInValue).withFieldToColumnMappings(fieldMappings);
        return builder.build();
    }

    ResultCollector<CliFunctionResult, List<CliFunctionResult>> execute(CreateMappingFunction function, RegionMapping regionMapping, Set<DistributedMember> targetMembers) {
        return this.executeFunction((Function)function, regionMapping, targetMembers);
    }

    private XmlEntity fillTabularResultData(ResultCollector<CliFunctionResult, List<CliFunctionResult>> resultCollector, TabularResultData tabularResultData) {
        XmlEntity xmlEntity = null;
        for (CliFunctionResult oneResult : (List)resultCollector.getResult()) {
            if (oneResult.isSuccessful()) {
                xmlEntity = this.addSuccessToResults(tabularResultData, oneResult);
                continue;
            }
            this.addErrorToResults(tabularResultData, oneResult);
        }
        return xmlEntity;
    }

    private XmlEntity addSuccessToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)oneResult.getMessage());
        return oneResult.getXmlEntity();
    }

    private void addErrorToResults(TabularResultData tabularResultData, CliFunctionResult oneResult) {
        tabularResultData.accumulate("Member", (Object)oneResult.getMemberIdOrName());
        tabularResultData.accumulate("Status", (Object)(ERROR_PREFIX + oneResult.getMessage()));
        tabularResultData.setStatus(Result.Status.ERROR);
    }

    private void updateClusterConfiguration(Result result, XmlEntity xmlEntity) {
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().addXmlEntity(xmlEntity, null));
        }
    }
}

