/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import java.util.Map;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.connectors.jdbc.internal.JdbcConnectorService;
import org.apache.geode.connectors.jdbc.internal.RegionMapping;
import org.apache.geode.connectors.jdbc.internal.RegionMappingNotFoundException;
import org.apache.geode.connectors.jdbc.internal.cli.ExceptionHandler;
import org.apache.geode.connectors.jdbc.internal.cli.FunctionContextArgumentProvider;
import org.apache.geode.connectors.jdbc.internal.cli.JdbcCliFunction;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;

@Experimental
public class AlterMappingFunction
extends JdbcCliFunction<RegionMapping, CliFunctionResult> {
    AlterMappingFunction() {
        super(new FunctionContextArgumentProvider(), new ExceptionHandler());
    }

    @Override
    CliFunctionResult getFunctionResult(JdbcConnectorService service, FunctionContext<RegionMapping> context) throws Exception {
        RegionMapping mapping = (RegionMapping)context.getArguments();
        RegionMapping existingMapping = service.getMappingForRegion(mapping.getRegionName());
        if (existingMapping == null) {
            throw new RegionMappingNotFoundException("RegionMapping for region " + mapping.getRegionName() + " was not found");
        }
        RegionMapping alteredMapping = this.alterRegionMapping(mapping, existingMapping);
        service.replaceRegionMapping(alteredMapping);
        String member = this.getMember(context);
        XmlEntity xmlEntity = this.createXmlEntity(context);
        CliFunctionResult result = this.createSuccessResult(mapping.getRegionName(), member, xmlEntity);
        return result;
    }

    RegionMapping alterRegionMapping(RegionMapping regionMapping, RegionMapping existingMapping) {
        String connectionName = regionMapping.getConnectionConfigName() == null ? existingMapping.getConnectionConfigName() : regionMapping.getConnectionConfigName();
        String table = this.getValue(regionMapping.getTableName(), existingMapping.getTableName());
        String pdxClassName = this.getValue(regionMapping.getPdxClassName(), existingMapping.getPdxClassName());
        Boolean keyInValue = regionMapping.isPrimaryKeyInValue() == null ? existingMapping.isPrimaryKeyInValue() : regionMapping.isPrimaryKeyInValue();
        Map<String, String> fieldMappings = regionMapping.getFieldToColumnMap();
        if (fieldMappings == null) {
            fieldMappings = existingMapping.getFieldToColumnMap();
        }
        RegionMapping alteredMapping = new RegionMapping(existingMapping.getRegionName(), pdxClassName, table, connectionName, keyInValue, fieldMappings);
        return alteredMapping;
    }

    private String getValue(String newValue, String existingValue) {
        if (newValue == null) {
            return existingValue;
        }
        return newValue.isEmpty() ? null : newValue;
    }

    private CliFunctionResult createSuccessResult(String connectionName, String member, XmlEntity xmlEntity) {
        String message = "Altered JDBC connection " + connectionName + " on " + member;
        return new CliFunctionResult(member, xmlEntity, message);
    }
}

