/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.ra.spi;

import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.i18n.LocalizedStrings;

public class JCALocalTransaction
implements LocalTransaction {
    private volatile InternalCache cache;
    private volatile TXManagerImpl gfTxMgr;
    private volatile TransactionId tid;
    private volatile boolean initDone = false;

    JCALocalTransaction(InternalCache cache, TXManagerImpl tm) {
        this.cache = cache;
        this.gfTxMgr = tm;
        this.initDone = true;
    }

    JCALocalTransaction() {
        this.cache = null;
        this.gfTxMgr = null;
        this.initDone = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void begin() throws ResourceException {
        try {
            LogWriter logger;
            if (!this.initDone || this.cache.isClosed()) {
                this.init();
            }
            if ((logger = this.cache.getLogger()).fineEnabled()) {
                logger.fine("JCALocalTransaction::begin:");
            }
            TransactionManager tm = this.cache.getJTATransactionManager();
            if (this.tid != null) {
                throw new LocalTransactionException(" A transaction is already in progress");
            }
            if (tm != null && tm.getTransaction() != null) {
                TXStateProxy tsp;
                if (logger.fineEnabled()) {
                    logger.fine("JCAManagedConnection: JTA transaction is on");
                }
                if ((tsp = this.gfTxMgr.getTXState()) != null) throw new LocalTransactionException("GemFire is already associated with a transaction");
                this.gfTxMgr.begin();
                tsp = this.gfTxMgr.getTXState();
                tsp.setJCATransaction();
                this.tid = tsp.getTransactionId();
                if (!logger.fineEnabled()) return;
                logger.fine("JCALocalTransaction:begun GFE transaction");
                return;
            } else {
                if (!logger.fineEnabled()) return;
                logger.fine("JCAManagedConnection: JTA Transaction does not exist.");
            }
            return;
        }
        catch (SystemException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void commit() throws ResourceException {
        TXStateProxy tsp;
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCALocalTransaction:invoked commit");
        }
        if ((tsp = this.gfTxMgr.getTXState()) != null && this.tid != tsp.getTransactionId()) {
            throw new IllegalStateException("Local Transaction associated with Tid = " + this.tid + " attempting to commit a different transaction");
        }
        try {
            this.gfTxMgr.commit();
            this.tid = null;
        }
        catch (Exception e) {
            throw new LocalTransactionException(e.toString());
        }
    }

    public void rollback() throws ResourceException {
        block10: {
            TXStateProxy tsp = this.gfTxMgr.getTXState();
            if (tsp != null && this.tid != tsp.getTransactionId()) {
                throw new IllegalStateException("Local Transaction associated with Tid = " + this.tid + " attempting to commit a different transaction");
            }
            LogWriter logger = this.cache.getLogger();
            if (logger.fineEnabled()) {
                logger.fine("JCALocalTransaction:invoked rollback");
            }
            try {
                this.gfTxMgr.rollback();
            }
            catch (IllegalStateException ise) {
                if (ise.getMessage().equals(LocalizedStrings.TXManagerImpl_THREAD_DOES_NOT_HAVE_AN_ACTIVE_TRANSACTION.toLocalizedString())) {
                    break block10;
                }
                throw new ResourceException((Throwable)ise);
            }
            catch (RuntimeException e) {
                throw new ResourceException((Throwable)e);
            }
            finally {
                this.tid = null;
            }
        }
    }

    private void init() {
        this.cache = (InternalCache)CacheFactory.getAnyInstance();
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCAManagedConnection:init. Inside init");
        }
        this.gfTxMgr = this.cache.getTxManager();
        this.initDone = true;
    }

    boolean transactionInProgress() {
        return this.tid != null;
    }
}

