/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.cache.tier.sockets.command.BaseCQCommand;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class GetCQStats
extends BaseCQCommand {
    private static final GetCQStats singleton = new GetCQStats();

    public static Command getCommand() {
        return singleton;
    }

    private GetCQStats() {
    }

    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("{}: Received close all client CQs request from {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString());
        }
        String cqName = clientMessage.getPart(0).getString();
        if (isDebugEnabled) {
            logger.debug("{}: Received close CQ request from {} cqName: {}", (Object)serverConnection.getName(), (Object)serverConnection.getSocketString(), (Object)cqName);
        }
        if (cqName == null) {
            String err = "The cqName for the cq stats request is null";
            this.sendCqResponse(47, err, clientMessage.getTransactionId(), null, serverConnection);
            return;
        }
        securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ);
        try {
            CqService cqService = crHelper.getCache().getCqService();
            cqService.start();
        }
        catch (Exception e) {
            String err = "Exception while Getting the CQ Statistics. ";
            this.sendCqResponse(50, err, clientMessage.getTransactionId(), e, serverConnection);
            return;
        }
        this.sendCqResponse(6, "cq stats sent successfully.", clientMessage.getTransactionId(), null, serverConnection);
        serverConnection.setAsTrue(1);
        long oldStart = start;
        start = DistributionStats.getStatTime();
        stats.incProcessGetCqStatsTime(start - oldStart);
    }
}

