/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZScoreExecutor
extends SortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 3) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZSCORE command is \"ZSCORE key member\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        ByteArrayWrapper member = new ByteArrayWrapper(commandElems.get(2));
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        DoubleWrapper score = keyRegion.get(member);
        if (score == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        command.setResponse(Coder.getBulkStringResponse(context.getByteBufAllocator(), score.toString()));
    }
}

