/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class TTLExecutor
extends AbstractExecutor
implements Extendable {
    private final int NOT_EXISTS = -2;
    private final int NO_TIMEOUT = -1;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        RegionProvider rC = context.getRegionProvider();
        boolean exists = false;
        RedisDataType val = rC.getRedisDataType(key);
        if (val != null) {
            exists = true;
        }
        if (!exists) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -2));
            return;
        }
        long ttl = rC.getExpirationDelayMillis(key);
        if (ttl == 0L) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), -1));
            return;
        }
        if (!this.timeUnitMillis()) {
            ttl /= 1000L;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), ttl));
    }

    protected boolean timeUnitMillis() {
        return false;
    }

    @Override
    public String getArgsError() {
        return "The wrong number of arguments or syntax was provided, the format for the TTL command is \"TTL key\"";
    }
}

