/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.List;
import org.apache.geode.management.internal.cli.json.GfJsonArray;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.geode.management.internal.cli.result.AbstractResultData;
import org.apache.geode.management.internal.cli.result.ResultDataException;

public class TabularResultData
extends AbstractResultData {
    TabularResultData() {
    }

    TabularResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    public TabularResultData accumulate(String accumulateFor, Object value) {
        try {
            this.contentObject.accumulate(accumulateFor, value);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray getHeaders() {
        try {
            return this.contentObject.names();
        }
        catch (GfJsonException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int columnSize() {
        return this.contentObject.size();
    }

    public int rowSize(String key) {
        GfJsonArray jsonArray = null;
        try {
            jsonArray = this.contentObject.getJSONArray(key);
        }
        catch (GfJsonException e) {
            throw new RuntimeException("unable to get the row size of " + key);
        }
        if (jsonArray == null) {
            return 0;
        }
        return jsonArray.getInternalJsonArray().length();
    }

    @Override
    public GfJsonObject getGfJsonObject() {
        return this.gfJsonObject;
    }

    @Override
    public String getType() {
        return "table";
    }

    @Override
    public TabularResultData setHeader(String headerText) {
        return (TabularResultData)super.setHeader(headerText);
    }

    @Override
    public TabularResultData setFooter(String footerText) {
        return (TabularResultData)super.setFooter(footerText);
    }

    @Override
    public String getHeader() {
        return this.gfJsonObject.getString("header");
    }

    @Override
    public String getFooter() {
        return this.gfJsonObject.getString("footer");
    }

    public List<String> retrieveAllValues(String columnName) {
        ArrayList<String> values = new ArrayList<String>();
        try {
            GfJsonArray jsonArray = this.contentObject.getJSONArray(columnName);
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                values.add(String.valueOf(jsonArray.get(i)));
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return values;
    }
}

