/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.geode.management.cli.Result;

public class FileResult
implements Result {
    private List<File> files = new ArrayList<File>();

    public void addFile(File file) {
        this.files.add(file);
    }

    @Override
    public Result.Status getStatus() {
        return Result.Status.OK;
    }

    @Override
    public void resetToFirstLine() {
    }

    @Override
    public boolean hasNextLine() {
        return false;
    }

    @Override
    public String nextLine() {
        return "";
    }

    public List<File> getFiles() {
        return this.files;
    }

    public long computeFileSizeTotal() {
        long byteCount = 0L;
        for (File file : this.files) {
            byteCount += file.length();
        }
        return byteCount;
    }

    public String getFormattedFileList() {
        return this.files.stream().map(File::getName).collect(Collectors.joining(", "));
    }

    @Override
    public boolean hasIncomingFiles() {
        return true;
    }

    @Override
    public void saveIncomingFiles(String directory) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean failedToPersist() {
        return false;
    }

    @Override
    public void setCommandPersisted(boolean commandPersisted) {
        throw new UnsupportedOperationException("not supported");
    }
}

