/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.json;

import java.util.Collection;
import java.util.Map;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.json.GfJsonException;
import org.apache.geode.management.internal.cli.json.GfJsonObject;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class GfJsonArray {
    private static final Logger logger = LogService.getLogger();
    private JSONArray jsonArray;

    public GfJsonArray() {
        this.jsonArray = new JSONArray();
    }

    public GfJsonArray(Object array) throws GfJsonException {
        try {
            this.jsonArray = array instanceof JSONArray ? (JSONArray)array : new JSONArray(array);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonArray(String source) throws GfJsonException {
        try {
            this.jsonArray = new JSONArray(source);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public Object get(int index) throws GfJsonException {
        try {
            return this.jsonArray.get(index);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonObject getJSONObject(int index) throws GfJsonException {
        try {
            return new GfJsonObject(this.jsonArray.getJSONObject(index));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public GfJsonArray put(Object value) {
        this.jsonArray.put(GfJsonArray.extractInternalForGfJsonOrReturnSame(value));
        return this;
    }

    public GfJsonArray put(int index, Object value) throws GfJsonException {
        try {
            this.jsonArray.put(index, GfJsonArray.extractInternalForGfJsonOrReturnSame(value));
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray put(Collection<?> value) {
        this.jsonArray.put(value);
        return this;
    }

    public GfJsonArray put(int index, Collection<?> value) throws GfJsonException {
        try {
            this.jsonArray.put(index, value);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public GfJsonArray put(Map<?, ?> value) {
        this.jsonArray.put(value);
        return this;
    }

    public GfJsonArray put(int index, Map<?, ?> value) throws GfJsonException {
        try {
            this.jsonArray.put(index, value);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
        return this;
    }

    public int size() {
        return this.jsonArray.length();
    }

    public String toString() {
        return this.jsonArray.toString();
    }

    public String toIndentedString(int indentFactor) throws GfJsonException {
        try {
            return this.jsonArray.toString(indentFactor);
        }
        catch (JSONException e) {
            throw new GfJsonException(e.getMessage());
        }
    }

    public static byte[] toByteArray(GfJsonArray jsonArray) throws GfJsonException {
        byte[] byteArray = null;
        if (jsonArray != null) {
            int length = jsonArray.size();
            byteArray = new byte[length];
            for (int i = 0; i < length; ++i) {
                try {
                    byteArray[i] = Byte.valueOf(String.valueOf(jsonArray.get(i)));
                    continue;
                }
                catch (GfJsonException e) {
                    throw new GfJsonException(e.getMessage());
                }
            }
        }
        return byteArray;
    }

    public static String[] toStringArray(GfJsonArray jsonArray) {
        String[] stringArray = null;
        if (jsonArray != null) {
            int length = jsonArray.size();
            stringArray = new String[length];
            for (int i = 0; i < length; ++i) {
                try {
                    stringArray[i] = String.valueOf(jsonArray.get(i));
                    continue;
                }
                catch (GfJsonException e) {
                    logger.info("", (Throwable)e);
                    stringArray = null;
                }
            }
        }
        return stringArray;
    }

    public JSONArray getInternalJsonArray() {
        return this.jsonArray;
    }

    private static Object extractInternalForGfJsonOrReturnSame(Object value) {
        Object returnedValue = value;
        if (value instanceof GfJsonObject) {
            returnedValue = ((GfJsonObject)value).getInternalJsonObject();
        } else if (value instanceof GfJsonArray) {
            returnedValue = ((GfJsonArray)value).getInternalJsonArray();
        } else if (value == null) {
            returnedValue = GfJsonObject.NULL;
        }
        return returnedValue;
    }
}

