/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.help;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.help.HelpBlock;
import org.apache.geode.management.internal.cli.help.Topic;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.springframework.shell.core.MethodTarget;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class Helper {
    static final String NAME_NAME = "NAME";
    static final String SYNONYMS_NAME = "SYNONYMS";
    static final String SYNOPSIS_NAME = "SYNOPSIS";
    static final String SYNTAX_NAME = "SYNTAX";
    static final String OPTIONS_NAME = "PARAMETERS";
    static final String IS_AVAILABLE_NAME = "IS AVAILABLE";
    static final String REQUIRED_SUB_NAME = "Required: ";
    static final String SYNONYMS_SUB_NAME = "Synonyms: ";
    static final String SPECIFIEDDEFAULTVALUE_SUB_NAME = "Default (if the parameter is specified without value): ";
    static final String UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME = "Default (if the parameter is not specified): ";
    static final String VALUE_FIELD = "value";
    static final String TRUE_TOKEN = "true";
    static final String FALSE_TOKEN = "false";
    static final String AVAILABLE = "Available";
    static final String NOT_AVAILABLE = "Not Available";
    private final Map<String, Topic> topics = new HashMap<String, Topic>();
    private final Map<String, Method> commands = new TreeMap<String, Method>();
    private final Map<String, MethodTarget> availabilityIndicators = new HashMap<String, MethodTarget>();

    public Helper() {
        this.initTopic("Geode", "Apache Geode is a distributed data management platform providing dynamic scalability, high performance and database-like persistence.");
        this.initTopic("Region", "A region is the core building block of the Apache Geode distributed system. Cached data is organized into regions and all data puts, gets, and querying activities are done against them.");
        this.initTopic("WAN", "For multiple data centers in remote locations, Geode provides a WAN gateway to facilitate data sharing. The WAN gateway connects two or more remote sites and then sends asynchronous, batched updates as data is changed.");
        this.initTopic("JMX", "JMX technology provides the tools for building distributed, Web-based, modular and dynamic solutions for managing and monitoring devices, applications, and service-driven networks.");
        this.initTopic("Disk Store", "Disk stores are used to persist data to disk as a backup to your in-memory copy or as overflow storage when memory use is too high.");
        this.initTopic("Locator", "JVMs running Geode discover each other through a TCP service named the locator.");
        this.initTopic("Server", "A server is Geode cluster member which holds a Geode cache. Depending on the topology used it can refer to either a system that responds to client requests or a system that is only a peer to other members.");
        this.initTopic("Manager", "The Manager is a member which has the additional role of a managing & monitoring the Geode distributed system.");
        this.initTopic("Statistics", "iEvery application and server in a Apache Geode distributed system can be configured to perform statistical data collection for analysis.");
        this.initTopic("Lifecycle", "Launching, execution and termination of Geode cluster members such as servers and locators.");
        this.initTopic("Management-Monitoring", "The management of and monitoring of Geode systems using Geode tools, such as Apache Geode Pulse or Data Browser, and JConsole, which is provided with the JDK(TM)");
        this.initTopic("Data", "User data as stored in regions of the Geode distributed system.");
        this.initTopic("Configuration", "Configuration of Apache Geode Cache & Servers/Locators hosting the Cache.");
        this.initTopic("Function Execution", "The function execution service provides solutions for these application use cases: \n\tAn application that executes a server-side transaction or carries out data updates using the Geode distributed locking service. \n\tAn application that needs to initialize some of its components once on each server, which might be used later by executed functions. Initialization and startup of a third-party service, such as a messaging service. \n\tAny arbitrary aggregation operation that requires iteration over local data sets that can be done more efficiently through a single call to the cache server. \n\tAny kind of external resource provisioning that can be done by executing a function on a server.");
        this.initTopic("Help", "Provides usage information for gfsh & its commands.");
        this.initTopic("Debug-Utility", "Debugging aids & utilities to use with Apache Geode.");
        this.initTopic("GFSH", "The Geode Shell");
        this.initTopic("Logs", "Generate log contents as per the need");
        this.initTopic("Client", "Client status");
    }

    private void initTopic(String topic, String desc) {
        this.topics.put(topic, new Topic(topic, desc));
    }

    public void addCommand(CliCommand command, Method commandMethod) {
        Arrays.stream(command.value()).forEach(cmd -> this.commands.put((String)cmd, commandMethod));
        CliMetaData cliMetaData = commandMethod.getDeclaredAnnotation(CliMetaData.class);
        if (cliMetaData == null) {
            return;
        }
        String[] related = cliMetaData.relatedTopic();
        String commandString = command.value()[0];
        if (related == null) {
            return;
        }
        Arrays.stream(related).forEach(topic -> {
            Topic foundTopic = this.topics.get(topic);
            if (foundTopic == null) {
                throw new IllegalArgumentException("No such topic found in the initial map: " + topic);
            }
            foundTopic.addRelatedCommand(commandString, command.help());
        });
    }

    public void addAvailabilityIndicator(CliAvailabilityIndicator availability, MethodTarget target) {
        Arrays.stream(availability.value()).forEach(command -> this.availabilityIndicators.put((String)command, target));
    }

    public String getHelp(String buffer, int terminalWidth) {
        if (StringUtils.isBlank((String)buffer)) {
            return this.getHelp().toString(terminalWidth);
        }
        Method method = this.commands.get(buffer);
        if (method == null) {
            return "no help exists for this command.";
        }
        HelpBlock helpBlock = this.getHelp(method.getDeclaredAnnotation(CliCommand.class), method.getParameterAnnotations(), method.getParameterTypes());
        return helpBlock.toString(terminalWidth);
    }

    public String getHint(String buffer) {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isBlank((String)buffer)) {
            builder.append("Hints are available for the following topics. Use \"hint <topic-name>\" for a specific hint.").append(GfshParser.LINE_SEPARATOR).append(GfshParser.LINE_SEPARATOR);
            ArrayList<String> sortedTopics = new ArrayList<String>(this.topics.keySet());
            Collections.sort(sortedTopics);
            sortedTopics.stream().forEachOrdered(topic -> builder.append((String)topic).append(GfshParser.LINE_SEPARATOR));
            return builder.toString();
        }
        Topic topic2 = this.topics.get(buffer);
        if (topic2 == null) {
            return CliStrings.format("Unknown topic: {0}. Use hint; to view the list of available topics.", (Object)buffer);
        }
        builder.append(topic2.desc).append(GfshParser.LINE_SEPARATOR).append(GfshParser.LINE_SEPARATOR);
        Collections.sort(topic2.relatedCommands);
        topic2.relatedCommands.stream().forEachOrdered(command -> builder.append(command.command).append(": ").append(command.desc).append(GfshParser.LINE_SEPARATOR));
        return builder.toString();
    }

    public Set<String> getTopicNames() {
        return this.topics.keySet();
    }

    boolean isAvailable(String command) {
        MethodTarget target = this.availabilityIndicators.get(command);
        if (target == null) {
            return true;
        }
        try {
            return (Boolean)target.getMethod().invoke(target.getTarget(), new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasAvailabilityIndicator(String command) {
        return this.availabilityIndicators.get(command) != null;
    }

    HelpBlock getHelp() {
        HelpBlock root = new HelpBlock();
        this.commands.keySet().stream().sorted().map(this.commands::get).forEach(method -> root.addChild(this.getHelp(method.getDeclaredAnnotation(CliCommand.class), null, null)));
        return root;
    }

    HelpBlock getHelp(CliCommand cliCommand, Annotation[][] annotations, Class<?>[] parameterTypes) {
        String commandName = cliCommand.value()[0];
        boolean isAvailable = this.isAvailable(commandName);
        if (annotations == null && parameterTypes == null) {
            String available = isAvailable ? AVAILABLE : NOT_AVAILABLE;
            HelpBlock help = new HelpBlock(commandName + " (" + available + ")");
            help.addChild(new HelpBlock(cliCommand.help()));
            return help;
        }
        HelpBlock root = new HelpBlock();
        HelpBlock name = new HelpBlock(NAME_NAME);
        name.addChild(new HelpBlock(commandName));
        root.addChild(name);
        HelpBlock availability = new HelpBlock(IS_AVAILABLE_NAME);
        availability.addChild(new HelpBlock(isAvailable + ""));
        root.addChild(availability);
        String[] allNames = cliCommand.value();
        if (allNames.length > 1) {
            HelpBlock synonyms = new HelpBlock(SYNONYMS_NAME);
            for (int i = 1; i < allNames.length; ++i) {
                synonyms.addChild(new HelpBlock(allNames[i]));
            }
            root.addChild(synonyms);
        }
        if (StringUtils.isNotBlank((String)cliCommand.help())) {
            HelpBlock synopsis = new HelpBlock(SYNOPSIS_NAME);
            synopsis.addChild(new HelpBlock(cliCommand.help()));
            root.addChild(synopsis);
        }
        HelpBlock syntaxBlock = new HelpBlock(SYNTAX_NAME);
        String syntax = this.getSyntaxString(commandName, annotations, parameterTypes);
        syntaxBlock.addChild(new HelpBlock(syntax));
        root.addChild(syntaxBlock);
        if (annotations.length > 0) {
            HelpBlock options = new HelpBlock(OPTIONS_NAME);
            for (int i = 0; i < annotations.length; ++i) {
                CliOption cliOption = (CliOption)this.getAnnotation(annotations[i], CliOption.class);
                HelpBlock optionNode = this.getOptionDetail(cliOption);
                options.addChild(optionNode);
            }
            root.addChild(options);
        }
        return root;
    }

    HelpBlock getOptionDetail(CliOption cliOption) {
        HelpBlock optionNode = new HelpBlock(Helper.getPrimaryKey(cliOption));
        String help = cliOption.help();
        optionNode.addChild(new HelpBlock(StringUtils.isNotBlank((String)help) ? help : ""));
        if (Helper.getSynonyms(cliOption).size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (String string : Helper.getSynonyms(cliOption)) {
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(string);
            }
            optionNode.addChild(new HelpBlock(SYNONYMS_SUB_NAME + builder.toString()));
        }
        optionNode.addChild(new HelpBlock(REQUIRED_SUB_NAME + (cliOption.mandatory() ? TRUE_TOKEN : FALSE_TOKEN)));
        if (!Helper.isNullOrBlank(cliOption.specifiedDefaultValue())) {
            optionNode.addChild(new HelpBlock(SPECIFIEDDEFAULTVALUE_SUB_NAME + cliOption.specifiedDefaultValue()));
        }
        if (!Helper.isNullOrBlank(cliOption.unspecifiedDefaultValue())) {
            optionNode.addChild(new HelpBlock(UNSPECIFIEDDEFAULTVALUE_VALUE_SUB_NAME + cliOption.unspecifiedDefaultValue()));
        }
        return optionNode;
    }

    private <T> T getAnnotation(Annotation[] annotations, Class<?> klass) {
        for (Annotation annotation : annotations) {
            if (!klass.isAssignableFrom(annotation.getClass())) continue;
            return (T)annotation;
        }
        return null;
    }

    String getSyntaxString(String commandName, Annotation[][] annotations, Class[] parameterTypes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(commandName);
        for (int i = 0; i < annotations.length; ++i) {
            CliOption cliOption = (CliOption)this.getAnnotation(annotations[i], CliOption.class);
            String optionString = Helper.getOptionString(cliOption, parameterTypes[i]);
            if (cliOption.mandatory()) {
                buffer.append(" ").append(optionString);
                continue;
            }
            buffer.append(" [").append(optionString).append("]");
        }
        return buffer.toString();
    }

    private static String getOptionString(CliOption cliOption, Class<?> optionType) {
        boolean hasSpecifiedDefault;
        String key0 = cliOption.key()[0];
        if ("".equals(key0)) {
            return cliOption.key()[1];
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("--").append(key0);
        boolean bl = hasSpecifiedDefault = !Helper.isNullOrBlank(cliOption.specifiedDefaultValue());
        if (hasSpecifiedDefault) {
            buffer.append("(");
        }
        buffer.append("=").append(VALUE_FIELD);
        if (hasSpecifiedDefault) {
            buffer.append(")?");
        }
        if (Helper.isCollectionOrArrayType(optionType)) {
            buffer.append("(").append(",").append(VALUE_FIELD).append(")*");
        }
        return buffer.toString();
    }

    private static boolean isCollectionOrArrayType(Class<?> typeToCheck) {
        return typeToCheck != null && (typeToCheck.isArray() || Collection.class.isAssignableFrom(typeToCheck));
    }

    private static String getPrimaryKey(CliOption option) {
        String[] keys = option.key();
        if (keys.length == 0) {
            throw new RuntimeException("Invalid option keys");
        }
        if ("".equals(keys[0])) {
            return keys[1];
        }
        return keys[0];
    }

    private static List<String> getSynonyms(CliOption option) {
        ArrayList<String> synonyms = new ArrayList<String>();
        String[] keys = option.key();
        if (keys.length < 2) {
            return synonyms;
        }
        if ("".equals(keys[0])) {
            return synonyms;
        }
        for (int i = 1; i < keys.length; ++i) {
            synonyms.add(keys[i]);
        }
        return synonyms;
    }

    private static boolean isNullOrBlank(String value) {
        return StringUtils.isBlank((String)value) || "__NULL__".equals(value);
    }

    public Set<String> getCommands() {
        return this.commands.keySet();
    }
}

