/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.internal.datasource.ConfigProperty;

public class JndiBindingConfiguration
implements Serializable {
    private Integer blockingTimeout;
    private String connectionPoolDatasource;
    private String connectionUrl;
    private Integer idleTimeout;
    private Integer initPoolSize;
    private String jdbcDriver;
    private String jndiName;
    private Integer loginTimeout;
    private String managedConnFactory;
    private Integer maxPoolSize;
    private String password;
    private String transactionType;
    private DATASOURCE_TYPE type;
    private String username;
    private String xaDatasource;
    private List<ConfigProperty> datasourceConfigurations = new ArrayList<ConfigProperty>();

    public Integer getBlockingTimeout() {
        return this.blockingTimeout;
    }

    public void setBlockingTimeout(Integer blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
    }

    public String getConnectionPoolDatasource() {
        return this.connectionPoolDatasource;
    }

    public void setConnectionPoolDatasource(String connectionPoolDatasource) {
        this.connectionPoolDatasource = connectionPoolDatasource;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public void setConnectionUrl(String connectionUrl) {
        this.connectionUrl = connectionUrl;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getInitPoolSize() {
        return this.initPoolSize;
    }

    public void setInitPoolSize(Integer initPoolSize) {
        this.initPoolSize = initPoolSize;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Integer getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(Integer loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public String getManagedConnFactory() {
        return this.managedConnFactory;
    }

    public void setManagedConnFactory(String managedConnFactory) {
        this.managedConnFactory = managedConnFactory;
    }

    public Integer getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(Integer maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public DATASOURCE_TYPE getType() {
        return this.type;
    }

    public void setType(DATASOURCE_TYPE type) {
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getXaDatasource() {
        return this.xaDatasource;
    }

    public void setXaDatasource(String xaDatasource) {
        this.xaDatasource = xaDatasource;
    }

    public List<ConfigProperty> getDatasourceConfigurations() {
        return this.datasourceConfigurations;
    }

    public void setDatasourceConfigurations(List<ConfigProperty> dsConfigurations) {
        this.datasourceConfigurations = dsConfigurations;
    }

    public Map getParamsAsMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("blocking-timeout-seconds", this.getBlockingTimeout());
        params.put("conn-pooled-datasource-class", this.getConnectionPoolDatasource());
        params.put("connection-url", this.getConnectionUrl());
        params.put("idle-timeout-seconds", this.getIdleTimeout());
        params.put("init-pool-size", this.getInitPoolSize());
        params.put("jdbc-driver-class", this.getJdbcDriver());
        params.put("jndi-name", this.getJndiName());
        params.put("login-timeout-seconds", this.getLoginTimeout());
        params.put("managed-conn-factory-class", this.getManagedConnFactory());
        params.put("max-pool-size", this.getMaxPoolSize());
        params.put("password", this.getPassword());
        params.put("transaction-type", this.getTransactionType());
        params.put("type", this.getType().getType());
        params.put("user-name", this.getUsername());
        params.put("xa-datasource-class", this.getXaDatasource());
        return params;
    }

    public static enum DATASOURCE_TYPE {
        MANAGED("ManagedDataSource"),
        SIMPLE("SimpleDataSource"),
        POOLED("PooledDataSource"),
        XAPOOLED("XAPooledDataSource");

        private final String type;

        private DATASOURCE_TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name();
        }
    }
}

