/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.jndi.JNDIInvoker;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.JndiBindingConfiguration;
import org.apache.geode.management.internal.cli.i18n.CliStrings;

public class CreateJndiBindingFunction
implements InternalFunction<JndiBindingConfiguration> {
    static final String RESULT_MESSAGE = "Initiated jndi binding \"{0}\" on \"{1}\". See server logs to verify.";

    @Override
    public void execute(FunctionContext<JndiBindingConfiguration> context) {
        ResultSender resultSender = context.getResultSender();
        JndiBindingConfiguration configuration = context.getArguments();
        JNDIInvoker.mapDatasource(configuration.getParamsAsMap(), configuration.getDatasourceConfigurations());
        resultSender.lastResult(new CliFunctionResult(context.getMemberName(), true, CliStrings.format(RESULT_MESSAGE, configuration.getJndiName(), context.getMemberName())));
    }
}

