/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.DiskStoreAttributes;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.logging.log4j.Logger;

public class CreateDiskStoreFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        String memberId = "";
        try {
            Object[] args = (Object[])context.getArguments();
            String diskStoreName = (String)args[0];
            DiskStoreAttributes diskStoreAttrs = (DiskStoreAttributes)args[1];
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            DiskStoreFactory diskStoreFactory = cache.createDiskStoreFactory(diskStoreAttrs);
            diskStoreFactory.create(diskStoreName);
            XmlEntity xmlEntity = new XmlEntity("disk-store", "name", diskStoreName);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, xmlEntity, "Success"));
        }
        catch (CacheClosedException cce) {
            context.getResultSender().lastResult(new CliFunctionResult(memberId, false, null));
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            logger.error("Could not create disk store: {}", (Object)th.getMessage(), (Object)th);
            context.getResultSender().lastResult(new CliFunctionResult(memberId, th, null));
        }
    }

    @Override
    public String getId() {
        return CreateDiskStoreFunction.class.getName();
    }
}

