/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.shell.MXBeanProvider;
import org.apache.geode.management.internal.cli.util.ThreePhraseGenerator;

public class StartMemberUtils {
    public static final String GEODE_HOME = System.getenv("GEODE_HOME");
    private static final String JAVA_HOME = System.getProperty("java.home");
    static final int CMS_INITIAL_OCCUPANCY_FRACTION = 60;
    private static final ThreePhraseGenerator nameGenerator = new ThreePhraseGenerator();
    static final String CORE_DEPENDENCIES_JAR_PATHNAME = IOUtils.appendToPath(GEODE_HOME, "lib", "geode-dependencies.jar");
    static final String GEODE_JAR_PATHNAME = IOUtils.appendToPath(GEODE_HOME, "lib", GemFireVersion.getGemFireJarFileName());
    static final long PROCESS_STREAM_READER_ASYNC_STOP_TIMEOUT_MILLIS = 5000L;
    static final int INVALID_PID = -1;

    static ThreePhraseGenerator getNameGenerator() {
        return nameGenerator;
    }

    static void setPropertyIfNotNull(Properties properties, String key, Object value) {
        if (key != null && value != null) {
            properties.setProperty(key, value.toString());
        }
    }

    static String resolveWorkingDir(String userSpecifiedDir, String memberName) {
        File workingDir = userSpecifiedDir == null ? new File(memberName) : new File(userSpecifiedDir);
        String workingDirPath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(workingDir);
        if (!workingDir.exists() && !workingDir.mkdirs()) {
            throw new IllegalStateException(String.format("Could not create directory %s. Please verify directory path or user permissions.", workingDirPath));
        }
        return workingDirPath;
    }

    static void addGemFirePropertyFile(List<String> commandLine, File gemfirePropertiesFile) {
        if (gemfirePropertiesFile != null) {
            commandLine.add("-DgemfirePropertyFile=" + gemfirePropertiesFile.getAbsolutePath());
        }
    }

    static void addGemFireSecurityPropertyFile(List<String> commandLine, File gemfireSecurityPropertiesFile) {
        if (gemfireSecurityPropertiesFile != null) {
            commandLine.add("-DgemfireSecurityPropertyFile=" + gemfireSecurityPropertiesFile.getAbsolutePath());
        }
    }

    static void addGemFireSystemProperties(List<String> commandLine, Properties gemfireProperties) {
        for (Object property : gemfireProperties.keySet()) {
            String propertyName = property.toString();
            String propertyValue = gemfireProperties.getProperty(propertyName);
            if (!StringUtils.isNotBlank((String)propertyValue)) continue;
            commandLine.add("-Dgemfire." + propertyName + "=" + propertyValue);
        }
    }

    static void addJvmArgumentsAndOptions(List<String> commandLine, String[] jvmArgsOpts) {
        if (jvmArgsOpts != null) {
            commandLine.addAll(Arrays.asList(jvmArgsOpts));
        }
    }

    static void addInitialHeap(List<String> commandLine, String initialHeap) {
        if (StringUtils.isNotBlank((String)initialHeap)) {
            commandLine.add("-Xms" + initialHeap);
        }
    }

    static void addMaxHeap(List<String> commandLine, String maxHeap) {
        if (StringUtils.isNotBlank((String)maxHeap)) {
            commandLine.add("-Xmx" + maxHeap);
            String collectorKey = "-XX:+UseConcMarkSweepGC";
            if (!commandLine.contains(collectorKey)) {
                commandLine.add(collectorKey);
            }
            String occupancyFractionKey = "-XX:CMSInitiatingOccupancyFraction=";
            if (commandLine.stream().noneMatch(s -> s.contains(occupancyFractionKey))) {
                commandLine.add(occupancyFractionKey + 60);
            }
        }
    }

    static void addCurrentLocators(GfshCommand gfshCommand, List<String> commandLine, Properties gemfireProperties) throws MalformedObjectNameException {
        String currentLocators;
        if (StringUtils.isBlank((String)gemfireProperties.getProperty("locators")) && StringUtils.isNotBlank((String)(currentLocators = StartMemberUtils.getCurrentLocators(gfshCommand)))) {
            commandLine.add("-D".concat("gemfire.default.").concat("locators").concat("=").concat(currentLocators));
        }
    }

    private static String getCurrentLocators(GfshCommand gfshCommand) throws MalformedObjectNameException {
        String delimitedLocators = "";
        try {
            String[] locators;
            DistributedSystemMXBean dsMBeanProxy;
            if (gfshCommand.isConnectedAndReady() && (dsMBeanProxy = MXBeanProvider.getDistributedSystemMXBean()) != null && (locators = dsMBeanProxy.listLocators()) != null && locators.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < locators.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(locators[i]);
                }
                delimitedLocators = sb.toString();
            }
        }
        catch (IOException e) {
            gfshCommand.getGfsh().logWarning("DistributedSystemMXBean is unavailable\n", e);
        }
        return delimitedLocators;
    }

    public static int readPid(File pidFile) {
        assert (pidFile != null) : "The file from which to read the process ID (pid) cannot be null!";
        if (pidFile.isFile()) {
            int n;
            BufferedReader fileReader = null;
            try {
                fileReader = new BufferedReader(new FileReader(pidFile));
                n = Integer.parseInt(fileReader.readLine());
            }
            catch (IOException | NumberFormatException exception) {
                IOUtils.close(fileReader);
            }
            catch (Throwable throwable) {
                IOUtils.close(fileReader);
                throw throwable;
            }
            IOUtils.close(fileReader);
            return n;
        }
        return -1;
    }

    static String getJavaPath() {
        return new File(new File(JAVA_HOME, "bin"), "java").getPath();
    }

    static String getSystemClasspath() {
        return System.getProperty("java.class.path");
    }

    static String toClasspath(boolean includeSystemClasspath, String[] jarFilePathnames, String ... userClasspaths) {
        StringBuilder classpath = new StringBuilder(StartMemberUtils.getGemFireJarPath());
        for (String userClasspath : userClasspaths = userClasspaths != null ? userClasspaths : ArrayUtils.EMPTY_STRING_ARRAY) {
            if (!StringUtils.isNotBlank((String)userClasspath)) continue;
            classpath.append(classpath.length() == 0 ? "" : File.pathSeparator);
            classpath.append(userClasspath);
        }
        if (includeSystemClasspath) {
            classpath.append(File.pathSeparator);
            classpath.append(StartMemberUtils.getSystemClasspath());
        }
        jarFilePathnames = jarFilePathnames != null ? jarFilePathnames : ArrayUtils.EMPTY_STRING_ARRAY;
        for (String jarFilePathname : jarFilePathnames) {
            if (!StringUtils.isNotBlank((String)jarFilePathname)) continue;
            classpath.append(classpath.length() == 0 ? "" : File.pathSeparator);
            classpath.append(jarFilePathname);
        }
        return classpath.toString();
    }

    static String getGemFireJarPath() {
        String classpath = StartMemberUtils.getSystemClasspath();
        String gemfireJarPath = GEODE_JAR_PATHNAME;
        for (String classpathElement : classpath.split(File.pathSeparator)) {
            if (!classpathElement.endsWith("geode-core-" + GemFireVersion.getGemFireVersion() + ".jar")) continue;
            gemfireJarPath = classpathElement;
            break;
        }
        return gemfireJarPath;
    }
}

