/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.GatewaySenderMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.cli.commands.GatewayCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class StartGatewaySenderCommand
implements GfshCommand {
    @CliCommand(value={"start gateway-sender"}, help="Start the Gateway Sender on a member or members.")
    @CliMetaData(relatedTopic={"WAN"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.GATEWAY)
    public Result startGatewaySender(@CliOption(key={"id"}, mandatory=true, optionContext="geode.converter.gateway.senderid:disable-string-converter", help="ID of the Gateway Sender.") String senderId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group(s) of members on which to start the Gateway Sender.") String[] onGroup, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which to start the Gateway Sender.") String[] onMember) {
        String id = senderId.trim();
        InternalCache cache = this.getCache();
        SystemManagementService service = (SystemManagementService)ManagementService.getExistingManagementService(cache);
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        Set<DistributedMember> dsMembers = this.findMembers(onGroup, onMember);
        if (dsMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger threadNum = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(r, "Start Sender Command Thread " + this.threadNum.incrementAndGet());
                result.setDaemon(true);
                return result;
            }
        });
        ArrayList<Callable<List>> callables = new ArrayList<Callable<List>>();
        for (DistributedMember member : dsMembers) {
            callables.add(() -> {
                GatewaySenderMXBean bean;
                ArrayList<String> statusList = new ArrayList<String>();
                if (cache.getDistributedSystem().getDistributedMember().getId().equals(member.getId())) {
                    bean = service.getLocalGatewaySenderMXBean(id);
                } else {
                    ObjectName objectName = service.getGatewaySenderMBeanName(member, id);
                    bean = service.getMBeanProxy(objectName, GatewaySenderMXBean.class);
                }
                if (bean != null) {
                    if (bean.isRunning()) {
                        statusList.add(member.getId());
                        statusList.add("Error");
                        statusList.add(CliStrings.format("GatewaySender {0} is already started on member {1}", id, member.getId()));
                    } else {
                        bean.start();
                        statusList.add(member.getId());
                        statusList.add("OK");
                        statusList.add(CliStrings.format("GatewaySender {0} is started on member {1}", id, member.getId()));
                    }
                } else {
                    statusList.add(member.getId());
                    statusList.add("Error");
                    statusList.add(CliStrings.format("GatewaySender {0} is not available on member {1}", id, member.getId()));
                }
                return statusList;
            });
        }
        Iterator<DistributedMember> memberIterator = dsMembers.iterator();
        List futures = null;
        try {
            futures = execService.invokeAll(callables);
        }
        catch (InterruptedException ite) {
            GatewayCommandsUtils.accumulateStartResult(resultData, null, "Error", CliStrings.format("Could not invoke start gateway sender {0} operation on members due to {1}", id, ite.getMessage()));
        }
        for (Future future : futures) {
            DistributedMember member = memberIterator.next();
            try {
                List memberStatus = (List)future.get();
                GatewayCommandsUtils.accumulateStartResult(resultData, (String)memberStatus.get(0), (String)memberStatus.get(1), (String)memberStatus.get(2));
            }
            catch (InterruptedException | ExecutionException ite) {
                GatewayCommandsUtils.accumulateStartResult(resultData, member.getId(), "Error", CliStrings.format("Could not start gateway sender {0} on member due to {1}", id, ite.getMessage()));
            }
        }
        execService.shutdown();
        CommandResult result = ResultBuilder.buildResult(resultData);
        return result;
    }
}

