/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.LogWrapper;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class SleepCommand
implements GfshCommand {
    @CliCommand(value={"sleep"}, help="Delay for a specified amount of time in seconds - floating point values are allowed.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result sleep(@CliOption(key={"time"}, unspecifiedDefaultValue="3", help="Number of Seconds to sleep for.") double time) {
        try {
            LogWrapper.getInstance(CliUtil.getCacheIfExists(this::getCache)).fine("Sleeping for " + time + "seconds.");
            Thread.sleep(Math.round(time * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ResultBuilder.createInfoResult("");
    }
}

