/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import org.apache.geode.SystemFailure;
import org.apache.geode.management.DistributedSystemMXBean;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class RevokeMissingDiskStoreCommand
implements GfshCommand {
    @CliCommand(value={"revoke missing-disk-store"}, help="Instructs the member(s) of a distributed system to stop waiting for a disk store to be available. Only revoke a disk store if its files are lost as it will no longer be recoverable once revoking is initiated. Use the \"show missing-disk-store\" command to get descriptions of missing disk stores.")
    @CliMetaData(relatedTopic={"Disk Store"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.DISK)
    public Result revokeMissingDiskStore(@CliOption(key={"id"}, mandatory=true, help="ID of the missing disk store to be revoked.") String id) {
        try {
            DistributedSystemMXBean dsMXBean = ManagementService.getManagementService(this.getCache()).getDistributedSystemMXBean();
            if (dsMXBean.revokeMissingDiskStores(id)) {
                return ResultBuilder.createInfoResult("Missing disk store successfully revoked");
            }
            return ResultBuilder.createUserErrorResult("Unable to find missing disk store to revoke");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure(e);
            throw e;
        }
        catch (Throwable th) {
            SystemFailure.checkFailure();
            if (th.getMessage() == null) {
                return ResultBuilder.createGemFireErrorResult("An error occurred while revoking missing disk stores: " + th);
            }
            return ResultBuilder.createGemFireErrorResult("An error occurred while revoking missing disk stores: " + th.getMessage());
        }
    }
}

