/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.DataCommandsUtils;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.DataCommandRequest;
import org.apache.geode.management.internal.cli.domain.DataCommandResult;
import org.apache.geode.management.internal.cli.functions.DataCommandFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class PutCommand
implements GfshCommand {
    @CliMetaData(relatedTopic={"Data", "Region"})
    @CliCommand(value={"put"}, help="Add/Update an entry in a region. If using a region whose key and value classes have been set, then specifying --key-class and --value-class is unnecessary.")
    public Result put(@CliOption(key={"key"}, mandatory=true, help="String or JSON text from which to create the key.  Examples include: \"James\", \"100L\" and \"('id': 'l34s')\".") String key, @CliOption(key={"value"}, mandatory=true, help="String or JSON text from which to create the value.  Examples include: \"manager\", \"100L\" and \"('value': 'widget')\".") String value, @CliOption(key={"region"}, mandatory=true, help="Region into which the entry will be put.", optionContext="geode.converter.region.path:disable-string-converter") String regionPath, @CliOption(key={"key-class"}, help="Fully qualified class name of the key's type. The default is java.lang.String.") String keyClass, @CliOption(key={"value-class"}, help="Fully qualified class name of the value's type. The default is java.lang.String.") String valueClass, @CliOption(key={"skip-if-exists"}, help="(Deprecated: Use --if-not-exists). Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean putIfAbsent, @CliOption(key={"if-not-exists"}, help="Skip the put operation when an entry with the same key already exists. The default is to overwrite the entry (false).", specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean putIfNotExists) {
        DataCommandResult dataResult;
        InternalCache cache = this.getCache();
        cache.getSecurityService().authorize(ResourcePermission.Resource.DATA, ResourcePermission.Operation.WRITE, regionPath);
        Region region = cache.getRegion(regionPath);
        DataCommandFunction putfn = new DataCommandFunction();
        if (region == null) {
            Set<DistributedMember> memberList = this.findAnyMembersForRegion(this.getCache(), regionPath);
            if (CollectionUtils.isNotEmpty(memberList)) {
                DataCommandRequest request = new DataCommandRequest();
                request.setCommand("put");
                request.setValue(value);
                request.setKey(key);
                request.setKeyClass(keyClass);
                request.setRegionName(regionPath);
                request.setValueClass(valueClass);
                request.setPutIfAbsent(putIfNotExists || putIfAbsent);
                dataResult = DataCommandsUtils.callFunctionForRegion(request, putfn, memberList);
            } else {
                dataResult = DataCommandResult.createPutInfoResult(key, value, null, CliStrings.format("Region <{0}> not found in any of the members", (Object)regionPath), false);
            }
        } else {
            dataResult = putfn.put(key, value, putIfNotExists || putIfAbsent, keyClass, valueClass, regionPath, cache);
        }
        dataResult.setKeyClass(keyClass);
        if (valueClass != null) {
            dataResult.setValueClass(valueClass);
        }
        return DataCommandsUtils.makePresentationResult(dataResult);
    }
}

