/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.TreeSet;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.MembershipManager;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ListMembersCommand
implements GfshCommand {
    @CliCommand(value={"list members"}, help="Display all or a subset of members.")
    @CliMetaData(relatedTopic={"Server"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result listMember(@CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group name for which members will be displayed.") String[] groups) {
        TreeSet<DistributedMember> memberSet = new TreeSet<DistributedMember>();
        memberSet.addAll(this.findMembersIncludingLocators(groups, null));
        if (memberSet.isEmpty()) {
            return ResultBuilder.createInfoResult("No Members Found");
        }
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        DistributedMember coordinatorMember = this.getCoordinator();
        for (DistributedMember member : memberSet) {
            resultData.accumulate("Name", member.getName());
            if (member == coordinatorMember) {
                resultData.accumulate("Id", member.getId() + " [Coordinator]");
                continue;
            }
            resultData.accumulate("Id", member.getId());
        }
        return ResultBuilder.buildResult(resultData);
    }

    DistributedMember getCoordinator() {
        InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
        if (ids == null || !ids.isConnected()) {
            return null;
        }
        MembershipManager mmgr = ids.getDistributionManager().getMembershipManager();
        if (mmgr == null) {
            return null;
        }
        return mmgr.getCoordinator();
    }
}

