/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.springframework.shell.core.CommandMarker;

public interface GfshCommand
extends CommandMarker {
    public static final String EXPERIMENTAL = "(Experimental) ";

    default public boolean isConnectedAndReady() {
        return this.getGfsh() != null && this.getGfsh().isConnectedAndReady();
    }

    default public ClusterConfigurationService getSharedConfiguration() {
        InternalLocator locator = InternalLocator.getLocator();
        return locator == null ? null : locator.getSharedConfiguration();
    }

    default public void persistClusterConfiguration(Result result, Runnable runnable) {
        if (result == null) {
            throw new IllegalArgumentException("Result should not be null");
        }
        ClusterConfigurationService sc = this.getSharedConfiguration();
        if (sc == null) {
            result.setCommandPersisted(false);
        } else {
            runnable.run();
            result.setCommandPersisted(true);
        }
    }

    default public XmlEntity findXmlEntity(List<CliFunctionResult> functionResults) {
        return functionResults.stream().filter(CliFunctionResult::isSuccessful).map(CliFunctionResult::getXmlEntity).filter(Objects::nonNull).findFirst().orElse(null);
    }

    default public boolean isDebugging() {
        return this.getGfsh() != null && this.getGfsh().getDebug();
    }

    default public boolean isLogging() {
        return this.getGfsh() != null;
    }

    default public InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    default public SecurityService getSecurityService() {
        return this.getCache().getSecurityService();
    }

    default public Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    default public DistributedMember getMember(String memberName) {
        DistributedMember member = this.findMember(memberName);
        if (member == null) {
            throw new EntityNotFoundException(CliStrings.format("Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberName));
        }
        return member;
    }

    default public DistributedMember findMember(String memberName) {
        return CliUtil.getDistributedMemberByNameOrId(memberName, this.getCache());
    }

    default public Set<DistributedMember> getAllMembers(InternalCache cache) {
        return CliUtil.getAllMembers(cache);
    }

    default public Set<DistributedMember> getAllNormalMembers(InternalCache cache) {
        return CliUtil.getAllNormalMembers(cache);
    }

    default public Execution getMembersFunctionExecutor(Set<DistributedMember> members) {
        return FunctionService.onMembers(members);
    }

    default public Set<DistributedMember> findMembers(String[] groups, String[] members) {
        return CliUtil.findMembers(groups, members, this.getCache());
    }

    default public Set<DistributedMember> getMembers(String[] groups, String[] members) {
        Set<DistributedMember> matchingMembers = this.findMembers(groups, members);
        if (matchingMembers.size() == 0) {
            throw new EntityNotFoundException("No Members Found");
        }
        return matchingMembers;
    }

    default public Set<DistributedMember> findMembersIncludingLocators(String[] groups, String[] members) {
        return CliUtil.findMembersIncludingLocators(groups, members, this.getCache());
    }

    default public Set<DistributedMember> getMembersIncludingLocators(String[] groups, String[] members) {
        Set<DistributedMember> matchingMembers = this.findMembersIncludingLocators(groups, members);
        if (matchingMembers.size() == 0) {
            throw new EntityNotFoundException("No Members Found");
        }
        return matchingMembers;
    }

    default public ManagementService getManagementService() {
        return ManagementService.getExistingManagementService(this.getCache());
    }

    default public Set<DistributedMember> findMembersForRegion(InternalCache cache, String regionPath) {
        return CliUtil.getRegionAssociatedMembers(regionPath, cache, true);
    }

    default public ResultCollector<?, ?> executeFunction(Function function, Object args, Set<DistributedMember> targetMembers) {
        return CliUtil.executeFunction(function, args, targetMembers);
    }

    default public ResultCollector<?, ?> executeFunction(Function function, Object args, DistributedMember targetMember) {
        return this.executeFunction(function, args, Collections.singleton(targetMember));
    }

    default public List<CliFunctionResult> executeAndGetFunctionResult(Function function, Object args, Set<DistributedMember> targetMembers) {
        ResultCollector<?, ?> rc = this.executeFunction(function, args, targetMembers);
        return CliFunctionResult.cleanResults((List)rc.getResult());
    }

    default public Set<DistributedMember> findAnyMembersForRegion(InternalCache cache, String regionPath) {
        return CliUtil.getRegionAssociatedMembers(regionPath, cache, false);
    }

    default public Set<DistributedMember> findMembersWithAsyncEventQueue(String queueId) {
        return CliUtil.getMembersWithAsyncEventQueue(this.getCache(), queueId);
    }
}

