/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterConfigurationService;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.logging.LogService;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.AbstractCliAroundInterceptor;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.remote.CommandExecutionContext;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ErrorResultData;
import org.apache.geode.management.internal.cli.result.FileResult;
import org.apache.geode.management.internal.cli.result.InfoResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.functions.GetRegionNamesFunction;
import org.apache.geode.management.internal.configuration.functions.RecreateCacheFunction;
import org.apache.geode.management.internal.configuration.utils.ZipUtils;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.apache.logging.log4j.Logger;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.xml.sax.SAXException;

public class ExportImportClusterConfigurationCommands
implements GfshCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"export cluster-configuration"}, help="Exports the cluster configuration artifacts as a zip file.")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportClusterConfigurationCommands$ExportInterceptor", relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.READ)
    public Result exportSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="Path to the zip file containing the exported cluster configuration artifacts") String zipFileName) {
        CommandResult result;
        Path tempDir;
        InternalLocator locator = InternalLocator.getLocator();
        if (locator == null || !locator.isSharedConfigurationRunning()) {
            return ResultBuilder.createGemFireErrorResult("Cluster configuration service is enabled but has not started yet.");
        }
        try {
            tempDir = Files.createTempDirectory("clusterConfig", new FileAttribute[0]);
        }
        catch (IOException e) {
            if (Gfsh.getCurrentInstance() != null) {
                Gfsh.getCurrentInstance().logSevere(e.getMessage(), e);
            }
            ErrorResultData errorData = ResultBuilder.createErrorResultData().addLine("Unable to create temp directory");
            return ResultBuilder.buildResult(errorData);
        }
        File zipFile = tempDir.resolve("exportedCC.zip").toFile();
        ClusterConfigurationService sc = locator.getSharedConfiguration();
        try {
            for (Configuration config : sc.getConfigurationRegion().values()) {
                sc.writeConfigToFile(config);
            }
            ZipUtils.zipDirectory(sc.getSharedConfigurationDirPath(), zipFile.getCanonicalPath());
            InfoResultData infoData = ResultBuilder.createInfoResultData();
            byte[] byteData = FileUtils.readFileToByteArray((File)zipFile);
            infoData.addAsFile(zipFileName, byteData, 0, "Downloading cluster configuration : {0}", false);
            result = ResultBuilder.buildResult(infoData);
        }
        catch (Exception e) {
            ErrorResultData errorData = ResultBuilder.createErrorResultData();
            errorData.addLine("Export failed");
            if (Gfsh.getCurrentInstance() != null) {
                Gfsh.getCurrentInstance().logSevere(e.getMessage(), e);
            }
            result = ResultBuilder.buildResult(errorData);
        }
        finally {
            zipFile.delete();
        }
        return result;
    }

    @CliCommand(value={"import cluster-configuration"}, help="Imports configuration into cluster configuration hosted at the locators")
    @CliMetaData(interceptor="org.apache.geode.management.internal.cli.commands.ExportImportClusterConfigurationCommands$ImportInterceptor", isFileUploaded=true, relatedTopic={"Configuration"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE)
    public Result importSharedConfig(@CliOption(key={"zip-file-name"}, mandatory=true, help="The zip file containing the cluster configuration artifacts, which are to be imported") String zip) throws IOException, TransformerException, SAXException, ParserConfigurationException {
        InternalLocator locator = InternalLocator.getLocator();
        if (!locator.isSharedConfigurationRunning()) {
            ErrorResultData errorData = ResultBuilder.createErrorResultData();
            errorData.addLine("Cluster configuration service is enabled but has not started yet.");
            return ResultBuilder.buildResult(errorData);
        }
        InternalCache cache = this.getCache();
        Set<DistributedMember> servers = CliUtil.getAllNormalMembers(cache);
        Set regionsWithData = servers.stream().map(this::getRegionNamesOnServer).flatMap(Collection::stream).collect(Collectors.toSet());
        if (!regionsWithData.isEmpty()) {
            return ResultBuilder.createGemFireErrorResult("Cannot import cluster configuration with existing regions: " + regionsWithData.stream().collect(Collectors.joining(",")));
        }
        List<String> filePathFromShell = CommandExecutionContext.getFilePathFromShell();
        InfoResultData infoData = ResultBuilder.createInfoResultData();
        String zipFilePath = filePathFromShell.get(0);
        ClusterConfigurationService sc = locator.getSharedConfiguration();
        for (Configuration config : sc.getConfigurationRegion().values()) {
            sc.writeConfigToFile(config);
        }
        sc.renameExistingSharedConfigDirectory();
        ZipUtils.unzip(zipFilePath, sc.getSharedConfigurationDirPath());
        sc.loadSharedConfigurationFromDisk();
        infoData.addLine("Cluster configuration successfully imported");
        Set functionResults = servers.stream().map(this::reCreateCache).collect(Collectors.toSet());
        for (CliFunctionResult functionResult : functionResults) {
            if (functionResult.isSuccessful()) {
                infoData.addLine("Successfully applied the imported cluster configuration on " + functionResult.getMemberIdOrName());
                continue;
            }
            infoData.addLine("Failed to apply the imported cluster configuration on " + functionResult.getMemberIdOrName() + " due to " + functionResult.getMessage());
        }
        CommandResult result = ResultBuilder.buildResult(infoData);
        return result;
    }

    private Set<String> getRegionNamesOnServer(DistributedMember server) {
        ResultCollector<?, ?> rc = this.executeFunction((Function)new GetRegionNamesFunction(), null, server);
        List results = (List)rc.getResult();
        return (Set)results.get(0);
    }

    private CliFunctionResult reCreateCache(DistributedMember server) {
        ResultCollector<?, ?> rc = this.executeFunction((Function)new RecreateCacheFunction(), null, server);
        List results = (List)rc.getResult();
        return (CliFunctionResult)results.get(0);
    }

    public static class ImportInterceptor
    extends AbstractCliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String zip = parseResult.getParamValueAsString("zip-file-name");
            if ((zip = StringUtils.trim((String)zip)) == null) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Parameter \"{0}\"  is required. Use \"help <command name>\" for assistance.", (Object)"zip-file-name"));
            }
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            FileResult fileResult = new FileResult();
            File zipFile = new File(zip);
            if (!zipFile.exists()) {
                return ResultBuilder.createUserErrorResult(zip + " not found");
            }
            fileResult.addFile(zipFile);
            return fileResult;
        }
    }

    public static class ExportInterceptor
    extends AbstractCliAroundInterceptor {
        private String saveDirString;
        private static final Logger logger = LogService.getLogger();

        @Override
        public Result preExecution(GfshParseResult parseResult) {
            String zip = parseResult.getParamValueAsString("zip-file-name");
            if (!zip.endsWith(".zip")) {
                return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid file type, the file extension must be \"{0}\"", (Object)".zip"));
            }
            return ResultBuilder.createInfoResult("OK");
        }

        @Override
        public Result postExecution(GfshParseResult parseResult, Result commandResult, Path tempFile) {
            if (commandResult.hasIncomingFiles()) {
                try {
                    commandResult.saveIncomingFiles(System.getProperty("user.dir"));
                    return commandResult;
                }
                catch (IOException ioex) {
                    logger.error((Object)ioex);
                    return ResultBuilder.createShellClientErrorResult("Unable to export config: " + ioex.getMessage());
                }
            }
            return null;
        }
    }
}

