/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliAroundInterceptor;
import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.UserFunctionExecution;
import org.apache.geode.management.internal.cli.result.CompositeResultData;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.cli.result.TabularResultData;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ExecuteFunctionCommand
implements GfshCommand {
    @CliCommand(value={"execute function"}, help="Execute the function with the specified ID. By default will execute on all members.")
    @CliMetaData(relatedTopic={"Function Execution"}, interceptor="org.apache.geode.management.internal.cli.commands.ExecuteFunctionCommand$ExecuteFunctionCommandInterceptor")
    public Result executeFunction(@CliOption(key={"id"}, mandatory=true, help="ID of the function to execute.") String functionId, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Groups of members on which the function will be executed.") String[] onGroups, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member on which the function will be executed.") String[] onMembers, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Region on which the data dependent function will be executed.") String onRegion, @CliOption(key={"arguments"}, help="Arguments to the function in comma separated String format.") String[] arguments, @CliOption(key={"result-collector"}, help="Fully qualified class name of the ResultCollector to instantiate for gathering results.") String resultCollector, @CliOption(key={"filter"}, help="Key list which causes the function to only be executed on members which have entries with these keys.") String filterString) {
        CompositeResultData executeFunctionResultTable = ResultBuilder.createCompositeResultData();
        TabularResultData resultTable = executeFunctionResultTable.addSection().addTable("Table1");
        String headerText = "Execution summary";
        resultTable.setHeader(headerText);
        Set<DistributedMember> dsMembers = onRegion == null ? this.findMembers(onGroups, onMembers) : this.findMembersForRegion(this.getCache(), onRegion);
        if (dsMembers.size() == 0) {
            return ResultBuilder.createUserErrorResult("No members found.");
        }
        Object[] args = new Object[6];
        args[0] = functionId;
        if (filterString != null) {
            args[1] = filterString;
        }
        if (resultCollector != null) {
            args[2] = resultCollector;
        }
        if (arguments != null && arguments.length > 0) {
            args[3] = "";
            for (String str : arguments) {
                if (str == null) continue;
                args[3] = args[3] + str + ",";
            }
        }
        args[4] = onRegion;
        Subject currentUser = this.getSecurityService().getSubject();
        args[5] = currentUser != null ? currentUser.getSession().getAttribute((Object)"credentials") : null;
        List<CliFunctionResult> results = this.executeAndGetFunctionResult(new UserFunctionExecution(), args, dsMembers);
        for (CliFunctionResult r : results) {
            resultTable.accumulate("Member ID/Name", r.getMemberIdOrName());
            resultTable.accumulate("Function Execution Result", r.getMessage());
            if (r.isSuccessful()) continue;
            resultTable.setStatus(Result.Status.ERROR);
        }
        return ResultBuilder.buildResult(resultTable);
    }

    public static class ExecuteFunctionCommandInterceptor
    implements CliAroundInterceptor {
        @Override
        public Result preExecution(GfshParseResult parseResult) {
            boolean moreThanOne;
            String onRegion = parseResult.getParamValueAsString("region");
            String onMember = parseResult.getParamValueAsString("member");
            String onGroup = parseResult.getParamValueAsString("group");
            String filter = parseResult.getParamValueAsString("filter");
            boolean bl = moreThanOne = Stream.of(onRegion, onMember, onGroup).filter(Objects::nonNull).count() > 1L;
            if (moreThanOne) {
                return ResultBuilder.createUserErrorResult("Provide Only one of region/member/groups");
            }
            if (onRegion == null && filter != null) {
                return ResultBuilder.createUserErrorResult("Filters for executing on member or group is not supported.");
            }
            return ResultBuilder.createInfoResult("");
        }
    }
}

