/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.commands;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.management.cli.CliMetaData;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.CliUtil;
import org.apache.geode.management.internal.cli.commands.GfshCommand;
import org.apache.geode.management.internal.cli.domain.IndexInfo;
import org.apache.geode.management.internal.cli.functions.CliFunctionResult;
import org.apache.geode.management.internal.cli.functions.DestroyIndexFunction;
import org.apache.geode.management.internal.cli.i18n.CliStrings;
import org.apache.geode.management.internal.cli.result.CommandResult;
import org.apache.geode.management.internal.cli.result.ResultBuilder;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.security.ResourceOperation;
import org.apache.geode.security.ResourcePermission;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class DestroyIndexCommand
implements GfshCommand {
    private static final DestroyIndexFunction destroyIndexFunction = new DestroyIndexFunction();

    @CliCommand(value={"destroy index"}, help="Destroy/Remove the specified index.")
    @CliMetaData(relatedTopic={"Region", "Data"})
    @ResourceOperation(resource=ResourcePermission.Resource.CLUSTER, operation=ResourcePermission.Operation.MANAGE, target=ResourcePermission.Target.QUERY)
    public Result destroyIndex(@CliOption(key={"name"}, unspecifiedDefaultValue="", help="Name of the index to remove.") String indexName, @CliOption(key={"region"}, optionContext="geode.converter.region.path:disable-string-converter", help="Name/Path of the region from which the index will be removed.") String regionPath, @CliOption(key={"member", "members"}, optionContext="geode.converter.member.idOrName:disable-string-converter", help="Name/Id of the member from which the index will be removed.") String[] memberNameOrID, @CliOption(key={"group", "groups"}, optionContext="geode.converter.member.groups:disable-string-converter", help="Group of members from which the index will be removed.") String[] group, @CliOption(key={"if-exists"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="If true, the command will be a no-op if the entity does not exist.") boolean ifExists) {
        if (StringUtils.isBlank((String)indexName) && StringUtils.isBlank((String)regionPath) && ArrayUtils.isEmpty((Object[])group) && ArrayUtils.isEmpty((Object[])memberNameOrID)) {
            return ResultBuilder.createUserErrorResult(CliStrings.format("\"{0}\" requires that one or more parameters be provided.", (Object)"destroy index"));
        }
        String regionName = null;
        if (regionPath != null) {
            regionName = regionPath.startsWith("/") ? regionPath.substring(1) : regionPath;
        }
        IndexInfo indexInfo = new IndexInfo(indexName, regionName);
        indexInfo.setIfExists(ifExists);
        Set<DistributedMember> targetMembers = CliUtil.findMembers(group, memberNameOrID, this.getCache());
        if (targetMembers.isEmpty()) {
            return ResultBuilder.createUserErrorResult("No Members Found");
        }
        List<CliFunctionResult> funcResults = this.executeAndGetFunctionResult(destroyIndexFunction, indexInfo, targetMembers);
        CommandResult result = ResultBuilder.buildResult(funcResults);
        XmlEntity xmlEntity = this.findXmlEntity(funcResults);
        if (xmlEntity != null) {
            this.persistClusterConfiguration(result, () -> this.getSharedConfiguration().deleteXmlEntity(xmlEntity, group));
        }
        return result;
    }
}

